/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.compat.mojang;

import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import com.gtnewhorizons.angelica.rendering.RenderingState;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.MathHelper;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class Camera {
    public static final Camera INSTANCE = new Camera();
    private final Vector3d pos = new Vector3d();
    private final BlockPos blockPos = new BlockPos();
    private final Vector3f offset = new Vector3f();
    private final Matrix4f inverseModelView = new Matrix4f();
    private float pitch;
    private float yaw;
    private EntityLivingBase entity;
    private boolean thirdPerson;
    private float partialTicks;

    private Camera() {
    }

    public void update(EntityLivingBase entity, float partialTicks) {
        this.partialTicks = partialTicks;
        this.entity = entity;
        double entityX = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
        double entityY = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
        double entityZ = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
        double eyeHeight = entity.func_70047_e();
        this.thirdPerson = Minecraft.func_71410_x().field_71474_y.field_74320_O > 0;
        this.offset.set(0.0f, 0.0f, 0.0f);
        if (this.thirdPerson) {
            this.inverseModelView.set((Matrix4fc)RenderingState.INSTANCE.getModelViewMatrix()).invert();
            this.inverseModelView.transformPosition(this.offset);
        }
        double camX = entityX + (double)this.offset.x;
        double camY = entityY + eyeHeight + (double)this.offset.y;
        double camZ = entityZ + (double)this.offset.z;
        this.pos.set(camX, camY, camZ);
        this.blockPos.set(MathHelper.func_76128_c((double)camX), MathHelper.func_76128_c((double)camY), MathHelper.func_76128_c((double)camZ));
        this.pitch = entity.field_70726_aT;
        this.yaw = entity.field_70177_z;
    }

    @Generated
    public Vector3d getPos() {
        return this.pos;
    }

    @Generated
    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Generated
    public Vector3f getOffset() {
        return this.offset;
    }

    @Generated
    public Matrix4f getInverseModelView() {
        return this.inverseModelView;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public EntityLivingBase getEntity() {
        return this.entity;
    }

    @Generated
    public boolean isThirdPerson() {
        return this.thirdPerson;
    }

    @Generated
    public float getPartialTicks() {
        return this.partialTicks;
    }
}

