/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.client.font;

import com.google.common.collect.HashMultiset;
import com.gtnewhorizons.angelica.client.font.BatchingFontRenderer;
import com.gtnewhorizons.angelica.client.font.FontProvider;
import com.gtnewhorizons.angelica.client.font.FontProviderCustom;
import com.gtnewhorizons.angelica.client.font.FontProviderMC;
import com.gtnewhorizons.angelica.client.font.FontProviderUnicode;
import com.gtnewhorizons.angelica.config.FontConfig;
import com.gtnewhorizons.angelica.mixins.interfaces.ResourceAccessor;
import cpw.mods.fml.client.SplashProgress;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.DefaultResourcePack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FontStrategist {
    private static final Font[] availableFonts;
    public static final Logger LOGGER;

    public static FontProvider getFontProvider(BatchingFontRenderer me, char chr, boolean customFontEnabled, boolean forceUnicode) {
        if (me.isSGA && FontProviderMC.get(true).isGlyphAvailable(chr)) {
            return FontProviderMC.get(true);
        }
        if (customFontEnabled && !me.isSplash) {
            FontProviderCustom fp = FontProviderCustom.getPrimary();
            if (fp.isGlyphAvailable(chr)) {
                return fp;
            }
            fp = FontProviderCustom.getFallback();
            if (fp.isGlyphAvailable(chr)) {
                return fp;
            }
            return FontProviderUnicode.get();
        }
        if (!forceUnicode && FontProviderMC.get(false).isGlyphAvailable(chr)) {
            return FontProviderMC.get(false);
        }
        return FontProviderUnicode.get();
    }

    public static void reloadCustomFontProviders() {
        FontProviderCustom.getPrimary().setFont(null);
        FontProviderCustom.getFallback().setFont(null);
        for (int i = 0; i < availableFonts.length; ++i) {
            if (Objects.equals(FontConfig.customFontNamePrimary, availableFonts[i].getFontName())) {
                FontProviderCustom.getPrimary().reloadFont(i);
            }
            if (!Objects.equals(FontConfig.customFontNameFallback, availableFonts[i].getFontName())) continue;
            FontProviderCustom.getFallback().reloadFont(i);
        }
    }

    public static boolean isSplashFontRendererActive(FontRenderer fontRenderer) {
        boolean active = fontRenderer instanceof SplashProgress.SplashFontRenderer;
        try {
            Class<?> customSplashClass = Class.forName("gkappa.modernsplash.CustomSplash$SplashFontRenderer");
            active = active || customSplashClass.isInstance(fontRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return active;
    }

    @Generated
    public static Font[] getAvailableFonts() {
        return availableFonts;
    }

    static {
        LOGGER = LogManager.getLogger((String)"Angelica");
        Font[] availableFontsDirty = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        HashMap<String, Font> fontSet = new HashMap<String, Font>();
        HashMultiset duplicates = HashMultiset.create();
        for (Font font : availableFontsDirty) {
            String fontName = font.getFontName();
            if (fontSet.containsKey(fontName)) {
                duplicates.add((Object)fontName);
                continue;
            }
            fontSet.put(fontName, font);
        }
        if (!duplicates.isEmpty()) {
            StringBuilder sb = new StringBuilder(duplicates.size() + " duplicate font(s) found in the list reported by Java: ");
            Iterator iter = duplicates.stream().distinct().iterator();
            while (iter.hasNext()) {
                String dupe = (String)iter.next();
                sb.append(duplicates.count((Object)dupe)).append("x ").append(dupe);
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(". Some fonts may be missing from the font selection menu.");
            LOGGER.warn(sb.toString());
        }
        availableFonts = (Font[])fontSet.values().stream().sorted(Comparator.comparing(Font::getFontName)).toArray(Font[]::new);
        HashMap<String, File> packMap = new HashMap<String, File>();
        for (int i = 0; i < 512; ++i) {
            packMap.put(FontProviderCustom.getPrimary().getAtlasResourceName(i), new File(FontProviderCustom.getPrimary().getAtlasFullPath(i)));
            packMap.put(FontProviderCustom.getFallback().getAtlasResourceName(i), new File(FontProviderCustom.getFallback().getAtlasFullPath(i)));
        }
        DefaultResourcePack fontResourcePack = new DefaultResourcePack(packMap);
        List defaultResourcePacks = ((ResourceAccessor)Minecraft.func_71410_x()).angelica$getDefaultResourcePacks();
        defaultResourcePacks.add(fontResourcePack);
        Minecraft.func_71410_x().func_110436_a();
    }
}

