/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.world;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.registry.VillagerRegistry;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.particle.EntityAuraFX;
import net.minecraft.client.particle.EntityBreakingFX;
import net.minecraft.client.particle.EntityBubbleFX;
import net.minecraft.client.particle.EntityCloudFX;
import net.minecraft.client.particle.EntityCritFX;
import net.minecraft.client.particle.EntityDropParticleFX;
import net.minecraft.client.particle.EntityEnchantmentTableParticleFX;
import net.minecraft.client.particle.EntityExplodeFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityFireworkSparkFX;
import net.minecraft.client.particle.EntityFlameFX;
import net.minecraft.client.particle.EntityFootStepFX;
import net.minecraft.client.particle.EntityHeartFX;
import net.minecraft.client.particle.EntityHugeExplodeFX;
import net.minecraft.client.particle.EntityLargeExplodeFX;
import net.minecraft.client.particle.EntityLavaFX;
import net.minecraft.client.particle.EntityNoteFX;
import net.minecraft.client.particle.EntityPortalFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.particle.EntitySmokeFX;
import net.minecraft.client.particle.EntitySnowShovelFX;
import net.minecraft.client.particle.EntitySpellParticleFX;
import net.minecraft.client.particle.EntitySplashFX;
import net.minecraft.client.particle.EntitySuspendFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import tconstruct.tools.TinkerTools;
import tconstruct.world.TinkerWorld;
import tconstruct.world.TinkerWorldProxyCommon;
import tconstruct.world.entity.BlueSlime;
import tconstruct.world.entity.KingBlueSlime;
import tconstruct.world.model.BarricadeRender;
import tconstruct.world.model.OreberryRender;
import tconstruct.world.model.PunjiRender;
import tconstruct.world.model.RenderLandmine;
import tconstruct.world.model.SlimeChannelRender;
import tconstruct.world.model.SlimePadRender;
import tconstruct.world.model.SlimeRender;

public class TinkerWorldProxyClient
extends TinkerWorldProxyCommon {
    Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void initialize() {
        this.registerRenderer();
        this.registerManualIcons();
        this.registerManualRecipes();
    }

    void registerRenderer() {
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new OreberryRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BarricadeRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderLandmine());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new PunjiRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new SlimeChannelRender());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new SlimePadRender());
        SlimeRender slimeRender = new SlimeRender((ModelBase)new ModelSlime(16), (ModelBase)new ModelSlime(0), 0.25f);
        RenderingRegistry.registerEntityRenderingHandler(BlueSlime.class, (Render)slimeRender);
        RenderingRegistry.registerEntityRenderingHandler(KingBlueSlime.class, (Render)slimeRender);
        VillagerRegistry.instance().registerVillagerSkin(78943, new ResourceLocation("tinker", "textures/mob/villagertools.png"));
    }

    void registerManualIcons() {
    }

    void registerManualRecipes() {
        ItemStack netherrack = new ItemStack(Blocks.field_150424_aL);
        ItemStack coal = new ItemStack(Items.field_151044_h);
        ItemStack log = new ItemStack(Blocks.field_150364_r, 1, 0);
        ItemStack graveyardsoil = new ItemStack(TinkerTools.craftedSoil, 1, 3);
        ItemStack consecratedsoil = new ItemStack(TinkerTools.craftedSoil, 1, 4);
        MantleClientRegistry.registerManualSmallRecipe((String)"slimechannel", (ItemStack)new ItemStack(TinkerWorld.slimeChannel, 1, 0), (ItemStack[])new ItemStack[]{new ItemStack(TinkerWorld.slimeGel, 1, 0), new ItemStack(Items.field_151137_ax), null, null});
        MantleClientRegistry.registerManualSmallRecipe((String)"bouncepad", (ItemStack)new ItemStack(TinkerWorld.slimePad, 1, 0), (ItemStack[])new ItemStack[]{new ItemStack(TinkerWorld.slimeChannel), new ItemStack(Items.field_151123_aH), null, null});
        MantleClientRegistry.registerManualSmallRecipe((String)"graveyardsoil", (ItemStack)graveyardsoil, (ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150346_d), new ItemStack(Items.field_151078_bh), new ItemStack(Items.field_151100_aR, 1, 15), null});
        MantleClientRegistry.registerManualFurnaceRecipe((String)"consecratedsoil", (ItemStack)consecratedsoil, (ItemStack)graveyardsoil);
        ItemStack reed = new ItemStack(Items.field_151120_aE);
        MantleClientRegistry.registerManualLargeRecipe((String)"punji", (ItemStack)new ItemStack(TinkerWorld.punji, 5), (ItemStack[])new ItemStack[]{reed, null, reed, null, reed, null, reed, null, reed});
        MantleClientRegistry.registerManualSmallRecipe((String)"barricade", (ItemStack)new ItemStack(TinkerWorld.barricadeOak), (ItemStack[])new ItemStack[]{null, log, null, log});
    }

    @Override
    public void spawnParticle(String particle, double xPos, double yPos, double zPos, double velX, double velY, double velZ) {
        this.doSpawnParticle(particle, xPos, yPos, zPos, velX, velY, velZ);
    }

    public EntityFX doSpawnParticle(String par1Str, double par2, double par4, double par6, double par8, double par10, double par12) {
        if (this.mc == null) {
            this.mc = Minecraft.func_71410_x();
        }
        if (this.mc.field_71451_h != null && this.mc.field_71452_i != null) {
            int i = this.mc.field_71474_y.field_74362_aa;
            if (i == 1 && this.mc.field_71441_e.field_73012_v.nextInt(3) == 0) {
                i = 2;
            }
            double d6 = this.mc.field_71451_h.field_70165_t - par2;
            double d7 = this.mc.field_71451_h.field_70163_u - par4;
            double d8 = this.mc.field_71451_h.field_70161_v - par6;
            EntityHugeExplodeFX entityfx = null;
            switch (par1Str) {
                case "hugeexplosion": {
                    entityfx = new EntityHugeExplodeFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    this.mc.field_71452_i.func_78873_a((EntityFX)entityfx);
                    break;
                }
                case "largeexplode": {
                    entityfx = new EntityLargeExplodeFX(this.mc.field_71446_o, (World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    this.mc.field_71452_i.func_78873_a((EntityFX)entityfx);
                    break;
                }
                case "fireworksSpark": {
                    entityfx = new EntityFireworkSparkFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12, this.mc.field_71452_i);
                    this.mc.field_71452_i.func_78873_a((EntityFX)entityfx);
                }
            }
            if (entityfx != null) {
                return entityfx;
            }
            double d9 = 16.0;
            if (d6 * d6 + d7 * d7 + d8 * d8 > d9 * d9) {
                return null;
            }
            if (i > 1) {
                return null;
            }
            switch (par1Str) {
                case "bubble": {
                    entityfx = new EntityBubbleFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "suspended": {
                    entityfx = new EntitySuspendFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "depthsuspend": 
                case "townaura": {
                    entityfx = new EntityAuraFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "crit": {
                    entityfx = new EntityCritFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "smoke": {
                    entityfx = new EntitySmokeFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "mobSpell": {
                    entityfx = new EntitySpellParticleFX((World)this.mc.field_71441_e, par2, par4, par6, 0.0, 0.0, 0.0);
                    entityfx.func_70538_b((float)par8, (float)par10, (float)par12);
                    break;
                }
                case "mobSpellAmbient": {
                    entityfx = new EntitySpellParticleFX((World)this.mc.field_71441_e, par2, par4, par6, 0.0, 0.0, 0.0);
                    entityfx.func_82338_g(0.15f);
                    entityfx.func_70538_b((float)par8, (float)par10, (float)par12);
                    break;
                }
                case "spell": {
                    entityfx = new EntitySpellParticleFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "instantSpell": {
                    entityfx = new EntitySpellParticleFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    ((EntitySpellParticleFX)entityfx).func_70589_b(144);
                    break;
                }
                case "witchMagic": {
                    entityfx = new EntitySpellParticleFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    ((EntitySpellParticleFX)entityfx).func_70589_b(144);
                    float f = this.mc.field_71441_e.field_73012_v.nextFloat() * 0.5f + 0.35f;
                    entityfx.func_70538_b(1.0f * f, 0.0f * f, 1.0f * f);
                    break;
                }
                case "note": {
                    entityfx = new EntityNoteFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "portal": {
                    entityfx = new EntityPortalFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "enchantmenttable": {
                    entityfx = new EntityEnchantmentTableParticleFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "explode": {
                    entityfx = new EntityExplodeFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "flame": {
                    entityfx = new EntityFlameFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "lava": {
                    entityfx = new EntityLavaFX((World)this.mc.field_71441_e, par2, par4, par6);
                    break;
                }
                case "footstep": {
                    entityfx = new EntityFootStepFX(this.mc.field_71446_o, (World)this.mc.field_71441_e, par2, par4, par6);
                    break;
                }
                case "splash": {
                    entityfx = new EntitySplashFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "largesmoke": {
                    entityfx = new EntitySmokeFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12, 2.5f);
                    break;
                }
                case "cloud": {
                    entityfx = new EntityCloudFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "reddust": {
                    entityfx = new EntityReddustFX((World)this.mc.field_71441_e, par2, par4, par6, (float)par8, (float)par10, (float)par12);
                    break;
                }
                case "snowballpoof": {
                    entityfx = new EntityBreakingFX((World)this.mc.field_71441_e, par2, par4, par6, Items.field_151126_ay);
                    break;
                }
                case "dripWater": {
                    entityfx = new EntityDropParticleFX((World)this.mc.field_71441_e, par2, par4, par6, Material.field_151586_h);
                    break;
                }
                case "dripLava": {
                    entityfx = new EntityDropParticleFX((World)this.mc.field_71441_e, par2, par4, par6, Material.field_151587_i);
                    break;
                }
                case "snowshovel": {
                    entityfx = new EntitySnowShovelFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "blueslime": {
                    entityfx = new EntityBreakingFX((World)this.mc.field_71441_e, par2, par4, par6, TinkerWorld.strangeFood);
                    break;
                }
                case "heart": {
                    entityfx = new EntityHeartFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    break;
                }
                case "angryVillager": {
                    entityfx = new EntityHeartFX((World)this.mc.field_71441_e, par2, par4 + 0.5, par6, par8, par10, par12);
                    entityfx.func_70536_a(81);
                    entityfx.func_70538_b(1.0f, 1.0f, 1.0f);
                    break;
                }
                case "happyVillager": {
                    entityfx = new EntityAuraFX((World)this.mc.field_71441_e, par2, par4, par6, par8, par10, par12);
                    entityfx.func_70536_a(82);
                    entityfx.func_70538_b(1.0f, 1.0f, 1.0f);
                }
            }
            if (entityfx != null) {
                this.mc.field_71452_i.func_78873_a((EntityFX)entityfx);
            }
            return entityfx;
        }
        return null;
    }
}

