/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.smeltery.itemblocks;

import java.util.List;
import mantle.blocks.abstracts.MultiItemBlock;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class LavaTankItemBlock
extends MultiItemBlock
implements IFluidContainerItem {
    public static final String[] blockTypes = new String[]{"Tank", "Gague", "Window"};

    public LavaTankItemBlock(Block b) {
        super(b, "LavaTank", blockTypes);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (stack.func_77942_o()) {
            NBTTagCompound liquidTag = stack.func_77978_p().func_74775_l("Fluid");
            if (liquidTag != null) {
                list.add(StatCollector.func_74838_a((String)"searedtank1.tooltip") + " " + StatCollector.func_74838_a((String)liquidTag.func_74779_i("FluidName")));
                list.add(liquidTag.func_74762_e("Amount") + " mB");
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"searedtank3.tooltip"));
            list.add(StatCollector.func_74838_a((String)"searedtank2.tooltip"));
        }
    }

    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound nbt;
        if (container.func_77942_o() && (nbt = container.func_77978_p()).func_74764_b("Fluid")) {
            return FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("Fluid"));
        }
        return null;
    }

    public void setFluid(ItemStack container, FluidStack resource) {
        if (container == null) {
            return;
        }
        if (resource != null && 0 < resource.amount) {
            NBTTagCompound nbt = container.func_77978_p() != null ? container.func_77978_p() : new NBTTagCompound();
            nbt.func_74782_a("Fluid", (NBTBase)resource.writeToNBT(new NBTTagCompound()));
            container.func_77982_d(nbt);
            return;
        }
        NBTTagCompound nbt = container.func_77978_p();
        if (nbt == null) {
            return;
        }
        nbt.func_82580_o("Fluid");
        if (nbt.func_82582_d()) {
            nbt = null;
        }
        container.func_77982_d(nbt);
    }

    public int getCapacity(ItemStack container) {
        return 4000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (container.field_77994_a != 1) {
            return 0;
        }
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (fluidStack == null) {
            fluidStack = new FluidStack(resource, 0);
        }
        if (!fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(this.getCapacity(container) - fluidStack.amount, resource.amount);
        if (doFill && amount > 0) {
            fluidStack.amount += amount;
            this.setFluid(container, fluidStack);
        }
        return amount;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (container.field_77994_a != 1) {
            return null;
        }
        FluidStack fluidStack = this.getFluid(container);
        if (fluidStack == null || fluidStack.amount <= 0) {
            return null;
        }
        int drain = Math.min(fluidStack.amount, maxDrain);
        if (drain <= 0) {
            return null;
        }
        if (doDrain) {
            fluidStack.amount -= drain;
            this.setFluid(container, fluidStack);
        }
        return new FluidStack(fluidStack, drain);
    }
}

