/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui;

import java.util.List;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.icon.Icon;

public abstract class SimpleTextButton
extends Button {
    public SimpleTextButton(Panel panel, String txt, Icon icon) {
        super(panel, txt, icon);
        this.setWidth(panel.getGui().getTheme().getStringWidth(txt) + (this.hasIcon() ? 28 : 8));
        this.setHeight(20);
    }

    @Override
    public SimpleTextButton setTitle(String txt) {
        super.setTitle(txt);
        this.setWidth(this.getGui().getTheme().getStringWidth(this.getTitle()) + (this.hasIcon() ? 28 : 8));
        return this;
    }

    public boolean renderTitleInCenter() {
        return false;
    }

    @Override
    public Object getIngredientUnderMouse() {
        return this.icon.getIngredient();
    }

    public boolean hasIcon() {
        return !this.icon.isEmpty();
    }

    @Override
    public void addMouseOverText(List<String> list) {
        if (this.getGui().getTheme().getStringWidth(this.getTitle()) + (this.hasIcon() ? 28 : 8) > this.width) {
            list.add(this.getTitle());
        }
    }

    @Override
    public void draw(Theme theme, int x, int y, int w, int h) {
        this.drawBackground(theme, x, y, w, h);
        int s = h >= 16 ? 16 : 8;
        int off = (h - s) / 2;
        String title = this.getTitle();
        int textX = x;
        int textY = y + (h - theme.getFontHeight() + 1) / 2;
        int sw = theme.getStringWidth(title);
        int mw = w - (this.hasIcon() ? off + s : 0) - 6;
        if (sw > mw) {
            sw = mw;
            title = theme.trimStringToWidth(title, mw);
        }
        textX = this.renderTitleInCenter() ? (textX += (mw - sw + 6) / 2) : (textX += 4);
        if (this.hasIcon()) {
            this.drawIcon(theme, x + off, y + off, s, s);
            textX += off + s;
        }
        theme.drawString(title, textX, textY, theme.getContentColor(this.getWidgetType()), 2);
    }
}

