/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.ServerUtilitiesResourceType;
import serverutils.client.gui.GuiSidebar;
import serverutils.client.gui.SidebarButton;
import serverutils.client.gui.SidebarButtonGroup;
import serverutils.client.resource.IResourceType;
import serverutils.client.resource.ISelectiveResourceReloadListener;
import serverutils.events.SidebarButtonCreatedEvent;
import serverutils.lib.io.DataReader;
import serverutils.lib.util.JsonUtils;

public enum SidebarButtonManager implements ISelectiveResourceReloadListener
{
    INSTANCE;

    public final List<SidebarButtonGroup> groups = new ArrayList<SidebarButtonGroup>();
    private static final String SIDEBAR_BUTTONS_FILE = "sidebar_buttons.json";
    private static final String POSITION = "position";

    @Override
    public void onResourceManagerReload(IResourceManager manager, Predicate<IResourceType> resourcePredicate) {
        JsonElement json;
        JsonObject sidebarButtonConfig;
        if (!resourcePredicate.test(ServerUtilitiesResourceType.SERVERUTILS_CONFIG)) {
            return;
        }
        this.groups.clear();
        JsonElement element = DataReader.get(new File(Minecraft.func_71410_x().field_71412_D, "serverutilities/client/sidebar_buttons.json")).safeJson();
        if (element.isJsonObject()) {
            JsonObject o;
            sidebarButtonConfig = element.getAsJsonObject();
            if (sidebarButtonConfig.has(POSITION) && (o = sidebarButtonConfig.get(POSITION).getAsJsonObject()).has("posX") && o.has("posY")) {
                GuiSidebar.dragOffsetX = o.get("posX").getAsInt();
                GuiSidebar.dragOffsetY = o.get("posY").getAsInt();
            }
        } else {
            sidebarButtonConfig = new JsonObject();
        }
        HashMap<ResourceLocation, SidebarButtonGroup> groupMap = new HashMap<ResourceLocation, SidebarButtonGroup>();
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, "sidebar_button_groups.json"))) {
                    json = DataReader.get(resource).json();
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                        JsonObject groupJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                        int y = 0;
                        if (groupJson.has("y")) {
                            y = groupJson.get("y").getAsInt();
                        }
                        SidebarButtonGroup group = new SidebarButtonGroup(new ResourceLocation(domain, (String)entry.getKey()), y);
                        groupMap.put(group.getId(), group);
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (String domain : manager.func_135055_a()) {
            try {
                for (IResource resource : manager.func_135056_b(new ResourceLocation(domain, SIDEBAR_BUTTONS_FILE))) {
                    json = DataReader.get(resource).json();
                    if (!json.isJsonObject()) continue;
                    for (Map.Entry entry : json.getAsJsonObject().entrySet()) {
                        SidebarButtonGroup group;
                        JsonObject buttonJson;
                        if (!((JsonElement)entry.getValue()).isJsonObject() || !(buttonJson = ((JsonElement)entry.getValue()).getAsJsonObject()).has("group") || !ServerUtilitiesConfig.debugging.dev_sidebar_buttons && buttonJson.has("dev_only") && buttonJson.get("dev_only").getAsBoolean() || (group = (SidebarButtonGroup)groupMap.get(new ResourceLocation(buttonJson.get("group").getAsString()))) == null) continue;
                        SidebarButton button = new SidebarButton(new ResourceLocation(domain, (String)entry.getKey()), group, buttonJson);
                        group.getButtons().add(button);
                        if (sidebarButtonConfig.has(button.id.func_110624_b())) {
                            JsonElement e = sidebarButtonConfig.get(button.id.func_110624_b());
                            if (!e.isJsonObject() || !e.getAsJsonObject().has(button.id.func_110623_a())) continue;
                            button.setConfig(e.getAsJsonObject().get(button.id.func_110623_a()).getAsBoolean());
                            continue;
                        }
                        if (!sidebarButtonConfig.has(button.id.toString())) continue;
                        button.setConfig(sidebarButtonConfig.get(button.id.toString()).getAsBoolean());
                    }
                }
            }
            catch (Exception ex) {
                if (ex instanceof FileNotFoundException) continue;
                ex.printStackTrace();
            }
        }
        for (SidebarButtonGroup group : groupMap.values()) {
            if (group.getButtons().isEmpty()) continue;
            group.getButtons().sort(null);
            this.groups.add(group);
        }
        this.groups.sort(null);
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                new SidebarButtonCreatedEvent(button).post();
            }
        }
        this.saveConfig();
    }

    public void saveConfig() {
        JsonObject o = new JsonObject();
        for (SidebarButtonGroup group : this.groups) {
            for (SidebarButton button : group.getButtons()) {
                JsonObject o1 = o.getAsJsonObject(button.id.func_110624_b());
                if (o1 == null) {
                    o1 = new JsonObject();
                    o.add(button.id.func_110624_b(), (JsonElement)o1);
                }
                o1.addProperty(button.id.func_110623_a(), Boolean.valueOf(button.getConfig()));
            }
        }
        JsonObject o2 = o.getAsJsonObject(POSITION);
        if (o2 == null) {
            o2 = new JsonObject();
            o.add(POSITION, (JsonElement)o2);
        }
        o2.addProperty("posX", String.valueOf(GuiSidebar.dragOffsetX));
        o2.addProperty("posY", String.valueOf(GuiSidebar.dragOffsetY));
        JsonUtils.toJsonSafe(new File(Minecraft.func_71410_x().field_71412_D, "serverutilities/client/sidebar_buttons.json"), (JsonElement)o);
    }
}

