/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import java.util.Iterator;
import openmods.calc.Frame;
import openmods.calc.FrameFactory;
import openmods.calc.SingleReturnCallable;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.TypedValue;
import openmods.utils.OptionalInt;
import openmods.utils.Stack;

public abstract class LogicFunction
extends SingleReturnCallable<TypedValue> {
    private final TypedValue nullValue;

    public LogicFunction(TypedValue nullValue) {
        this.nullValue = nullValue;
    }

    @Override
    public TypedValue call(Frame<TypedValue> frame, OptionalInt argumentsCount) {
        TypedValue arg;
        int argCount = argumentsCount.or(2);
        if (argCount == 0) {
            return this.nullValue;
        }
        Stack<TypedValue> args = frame.stack().substack(argCount);
        Iterator<TypedValue> it = args.iterator();
        Frame<TypedValue> scratchFrame = FrameFactory.newLocalFrame(frame);
        Stack<TypedValue> scratchStack = scratchFrame.stack();
        do {
            this.execute(scratchFrame, it.next());
            arg = scratchStack.pop();
            scratchStack.checkIsEmpty();
        } while (!this.shouldReturn(scratchFrame, arg) && it.hasNext());
        args.clear();
        return arg;
    }

    protected abstract boolean shouldReturn(Frame<TypedValue> var1, TypedValue var2);

    protected abstract void execute(Frame<TypedValue> var1, TypedValue var2);

    public static abstract class Shorting
    extends LogicFunction {
        public Shorting(TypedValue nullValue) {
            super(nullValue);
        }

        @Override
        protected void execute(Frame<TypedValue> scratch, TypedValue value) {
            Code code = value.as(Code.class);
            code.execute(scratch);
            scratch.stack().checkSizeIsExactly(1);
        }
    }

    public static abstract class Eager
    extends LogicFunction {
        public Eager(TypedValue nullValue) {
            super(nullValue);
        }

        @Override
        protected void execute(Frame<TypedValue> scratch, TypedValue value) {
            scratch.stack().push(value);
        }
    }
}

