/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei.recipe;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.Widget;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.HandlerInfo;
import codechicken.nei.recipe.NEIRecipeWidget;
import codechicken.nei.recipe.RecipeHandlerRef;
import codechicken.nei.recipe.SearchRecipeHandler;
import codechicken.nei.scroll.ScrollContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RecipePageManager {
    private SearchRecipeHandler<?> handler;
    private ScrollContainer container;
    private HandlerInfo handlerInfo;
    private String cacheKey = "";
    private int currentPageIndex = -1;
    private List<Integer> recipeIndices = new ArrayList<Integer>();
    private List<List<Widget>> pageWidgets = new ArrayList<List<Widget>>();

    public RecipePageManager(SearchRecipeHandler<?> handler, HandlerInfo handlerInfo, ScrollContainer container) {
        this.handler = handler;
        this.handlerInfo = handlerInfo;
        this.container = container;
        this.rebuildPages();
    }

    public boolean rebuildPages() {
        String cacheKey = this.handlerInfo.getHandlerName() + ":" + this.getNumRecipes() + ":" + this.container.getVisibleHeight() + ":" + GuiRecipe.searchField.text();
        if (cacheKey.equals(this.cacheKey)) {
            return false;
        }
        this.cacheKey = cacheKey;
        this.pageWidgets.clear();
        boolean useCustomScroll = this.handlerInfo.getUseCustomScroll();
        int handlerHeight = this.handlerInfo.getHeight() + this.handlerInfo.getYShift();
        boolean multipleWidgetsAllowed = !useCustomScroll && this.handlerInfo.isMultipleWidgetsAllowed();
        boolean infiniteScroll = !useCustomScroll && NEIClientConfig.getBooleanSetting("inventory.guirecipe.infiniteScroll");
        int heightAvailable = this.container.getVisibleHeight();
        int width = Math.max(166, this.handlerInfo.getWidth());
        int numRecipes = this.getNumRecipes();
        ArrayList<NEIRecipeWidget> widgets = new ArrayList<NEIRecipeWidget>();
        int shiftY = 0;
        for (int i = 0; i < numRecipes; ++i) {
            int recipeIndex = this.handler.ref(i);
            NEIRecipeWidget widget = RecipeHandlerRef.of(this.handler.original, recipeIndex).getRecipeWidget();
            widget.w = width;
            if (useCustomScroll) {
                widget.h = Math.min(handlerHeight, heightAvailable);
            }
            if (!(widgets.isEmpty() || multipleWidgetsAllowed && (infiniteScroll || shiftY + widget.h <= heightAvailable))) {
                this.pageWidgets.add(widgets);
                widgets = new ArrayList();
                shiftY = 0;
            }
            widgets.add(widget);
            shiftY += widget.h;
        }
        if (!widgets.isEmpty()) {
            this.pageWidgets.add(widgets);
        }
        this.changePage(0);
        return true;
    }

    public boolean isMultipleWidgetsAllowed() {
        return !this.handlerInfo.getUseCustomScroll() && this.handlerInfo.isMultipleWidgetsAllowed();
    }

    public int getNumRecipes() {
        return this.handler.numRecipes();
    }

    public int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public int getNumPages() {
        return this.pageWidgets.size();
    }

    public void changePage(int delta) {
        int page;
        int numPages = this.getNumPages();
        int n = page = numPages > 0 ? (numPages + Math.max(0, this.currentPageIndex) + delta) % numPages : 0;
        if (this.currentPageIndex == page) {
            return;
        }
        this.currentPageIndex = page;
        this.recipeIndices = new ArrayList<Integer>();
        for (Widget widget : this.getCurrentPageWidgets()) {
            if (!(widget instanceof NEIRecipeWidget)) continue;
            NEIRecipeWidget recipeWidget = (NEIRecipeWidget)widget;
            this.recipeIndices.add(recipeWidget.getRecipeHandlerRef().recipeIndex);
        }
        this.container.setVerticalScrollOffset(0);
    }

    public void gotoRefIndex(int refIndex) {
        int page = 0;
        for (int i = 0; i < this.pageWidgets.size(); ++i) {
            if ((refIndex -= this.pageWidgets.get(i).size()) >= 0) continue;
            page = i;
            break;
        }
        this.changePage(page);
    }

    public List<Widget> getCurrentPageWidgets() {
        if (this.pageWidgets.isEmpty()) {
            return Collections.emptyList();
        }
        List<Widget> currentWidgets = this.pageWidgets.get(this.currentPageIndex);
        int shiftY = 0;
        for (Widget widget : currentWidgets) {
            if (widget instanceof NEIRecipeWidget) {
                NEIRecipeWidget recipeWidget = (NEIRecipeWidget)widget;
                recipeWidget.setLocation(0, shiftY);
            }
            shiftY += widget.h;
        }
        return currentWidgets;
    }

    public List<Integer> getRecipeIndices() {
        return this.recipeIndices;
    }
}

