/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.FormattedTextField;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.TextField;
import codechicken.nei.recipe.StackInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;

public class ItemQuantityField
extends TextField {
    public ItemQuantityField(String ident) {
        super(ident);
        this.centered = true;
        this.field.func_146204_h(-13619152);
    }

    @Override
    protected void initInternalTextField() {
        this.field = new FormattedTextField(Minecraft.func_71410_x().field_71466_p, 0, 0, 0, 0){
            {
                this.setPlaceholder(NEIClientUtils.translate("itempanel.quantity.default", new Object[0]));
            }

            public String func_146179_b() {
                String text = super.func_146179_b();
                return !this.func_146206_l() && "0".equals(text) ? "" : text;
            }

            @Override
            protected boolean beforeWrite(String text) {
                if (text == null || text.isEmpty()) {
                    return true;
                }
                try {
                    return Integer.parseInt(text) >= 0;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }

            public boolean func_146201_a(char keyChar, int keyID) {
                if (!this.func_146206_l()) {
                    return false;
                }
                if (super.func_146201_a(keyChar, keyID)) {
                    return true;
                }
                if (keyID == 208) {
                    this.func_146180_a(Integer.toString(Math.max(0, this.getInteger() - 1)));
                    return true;
                }
                if (keyID == 200) {
                    this.func_146180_a(Integer.toString(this.getInteger() + 1));
                    return true;
                }
                return false;
            }

            private int getInteger() {
                try {
                    return Math.max(0, Integer.parseInt(ItemQuantityField.this.text()));
                }
                catch (NumberFormatException nfe) {
                    return 0;
                }
            }
        };
        this.field.func_146203_f(256);
        this.field.func_146196_d();
    }

    private int getInteger() {
        try {
            return Math.max(0, Integer.parseInt(this.text()));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public static ItemStack prepareStackWithQuantity(ItemStack stack, long amount) {
        if (stack == null) {
            return null;
        }
        if (amount == 0L) {
            long l = amount = NEIClientConfig.showItemQuantityWidget() ? (long)NEIClientConfig.getItemQuantity() : 0L;
            if (amount == 0L) {
                amount = StackInfo.itemStackToNBT(stack).func_74764_b("gtFluidName") ? 144L : (long)stack.func_77976_d();
            }
        }
        return StackInfo.withAmount(stack, amount);
    }

    @Override
    public void gainFocus() {
        if (this.text().equals("0")) {
            this.setText("");
        }
    }

    @Override
    public void loseFocus() {
        this.setText(Integer.toString(NEIClientConfig.getItemQuantity()));
    }

    @Override
    public void onTextChange(String oldText) {
        NEIClientUtils.setItemQuantity(this.getInteger());
    }

    @Override
    public boolean onMouseWheel(int i, int mx, int my) {
        if (!this.contains(mx, my)) {
            return false;
        }
        int multiplier = 1;
        if (NEIClientUtils.shiftKey()) {
            multiplier = 10;
        } else if (NEIClientUtils.controlKey()) {
            multiplier = 64;
        }
        this.setText(Integer.toString(Math.max(0, this.getInteger() + i * multiplier)));
        return true;
    }
}

