/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.gen;

import chylex.hee.world.structure.island.biome.IslandBiomeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.NoiseGeneratorOctaves;

public class TerrainGenerator {
    private final IslandBiomeBase biome;
    private NoiseGeneratorOctaves noiseGen1;
    private NoiseGeneratorOctaves noiseGen2;
    private NoiseGeneratorOctaves noiseGen3;
    private NoiseGeneratorOctaves noiseGen4;
    private double[] noiseData1;
    private double[] noiseData2;
    private double[] noiseData3;
    private double[] noiseData4;
    private double[] densities;

    public TerrainGenerator(Random rand, IslandBiomeBase biome) {
        this.biome = biome;
        this.noiseGen1 = new NoiseGeneratorOctaves(rand, 16);
        this.noiseGen2 = new NoiseGeneratorOctaves(rand, 16);
        this.noiseGen3 = new NoiseGeneratorOctaves(rand, 8);
        this.noiseGen4 = new NoiseGeneratorOctaves(rand, 10);
    }

    public void generateTerrain(int x, int z, Block[] blocks) {
        int noiseSizeXZ = 3;
        int height = 33;
        this.densities = this.initializeNoiseField(this.densities, x * 2, 0, z * 2, noiseSizeXZ, height, noiseSizeXZ);
        for (int xx = 0; xx < 2; ++xx) {
            for (int zz = 0; zz < 2; ++zz) {
                for (int yy = 0; yy < 32; ++yy) {
                    double d0 = 0.25;
                    double dBL = this.densities[((xx + 0) * noiseSizeXZ + zz + 0) * height + yy + 0];
                    double dBR = this.densities[((xx + 0) * noiseSizeXZ + zz + 1) * height + yy + 0];
                    double dTL = this.densities[((xx + 1) * noiseSizeXZ + zz + 0) * height + yy + 0];
                    double dTR = this.densities[((xx + 1) * noiseSizeXZ + zz + 1) * height + yy + 0];
                    double dTopBL = (this.densities[((xx + 0) * noiseSizeXZ + zz + 0) * height + yy + 1] - dBL) * d0;
                    double dTopBR = (this.densities[((xx + 0) * noiseSizeXZ + zz + 1) * height + yy + 1] - dBR) * d0;
                    double dTopTL = (this.densities[((xx + 1) * noiseSizeXZ + zz + 0) * height + yy + 1] - dTL) * d0;
                    double dTopTR = (this.densities[((xx + 1) * noiseSizeXZ + zz + 1) * height + yy + 1] - dTR) * d0;
                    for (int yChunk = 0; yChunk < 4; ++yChunk) {
                        double d9 = 0.125;
                        double d10 = dBL;
                        double d11 = dBR;
                        double d12 = (dTL - dBL) * d9;
                        double d13 = (dTR - dBR) * d9;
                        for (int yBlock = 0; yBlock < 8; ++yBlock) {
                            int index = yBlock + xx * 8 << 11 | zz * 8 << 7 | yy * 4 + yChunk;
                            double d15 = d10;
                            double d16 = (d11 - d10) * 0.125;
                            for (int yBlock3 = 0; yBlock3 < 8; ++yBlock3) {
                                blocks[index] = d15 > 0.0 ? Blocks.field_150377_bs : Blocks.field_150350_a;
                                index += 128;
                                d15 += d16;
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        dBL += dTopBL;
                        dBR += dTopBR;
                        dTL += dTopTL;
                        dTR += dTopTR;
                    }
                }
            }
        }
    }

    private double[] initializeNoiseField(double[] densities, int x, int y, int z, int sizeX, int sizeY, int sizeZ) {
        if (densities == null) {
            densities = new double[sizeX * sizeY * sizeZ];
        }
        double noiseScaleXZ = 2737.648;
        double noiseScaleY = 1368.824;
        this.noiseData4 = this.noiseGen4.func_76305_a(this.noiseData4, x, z, sizeX, sizeZ, 1.121, 1.121, 0.5);
        this.noiseData1 = this.noiseGen3.func_76304_a(this.noiseData1, x, y, z, sizeX, sizeY, sizeZ, noiseScaleXZ / 80.0, noiseScaleY / 160.0, noiseScaleXZ / 80.0);
        this.noiseData2 = this.noiseGen1.func_76304_a(this.noiseData2, x, y, z, sizeX, sizeY, sizeZ, noiseScaleXZ, noiseScaleY, noiseScaleXZ);
        this.noiseData3 = this.noiseGen2.func_76304_a(this.noiseData3, x, y, z, sizeX, sizeY, sizeZ, noiseScaleXZ, noiseScaleY, noiseScaleXZ);
        int indexFull = 0;
        int indexHorizontal = 0;
        for (int xx = 0; xx < sizeX; ++xx) {
            for (int zz = 0; zz < sizeZ; ++zz) {
                double d2 = (this.noiseData4[indexHorizontal] + 256.0) / 512.0;
                if (d2 > 1.0) {
                    d2 = 1.0;
                }
                float islandSizeMp = 0.58f;
                float distanceX = (float)(xx + x) / islandSizeMp;
                float distanceZ = (float)(zz + z) / islandSizeMp;
                float f2 = 100.0f * this.biome.getIslandFillFactor() - MathHelper.func_76129_c((float)(distanceX * distanceX + distanceZ * distanceZ)) * 8.0f;
                if (f2 > 80.0f) {
                    f2 = 80.0f;
                }
                if (f2 < -100.0f) {
                    f2 = -100.0f;
                }
                if (d2 < 0.0) {
                    d2 = 0.0;
                }
                d2 += 0.5;
                ++indexHorizontal;
                double d4 = (double)sizeY / 2.0;
                for (int yy = 0; yy < sizeY; ++yy) {
                    int bottomPart;
                    double d10;
                    double density = 0.0;
                    double d6 = ((double)yy - d4) * 8.0 / d2;
                    if (d6 < 0.0) {
                        d6 *= -1.0;
                    }
                    double lowestDensity = this.noiseData2[indexFull] / 512.0;
                    double highestDensity = this.noiseData3[indexFull] / 512.0;
                    double densityInterpolation = (this.noiseData1[indexFull] / 10.0 + 1.0) / 2.0;
                    density = densityInterpolation < 0.0 ? lowestDensity : (densityInterpolation > 1.0 ? highestDensity : lowestDensity + (highestDensity - lowestDensity) * densityInterpolation);
                    density -= 8.0;
                    density += (double)f2;
                    if (yy > sizeY / 2 - 2) {
                        d10 = (float)(yy - (sizeY / 2 - 2)) / (64.0f * this.biome.getIslandSurfaceHeightMultiplier());
                        if (d10 < 0.0) {
                            d10 = 0.0;
                        }
                        if (d10 > 1.0) {
                            d10 = 1.0;
                        }
                        density = density * (1.0 - d10) - 3000.0 * d10;
                    }
                    if (yy < (bottomPart = 8)) {
                        d10 = (float)(bottomPart - yy) / ((float)bottomPart - 1.0f);
                        density = density * (1.0 - d10) - 30.0 * d10;
                    }
                    densities[indexFull] = density;
                    ++indexFull;
                }
            }
        }
        return densities;
    }
}

