/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.gui;

import chylex.hee.system.util.MathUtil;
import chylex.hee.tileentity.TileEntityAbstractTable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

public abstract class ContainerAbstractTable
extends Container {
    private final TileEntityAbstractTable table;
    private int prevReqStardust;
    private int prevTime;
    private float prevStoredEnergy;

    public ContainerAbstractTable(InventoryPlayer inv, TileEntityAbstractTable table) {
        int i;
        this.table = table;
        this.registerSlots(table);
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)inv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)inv, i, 8 + i * 18, 142));
        }
    }

    protected abstract void registerSlots(TileEntityAbstractTable var1);

    public void func_75132_a(ICrafting crafter) {
        super.func_75132_a(crafter);
        crafter.func_71112_a((Container)this, 0, this.table.getRequiredStardust());
        crafter.func_71112_a((Container)this, 1, this.table.getTime());
        crafter.func_71112_a((Container)this, 2, Float.floatToIntBits(this.table.getStoredEnergy()));
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (int i = 0; i < this.field_75149_d.size(); ++i) {
            ICrafting crafter = (ICrafting)this.field_75149_d.get(i);
            if (this.prevReqStardust != this.table.getRequiredStardust()) {
                crafter.func_71112_a((Container)this, 0, this.table.getRequiredStardust());
            }
            if (this.prevTime != this.table.getTime()) {
                crafter.func_71112_a((Container)this, 1, this.table.getTime());
            }
            if (MathUtil.floatEquals(this.prevStoredEnergy, this.table.getStoredEnergy())) continue;
            crafter.func_71112_a((Container)this, 2, Float.floatToIntBits(this.table.getStoredEnergy()));
        }
        this.prevReqStardust = this.table.getRequiredStardust();
        this.prevTime = this.table.getTime();
        this.prevStoredEnergy = this.table.getStoredEnergy();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id == 0) {
            this.table.setRequiredStardustClient(value);
        } else if (id == 1) {
            this.table.setTimeClient(value);
        } else if (id == 2) {
            this.table.setStoredEnergyClient(Float.intBitsToFloat(value));
        }
    }

    public final boolean func_75145_c(EntityPlayer player) {
        return this.table.func_70300_a(player);
    }
}

