/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport.anchor;

import com.enderio.core.api.client.gui.IResourceTooltipProvider;
import com.enderio.core.common.TileEntityEnder;
import com.enderio.core.common.util.ChatUtil;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.teleport.ITravelAccessable;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.IPaintableTileEntity;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAccessable;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.anchor.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketLabel;
import crazypants.enderio.teleport.packet.PacketLongDistanceTravelEvent;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketPassword;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.enderio.teleport.packet.PacketVisibility;
import crazypants.util.IFacade;
import crazypants.util.UserIdent;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockTravelAnchor
extends BlockEio
implements IGuiHandler,
ITileEntityProvider,
IResourceTooltipProvider,
IFacade {
    public static int renderId = -1;
    IIcon selectedOverlayIcon;
    IIcon highlightOverlayIcon;

    public static BlockTravelAnchor create() {
        PacketHandler.INSTANCE.registerMessage(PacketAccessMode.class, PacketAccessMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLabel.class, PacketLabel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTravelEvent.class, PacketTravelEvent.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLongDistanceTravelEvent.class, PacketLongDistanceTravelEvent.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDrainStaff.class, PacketDrainStaff.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenAuthGui.class, PacketOpenAuthGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketPassword.Handler.class, PacketPassword.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketVisibility.class, PacketVisibility.class, PacketHandler.nextID(), Side.SERVER);
        BlockTravelAnchor result = new BlockTravelAnchor();
        result.init();
        EnderIO.guiHandler.registerGuiHandler(18, result);
        EnderIO.guiHandler.registerGuiHandler(19, result);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, result.new PainterTemplate());
        return result;
    }

    private BlockTravelAnchor() {
        super(ModObject.blockTravelAnchor.unlocalisedName, TileTravelAnchor.class);
        if (!Config.travelAnchorEnabled) {
            this.func_149647_a(null);
        }
    }

    public BlockTravelAnchor(String unlocalisedName, Class<? extends TileEntityEio> teClass) {
        super(unlocalisedName, teClass);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        super.func_149651_a(iIconRegister);
        this.highlightOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorHighlight");
        this.selectedOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorSelected");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        Block sourceBlock;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null && sourceBlock != this) {
            return sourceBlock.func_149691_a(blockSide, ((IPaintableTileEntity)te).getSourceBlockMetadata());
        }
        return super.func_149673_e(world, x, y, z, blockSide);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTravelAnchor();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.func_147438_o(x, y, z)) instanceof TileTravelAnchor) {
            TileTravelAnchor ta = (TileTravelAnchor)te;
            ta.setPlacedBy((EntityPlayer)entity);
            Block b = PainterUtil.getSourceBlock(par6ItemStack);
            ta.setSourceBlock(b);
            ta.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(par6ItemStack));
            world.func_147471_g(x, y, z);
        }
    }

    public boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!world.field_72995_K && te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 18, world, x, y, z);
            } else {
                BlockTravelAnchor.sendPrivateChatMessage(entityPlayer, ta.getOwner());
            }
        }
        return true;
    }

    public static void sendPrivateChatMessage(EntityPlayer player, UserIdent owner) {
        if (!player.func_70093_af()) {
            ChatUtil.sendNoSpam((EntityPlayer)player, (String[])new String[]{EnderIO.lang.localize("gui.travelAccessable.privateBlock1") + " " + EnumChatFormatting.RED + owner.getPlayerName() + EnumChatFormatting.WHITE + " " + EnderIO.lang.localize("gui.travelAccessable.privateBlock2")});
        }
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new ContainerTravelAuth(player.field_71071_by, te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new GuiTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }

    protected void processDrop(World world, int x, int y, int z, @Nullable TileEntityEnder te, ItemStack drop) {
        TileTravelAnchor anchor = (TileTravelAnchor)te;
        if (anchor == null) {
            return;
        }
        ItemStack itemStack = new ItemStack((Block)this);
        Block srcBlk = anchor.getSourceBlock();
        if (srcBlk != null) {
            itemStack = this.createItemStackForSourceBlock(anchor.getSourceBlock(), anchor.getSourceBlockMetadata());
            drop.field_77990_d = (NBTTagCompound)itemStack.field_77990_d.func_74737_b();
        }
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        Block sourceBlock;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null && sourceBlock != this) {
            return sourceBlock.func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public int func_149645_b() {
        return renderId;
    }

    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public ItemStack createItemStackForSourceBlock(Block block, int damage) {
        if (block == this) {
            return new ItemStack((Block)this);
        }
        ItemStack result = new ItemStack((Block)this, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor) {
            return ((TileTravelAnchor)te).getSourceBlockMetadata();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        Block sourceBlock;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof IPaintableTileEntity && (sourceBlock = ((IPaintableTileEntity)te).getSourceBlock()) != null) {
            return sourceBlock;
        }
        return this;
    }

    public Block getVisualBlock(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacade(world, x, y, z, side.ordinal());
    }

    public int getVisualMeta(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.getFacadeMetadata(world, x, y, z, side.ordinal());
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(new Block[]{BlockTravelAnchor.this});
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockTravelAnchor.this.createItemStackForSourceBlock(Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }
    }
}

