/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.client.nei;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import WayofTime.alchemicalWizardry.client.nei.NEIAlchemyRecipeHandler;
import WayofTime.alchemicalWizardry.client.nei.NEIAltarRecipeHandler;
import WayofTime.alchemicalWizardry.client.nei.NEIBindingRitualHandler;
import WayofTime.alchemicalWizardry.client.nei.NEIBloodOrbShapedHandler;
import WayofTime.alchemicalWizardry.client.nei.NEIBloodOrbShapelessHandler;
import WayofTime.alchemicalWizardry.client.nei.NEICalcinatorHandler;
import WayofTime.alchemicalWizardry.client.nei.NEIMeteorRecipeHandler;
import codechicken.nei.ItemList;
import codechicken.nei.api.API;
import codechicken.nei.api.IConfigureNEI;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NEIConfig
implements IConfigureNEI {
    private static ArrayList<Item> bloodOrbs = null;
    private static ArrayList<Item> byCapacity = null;
    public static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("alchemicalwizardry", "gui/nei/arrow.png");

    public static synchronized ArrayList<Item> getBloodOrbs() {
        if (bloodOrbs == null) {
            bloodOrbs = NEIConfig.collectAllBloodOrbs();
        }
        return bloodOrbs;
    }

    private static ArrayList<Item> collectAllBloodOrbs() {
        ArrayList<Item> bloodOrbsTemp = new ArrayList<Item>();
        for (ItemStack item : ItemList.items) {
            if (item == null || !(item.func_77973_b() instanceof IBloodOrb)) continue;
            bloodOrbsTemp.add(item.func_77973_b());
        }
        if (bloodOrbsTemp.isEmpty()) {
            for (Object anItemRegistry : Item.field_150901_e) {
                Item item = (Item)anItemRegistry;
                if (!(item instanceof IBloodOrb)) continue;
                bloodOrbsTemp.add(item);
            }
        }
        return bloodOrbsTemp;
    }

    public static synchronized ArrayList<Item> getOrbsByCapacity() {
        if (byCapacity == null) {
            byCapacity = new ArrayList<Item>(NEIConfig.getBloodOrbs());
            byCapacity.sort((a, b) -> {
                if (a instanceof IBloodOrb) {
                    IBloodOrb orbA = (IBloodOrb)a;
                    if (b instanceof IBloodOrb) {
                        IBloodOrb orbB = (IBloodOrb)b;
                        return Integer.compare(orbA.getMaxEssence(), orbB.getMaxEssence());
                    }
                }
                return 0;
            });
        }
        return byCapacity;
    }

    public void loadConfig() {
        API.registerRecipeHandler((ICraftingHandler)new NEIAlchemyRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIAlchemyRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIAltarRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIAltarRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIBloodOrbShapedHandler());
        API.registerUsageHandler((IUsageHandler)new NEIBloodOrbShapedHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIBloodOrbShapelessHandler());
        API.registerUsageHandler((IUsageHandler)new NEIBloodOrbShapelessHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIBindingRitualHandler());
        API.registerUsageHandler((IUsageHandler)new NEIBindingRitualHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEIMeteorRecipeHandler());
        API.registerUsageHandler((IUsageHandler)new NEIMeteorRecipeHandler());
        API.registerRecipeHandler((ICraftingHandler)new NEICalcinatorHandler());
        API.registerUsageHandler((IUsageHandler)new NEICalcinatorHandler());
    }

    public String getName() {
        return "Blood Magic NEI";
    }

    public String getVersion() {
        return "1.3";
    }
}

