/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api.questing.rewards;

import betterquesting.api.questing.IQuest;
import betterquesting.api.questing.rewards.IReward;
import betterquesting.api.storage.BQ_Settings;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractReward
implements IReward {
    protected boolean ignoreDisabled = this.getDefaultIgnoreDisabled();

    @Override
    public final void claimReward(EntityPlayer player, Map.Entry<UUID, IQuest> quest) {
        if (!this.ignoreDisabled && BQ_Settings.noRewards) {
            return;
        }
        this.claimReward0(player, quest);
    }

    protected boolean getDefaultIgnoreDisabled() {
        return false;
    }

    protected abstract void claimReward0(EntityPlayer var1, Map.Entry<UUID, IQuest> var2);

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.ignoreDisabled = nbt.func_74764_b("ignoreDisabled") ? nbt.func_74767_n("ignoreDisabled") : this.getDefaultIgnoreDisabled();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("ignoreDisabled", this.ignoreDisabled);
        return nbt;
    }

    public boolean isIgnoreDisabled() {
        return this.ignoreDisabled;
    }

    public void setIgnoreDisabled(boolean ignoreDisabled) {
        this.ignoreDisabled = ignoreDisabled;
    }
}

