/*
 * Decompiled with CFR 0.152.
 */
package baubles.client.gui;

import baubles.api.IBauble;
import baubles.api.expanded.BaubleExpandedSlots;
import baubles.api.expanded.IBaubleExpanded;
import baubles.common.Baubles;
import baubles.common.BaublesConfig;
import baubles.common.container.ContainerPlayerExpanded;
import baubles.common.container.SlotBauble;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.VisiblityData;
import codechicken.nei.api.INEIGuiHandler;
import codechicken.nei.api.TaggedInventoryArea;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.achievement.GuiAchievements;
import net.minecraft.client.gui.achievement.GuiStats;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

@Optional.Interface(iface="codechicken.nei.api.INEIGuiHandler", modid="NotEnoughItems")
public class GuiPlayerExpanded
extends GuiContainer
implements INEIGuiHandler {
    public static final ResourceLocation background = new ResourceLocation("baubles", "textures/gui/bauble_inventory.png");
    public static final ResourceLocation gui_background = new ResourceLocation("baubles", "textures/gui/bauble_background.png");
    private static final ResourceLocation creative_inventory_tabs = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final boolean hasLwjgl3 = Loader.isModLoaded((String)"lwjgl3ify");
    private float xSizeFloat;
    private float ySizeFloat;
    public boolean showActivePotionEffects;
    private float currentScroll;
    private boolean isScrolling;
    private boolean wasClicking;
    private int tooltipIndexCache = -1;
    private final List<String> tooltipCache = new ArrayList<String>(2);

    public GuiPlayerExpanded(EntityPlayer player) {
        super((Container)new ContainerPlayerExpanded(player.field_71071_by, !player.field_70170_p.field_72995_K, player));
        this.field_146291_p = true;
    }

    public void func_73876_c() {
        try {
            ((ContainerPlayerExpanded)this.field_147002_h).baubles.blockEvents = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        super.func_73866_w_();
        if (!this.field_146297_k.field_71439_g.func_70651_bq().isEmpty() && !BaublesConfig.useOldGuiRendering) {
            this.showActivePotionEffects = true;
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.xSizeFloat = mouseX;
        this.ySizeFloat = mouseY;
        if (BaublesConfig.displayTooltipOnHover) {
            this.handleMouseHover(mouseX, mouseY);
        }
        this.handleScrollbar(mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        if (!BaublesConfig.useOldGuiRendering) {
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0]), 86, 16, 0x404040);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (BaublesConfig.useOldGuiRendering) {
            this.field_146297_k.func_110434_K().func_110577_a(background);
        } else {
            this.field_146297_k.func_110434_K().func_110577_a(GuiInventory.field_147001_a);
        }
        this.drawBaubleSlots();
        if (this.showActivePotionEffects) {
            this.drawPotionEffects();
        }
        GuiInventory.func_147046_a((int)(this.field_147003_i + 51), (int)(this.field_147009_r + 75), (int)30, (float)((float)(this.field_147003_i + 51) - this.xSizeFloat), (float)((float)(this.field_147009_r + 25) - this.ySizeFloat), (EntityLivingBase)this.field_146297_k.field_71439_g);
    }

    private void drawBaubleSlots() {
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        int upperHeight = 7 + BaubleExpandedSlots.slotsCurrentlyUsed() * 18;
        if (!BaublesConfig.useOldGuiRendering) {
            this.field_146297_k.func_110434_K().func_110577_a(gui_background);
        }
        int slotOffset = 18;
        int slotStartX = this.field_147003_i - 26;
        int slotStartY = 12;
        if (BaublesConfig.useOldGuiRendering) {
            slotStartX = this.field_147003_i + 79;
            slotStartY = this.field_147009_r + 7;
        } else if (BaubleExpandedSlots.slotsCurrentlyUsed() <= 8) {
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 4, 0, 0, 27, upperHeight);
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 4 + upperHeight, 0, 151, 27, 7);
        } else {
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 4, 0, 0, 27, 158);
            this.func_73729_b(this.field_147003_i - 42, this.field_147009_r + 4, 27, 0, 23, 158);
            this.field_146297_k.func_110434_K().func_110577_a(creative_inventory_tabs);
            this.func_73729_b(this.field_147003_i - 34, this.field_147009_r + 12 + (int)(127.0f * this.currentScroll), 232, 0, 12, 15);
        }
        for (int slotIndex = 0; slotIndex < 20; ++slotIndex) {
            String slotType = BaubleExpandedSlots.getSlotType(slotIndex);
            if (!BaublesConfig.showUnusedSlots && slotType.equals("unknown")) continue;
            if (BaublesConfig.useOldGuiRendering) {
                this.func_73729_b(slotStartX + 18 * (slotIndex / 4), slotStartY + 18 * (slotIndex % 4), 200, 0, 18, 18);
                continue;
            }
            this.func_73729_b(slotStartX + 18 * (slotIndex / 4), slotStartY + 18 * slotIndex, 200, 0, 18, 18);
        }
    }

    private void drawPotionEffects() {
        int slotIndent = 26;
        if (BaubleExpandedSlots.slotsCurrentlyUsed() > 8) {
            slotIndent = 42;
        }
        int positionHorizontal = this.field_147003_i - slotIndent - 124;
        int positionVertical = this.field_147009_r;
        Collection potionCollection = this.field_146297_k.field_71439_g.func_70651_bq();
        if (potionCollection.isEmpty()) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        int maxNumber = 33;
        if (potionCollection.size() > 5) {
            maxNumber = 132 / (potionCollection.size() - 1);
        }
        for (PotionEffect effect : potionCollection) {
            Potion potion = Potion.field_76425_a[effect.func_76456_a()];
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(field_147001_a);
            this.func_73729_b(positionHorizontal, positionVertical, 0, 166, 140, 32);
            if (potion.func_76400_d()) {
                int potionIconIndex = potion.func_76392_e();
                this.func_73729_b(positionHorizontal + 6, positionVertical + 7, potionIconIndex % 8 * 18, 198 + potionIconIndex / 8 * 18, 18, 18);
            }
            potion.renderInventoryEffect(positionHorizontal, positionVertical, effect, this.field_146297_k);
            if (!potion.shouldRenderInvText(effect)) continue;
            String potionName = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
            if (effect.func_76458_c() >= 1) {
                potionName = potionName + " " + I18n.func_135052_a((String)("enchantment.level." + effect.func_76458_c()), (Object[])new Object[0]);
            }
            this.field_146289_q.func_78261_a(potionName, positionHorizontal + 10 + 18, positionVertical + 6, 0xFFFFFF);
            String s = Potion.func_76389_a((PotionEffect)effect);
            this.field_146289_q.func_78261_a(s, positionHorizontal + 10 + 18, positionVertical + 6 + 10, 0x7F7F7F);
            positionVertical += maxNumber;
        }
    }

    private void handleMouseHover(int mouseX, int mouseY) {
        ContainerPlayerExpanded expandedInventory = (ContainerPlayerExpanded)this.field_147002_h;
        if (this.tooltipIndexCache != -1) {
            ItemStack stack;
            SlotBauble slot = expandedInventory.getBaubleSlot(this.tooltipIndexCache);
            if (this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY) && ((stack = expandedInventory.baubles.func_70301_a(this.tooltipIndexCache)) == null || stack.field_77994_a == 0)) {
                this.func_146283_a(this.tooltipCache, mouseX, mouseY);
                return;
            }
        }
        for (int slotIndex = 0; slotIndex < expandedInventory.getBaubleSlotCount(); ++slotIndex) {
            ItemStack stack;
            if (slotIndex == this.tooltipIndexCache) continue;
            SlotBauble slot = expandedInventory.getBaubleSlot(slotIndex);
            if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, mouseX, mouseY) || (stack = expandedInventory.baubles.func_70301_a(slotIndex)) != null && stack.field_77994_a > 0) continue;
            this.tooltipIndexCache = slotIndex;
            String slotType = BaubleExpandedSlots.getSlotType(slotIndex);
            this.tooltipCache.clear();
            String strippedType = StatCollector.func_74838_a((String)("slot." + slotType)).replaceAll("\u00a7[0-9a-fklmnor]", "");
            this.tooltipCache.add(strippedType);
            ItemStack heldItem = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (heldItem != null && heldItem.field_77994_a > 0) {
                String[] itemBaubleTypes;
                boolean fitsInSlot = false;
                Item item = heldItem.func_77973_b();
                if (item instanceof IBaubleExpanded) {
                    IBaubleExpanded baubleExpandedItem = (IBaubleExpanded)item;
                    for (String itemBaubleType : itemBaubleTypes = baubleExpandedItem.getBaubleTypes(heldItem)) {
                        if (!slotType.equals(itemBaubleType)) continue;
                        fitsInSlot = true;
                        break;
                    }
                } else {
                    IBauble baubleItem;
                    String itemBaubleType;
                    itemBaubleTypes = heldItem.func_77973_b();
                    if (itemBaubleTypes instanceof IBauble && slotType.equals(itemBaubleType = BaubleExpandedSlots.getTypeFromBaubleType((baubleItem = (IBauble)itemBaubleTypes).getBaubleType(heldItem)))) {
                        fitsInSlot = true;
                    }
                }
                this.tooltipCache.add(fitsInSlot ? StatCollector.func_74838_a((String)"tooltip.fitsInSlot") : StatCollector.func_74838_a((String)"tooltip.doesNotFitInSlot"));
            }
            this.func_146283_a(this.tooltipCache, mouseX, mouseY);
            return;
        }
        this.tooltipIndexCache = -1;
    }

    private boolean needsScrollBars() {
        return ((ContainerPlayerExpanded)this.field_147002_h).canScroll();
    }

    private void handleScrollbar(int mouseX, int mouseY) {
        boolean leftMouseDown = Mouse.isButtonDown((int)0);
        if (!this.wasClicking && leftMouseDown && this.isClickInScrollbar(mouseX, mouseY)) {
            this.isScrolling = this.needsScrollBars();
        }
        if (!leftMouseDown) {
            this.isScrolling = false;
        }
        this.wasClicking = leftMouseDown;
        if (this.isScrolling) {
            int scrollbarYStart = this.field_147009_r + 12;
            int scrollbarYEnd = scrollbarYStart + 139;
            this.currentScroll = ((float)(mouseY - scrollbarYStart) - 7.5f) / ((float)(scrollbarYEnd - scrollbarYStart) - 15.0f);
            if (this.currentScroll < 0.0f) {
                this.currentScroll = 0.0f;
            }
            if (this.currentScroll > 1.0f) {
                this.currentScroll = 1.0f;
            }
            ((ContainerPlayerExpanded)this.field_147002_h).scrollTo(this.currentScroll);
        }
    }

    public void func_146274_d() {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel();
        if (wheel == 0 || !this.needsScrollBars()) {
            return;
        }
        if (!hasLwjgl3) {
            wheel = wheel > 0 ? Math.addExact(Math.addExact(wheel, 120), -1) / 120 : -Math.addExact(Math.addExact(-wheel, 120), -1) / 120;
        }
        int i = BaubleExpandedSlots.slotsCurrentlyUsed();
        this.currentScroll = (float)((double)this.currentScroll - (double)wheel / (double)i);
        this.currentScroll = MathHelper.func_76131_a((float)this.currentScroll, (float)0.0f, (float)1.0f);
        ((ContainerPlayerExpanded)this.field_147002_h).scrollTo(this.currentScroll);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiAchievements((GuiScreen)this, this.field_146297_k.field_71439_g.func_146107_m()));
        } else if (button.field_146127_k == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)new GuiStats((GuiScreen)this, this.field_146297_k.field_71439_g.func_146107_m()));
        }
    }

    protected void func_73869_a(char par1, int keyCode) {
        if (keyCode == Baubles.proxy.keyHandler.key.func_151463_i()) {
            this.field_146297_k.field_71439_g.func_71053_j();
        } else {
            super.func_73869_a(par1, keyCode);
        }
    }

    protected void func_146984_a(Slot slotIn, int slotId, int clickedButton, int clickType) {
        if (slotIn != null && clickType == 4 && slotIn.field_75223_e < 0 && !BaublesConfig.useOldGuiRendering) {
            clickType = 0;
        }
        super.func_146984_a(slotIn, slotId, clickedButton, clickType);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) {
        if (this.isClickInUI(mouseX, mouseY)) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        if (this.isClickInUI(mouseX, mouseY)) {
            return;
        }
        super.func_146286_b(mouseX, mouseY, mouseButton);
    }

    private boolean isClickInScrollbar(int mouseX, int mouseY) {
        int scrollbarXStart = this.field_147003_i - 34;
        int scrollbarYStart = this.field_147009_r + 12;
        int scrollbarXEnd = scrollbarXStart + 14;
        int scrollbarYEnd = scrollbarYStart + 139;
        return mouseX >= scrollbarXStart && mouseY >= scrollbarYStart && mouseX < scrollbarXEnd && mouseY < scrollbarYEnd;
    }

    private boolean isClickInUI(int mouseX, int mouseY) {
        int scrollbarXStart = this.field_147003_i - 42;
        int scrollbarYStart = this.field_147009_r + 5;
        int scrollbarXEnd = scrollbarXStart + 27;
        int scrollbarYEnd = scrollbarYStart + 156;
        return mouseX >= scrollbarXStart && mouseY >= scrollbarYStart && mouseX < scrollbarXEnd && mouseY < scrollbarYEnd;
    }

    @Optional.Method(modid="NotEnoughItems")
    public VisiblityData modifyVisiblity(GuiContainer gui, VisiblityData currentVisibility) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public Iterable<Integer> getItemSpawnSlots(GuiContainer gui, ItemStack item) {
        return null;
    }

    @Optional.Method(modid="NotEnoughItems")
    public List<TaggedInventoryArea> getInventoryAreas(GuiContainer gui) {
        return Collections.emptyList();
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean handleDragNDrop(GuiContainer gui, int mousex, int mousey, ItemStack draggedStack, int button) {
        return false;
    }

    @Optional.Method(modid="NotEnoughItems")
    public boolean hideItemPanelSlot(GuiContainer gui, int slotX, int slotY, int slotW, int slotH) {
        int upperHeight = 7 + BaubleExpandedSlots.slotsCurrentlyUsed() * 18;
        if (!(gui instanceof GuiPlayerExpanded) || BaublesConfig.useOldGuiRendering) {
            return false;
        }
        int slotIndent = 26;
        int slotWidth = 18;
        if (BaubleExpandedSlots.slotsCurrentlyUsed() > 8) {
            slotIndent = 42;
            slotWidth = 36;
        }
        if (NEIClientConfig.ignorePotionOverlap()) {
            return new Rectangle4i(this.field_147003_i - slotIndent, this.field_147009_r + 4, slotWidth, upperHeight + 4).intersects(new Rectangle4i(slotX, slotY, slotW, slotH));
        }
        int x = this.field_147003_i - 124 - slotIndent;
        int y = this.field_147009_r;
        Minecraft minecraft = gui.field_146297_k;
        if (minecraft == null) {
            return false;
        }
        EntityClientPlayerMP player = minecraft.field_71439_g;
        if (player == null) {
            return false;
        }
        Collection activePotionEffects = player.func_70651_bq();
        if (activePotionEffects.isEmpty()) {
            return new Rectangle4i(this.field_147003_i - slotIndent, this.field_147009_r + 4, slotWidth, upperHeight + 4).intersects(new Rectangle4i(slotX, slotY, slotW, slotH));
        }
        int height = 33;
        if (activePotionEffects.size() > 5) {
            height = 132 / (activePotionEffects.size() - 1);
        }
        Rectangle4i slotRect = new Rectangle4i(slotX, slotY, slotW, slotH);
        Rectangle4i baubleSlots = new Rectangle4i(this.field_147003_i - slotIndent, this.field_147009_r + 4, slotWidth, upperHeight + 4);
        for (PotionEffect effect : activePotionEffects) {
            Rectangle4i box = new Rectangle4i(x, y, 140, 32);
            box.include(baubleSlots);
            if (box.intersects(slotRect)) {
                return true;
            }
            y += height;
        }
        return false;
    }
}

