/*
 * Decompiled with CFR 0.152.
 */
package eu.usrv.yamcore.fluids;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eu.usrv.yamcore.YAMCore;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ModSimpleBaseFluid
extends BlockFluidClassic {
    private List<PotionEffect> _mPotionEffects = new ArrayList<PotionEffect>();
    private List<PotionEffect> _mStackingPotionEffects = new ArrayList<PotionEffect>();
    private boolean _mEffectsOnlyToPlayers = false;
    private Random _mRand = new Random(System.currentTimeMillis());
    @SideOnly(value=Side.CLIENT)
    protected IIcon stillIcon;
    @SideOnly(value=Side.CLIENT)
    protected IIcon flowingIcon;
    private String _mTxtStill;
    private String _mTxtFlow;
    private String _mModID;
    private String _mCreativeTab;
    private boolean _mRegisterBucket = true;
    boolean _mCanDisplaceFluids = false;

    public ModSimpleBaseFluid(Fluid fluid, Material material) {
        super(fluid, material);
    }

    public void setRegisterBucket(boolean pFlag) {
        this._mRegisterBucket = pFlag;
    }

    public boolean getRegisterBucket() {
        return this._mRegisterBucket;
    }

    public void addPotionEffect(PotionEffect pEffect) {
        this._mPotionEffects.add(pEffect);
    }

    public void addStackingPotionEffect(PotionEffect pEffect) {
        this._mStackingPotionEffects.add(pEffect);
    }

    public void setApplyEffectsToPlayersOnly(boolean pFlag) {
        this._mEffectsOnlyToPlayers = pFlag;
    }

    public void SetTextures(String pModID, String pFluidName) {
        this._mTxtStill = String.format("%s:fluid%s_still", pModID, pFluidName);
        this._mTxtFlow = String.format("%s:fluid%s_flow", pModID, pFluidName);
    }

    public void setDisplaceOtherFluids(boolean pFlag) {
        this._mCanDisplaceFluids = pFlag;
    }

    public void SetModID(String pModID) {
        this._mModID = pModID;
    }

    public IIcon func_149691_a(int side, int meta) {
        return side == 0 || side == 1 ? this.stillIcon : this.flowingIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.stillIcon = register.func_94245_a(this._mTxtStill);
        this.flowingIcon = register.func_94245_a(this._mTxtFlow);
        super.getFluid().setIcons(this.stillIcon, this.flowingIcon);
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return this._mCanDisplaceFluids;
        }
        return super.canDisplace(world, x, y, z);
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return this._mCanDisplaceFluids;
        }
        return super.displaceIfPossible(world, x, y, z);
    }

    public void setCreativeTabName(String pTabName) {
        this._mCreativeTab = pTabName;
    }

    public String getCreativeTabName() {
        return this._mCreativeTab;
    }

    public FluidStack drain(World pWorld, int pX, int pY, int pZ, boolean pDoDrain) {
        pWorld.func_147468_f(pX, pY, pZ);
        return new FluidStack(this.getFluid(), 1000);
    }

    public boolean canDrain(World pWorld, int pX, int pY, int pZ) {
        return true;
    }

    public void func_149670_a(World pWorld, int pX, int pY, int pZ, Entity pEntity) {
        super.func_149670_a(pWorld, pX, pY, pZ, pEntity);
        try {
            if (!(pEntity instanceof EntityLivingBase)) {
                return;
            }
            if (!(pEntity instanceof EntityPlayer) && this._mEffectsOnlyToPlayers) {
                return;
            }
            EntityLivingBase tElivBase = (EntityLivingBase)pEntity;
            for (PotionEffect tEffect : this._mPotionEffects) {
                tElivBase.func_70690_d(tEffect);
            }
            if (this._mRand.nextInt(10) == 0) {
                for (PotionEffect tStackingEffect : this._mStackingPotionEffects) {
                    int tDuration = tStackingEffect.func_76459_b();
                    for (Object actEffObj : tElivBase.func_70651_bq()) {
                        PotionEffect pae = (PotionEffect)actEffObj;
                        if (pae.func_76456_a() != tStackingEffect.func_76456_a()) continue;
                        tDuration += pae.func_76459_b();
                        break;
                    }
                    tElivBase.func_70690_d(new PotionEffect(tStackingEffect.func_76456_a(), tDuration, tStackingEffect.func_76458_c()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            YAMCore.instance.getLogger().error(String.format("Apply potioneffect failed for fluidblock %s", this.getFluid().getUnlocalizedName()));
        }
    }
}

