/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.relocation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import mrtjp.core.math.MathLib$;
import mrtjp.relocation.BlockRow;
import mrtjp.relocation.BlockStruct;
import mrtjp.relocation.BlockStruct$;
import mrtjp.relocation.MovementManager2$;
import mrtjp.relocation.MovementManager2$$anonfun$onTick$2$;
import mrtjp.relocation.MovingTileRegistry$;
import mrtjp.relocation.TileMovingRow$;
import mrtjp.relocation.Utils$;
import mrtjp.relocation.WorldStructs;
import mrtjp.relocation.api.IMovementCallback;
import mrtjp.relocation.handler.RelocationConfig$;
import mrtjp.relocation.handler.RelocationSPH;
import mrtjp.relocation.handler.RelocationSPH$;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.concurrent.TrieMap;
import scala.collection.concurrent.TrieMap$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MultiMap;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.ref.WeakReference;
import scala.ref.WeakReference$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class MovementManager2$ {
    public static final MovementManager2$ MODULE$;
    private final HashMap<Object, WorldStructs> serverRelocations;
    private final TrieMap<Object, WorldStructs> clientRelocations;

    static {
        new MovementManager2$();
    }

    public HashMap<Object, WorldStructs> serverRelocations() {
        return this.serverRelocations;
    }

    public TrieMap<Object, WorldStructs> clientRelocations() {
        return this.clientRelocations;
    }

    public Map<Object, WorldStructs> relocationMap(boolean isClient) {
        return isClient ? this.clientRelocations() : this.serverRelocations();
    }

    public WorldStructs getWorldStructs(World w) {
        return (WorldStructs)this.relocationMap(w.field_72995_K).getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)w.field_73011_w.field_76574_g), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WorldStructs apply() {
                return new WorldStructs();
            }
        });
    }

    public World getWorld(int dim, boolean isClient) {
        return isClient ? this.getClientWorld(dim) : DimensionManager.getWorld((int)dim);
    }

    @SideOnly(value=Side.CLIENT)
    private World getClientWorld(int dim) {
        WorldClient w = Minecraft.func_71410_x().field_71441_e;
        return w.field_73011_w.field_76574_g == dim ? w : null;
    }

    public boolean writeDesc(World w, scala.collection.immutable.Set<ChunkCoordIntPair> chunks, MCDataOutput out) {
        BooleanRef send = BooleanRef.create((boolean)false);
        this.getWorldStructs(w).structs().withFilter((Function1)new Serializable(chunks){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Set chunks$1;

            public final boolean apply(BlockStruct s) {
                return s.getChunks().exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.writeDesc.1 $outer;

                    public final boolean apply(ChunkCoordIntPair elem) {
                        return this.$outer.chunks$1.contains((Object)elem);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.chunks$1 = chunks$1;
            }
        }).foreach((Function1)new Serializable(out, send){
            public static final long serialVersionUID = 0L;
            private final MCDataOutput out$1;
            private final BooleanRef send$1;

            public final void apply(BlockStruct s) {
                this.send$1.elem = true;
                this.out$1.writeShort(s.id());
                s.writeDesc(this.out$1);
            }
            {
                this.out$1 = out$1;
                this.send$1 = send$1;
            }
        });
        Object object = send.elem ? out.writeShort(Short.MAX_VALUE) : BoxedUnit.UNIT;
        return send.elem;
    }

    public void readDesc(World w, MCDataInput in) {
        int id = in.readUShort();
        while (id != Short.MAX_VALUE) {
            BlockStruct struct = new BlockStruct();
            struct.id_$eq(id);
            struct.readDesc(in);
            this.addStructToWorld(w, struct);
            id = in.readUShort();
        }
    }

    public void read(World w, MCDataInput in, int key) {
        int n = key;
        switch (n) {
            default: {
                throw new RuntimeException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DC: Packet with ID ", " was not handled. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)key)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipped ", " bytes."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)((PacketCustom)in).getByteBuf().array().length)}))).toString());
            }
            case 2: {
                int id = in.readUShort();
                Option option = this.getWorldStructs(w).structs().find((Function1)new Serializable(id){
                    public static final long serialVersionUID = 0L;
                    private final int id$1;

                    public final boolean apply(BlockStruct x$1) {
                        return x$1.id() == this.id$1;
                    }
                    {
                        this.id$1 = id$1;
                    }
                });
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BlockStruct struct = (BlockStruct)some.x();
                    this.clientCycleMove(w, struct);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break;
                }
                if (None$.MODULE$.equals(option)) {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"DC: Moving structure with id ", " was not found client-side."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id)})));
                }
                throw new MatchError((Object)option);
            }
            case 1: {
                BlockStruct struct = new BlockStruct();
                struct.id_$eq(in.readUShort());
                struct.readDesc(in);
                this.addStructToWorld(w, struct);
                struct.allBlocks().foreach((Function1)new Serializable(w){
                    public static final long serialVersionUID = 0L;
                    private final World w$2;

                    public final void apply(BlockCoord b) {
                        this.w$2.func_147479_m(b.x, b.y, b.z);
                    }
                    {
                        this.w$2 = w$2;
                    }
                });
            }
        }
    }

    public void sendStruct(World w, BlockStruct struct) {
        RelocationSPH.MCByteStream out = RelocationSPH$.MODULE$.getStream(w, struct.getChunks(), 1);
        out.writeShort(struct.id());
        struct.writeDesc((MCDataOutput)out);
        RelocationSPH$.MODULE$.forceSendData();
    }

    public void sendCycle(World w, BlockStruct struct) {
        RelocationSPH$.MODULE$.getStream(w, struct.getChunks(), 2).writeShort(struct.id());
        RelocationSPH$.MODULE$.forceSendData();
    }

    public boolean isMoving(World w, int x, int y, int z) {
        return w == null ? false : this.getWorldStructs(w).contains(x, y, z);
    }

    public void addStructToWorld(World w, BlockStruct b) {
        this.getWorldStructs(w).addStruct(b);
        b.onAdded(w);
    }

    public BlockStruct getEnclosedStructure(World w, int x, int y, int z) {
        return (BlockStruct)this.getWorldStructs(w).structs().find((Function1)new Serializable(x, y, z){
            public static final long serialVersionUID = 0L;
            private final int x$20;
            private final int y$3;
            private final int z$3;

            public final boolean apply(BlockStruct x$2) {
                return x$2.contains(this.x$20, this.y$3, this.z$3);
            }
            {
                this.x$20 = x$20;
                this.y$3 = y$3;
                this.z$3 = z$3;
            }
        }).orNull(Predef$.MODULE$.$conforms());
    }

    public boolean tryStartMove(World w, scala.collection.immutable.Set<BlockCoord> blocks, int moveDir, double speed, IMovementCallback c) {
        if (blocks.size() > RelocationConfig$.MODULE$.moveLimit()) {
            return false;
        }
        MultiMap<Tuple2<Object, Object>, Object> map = new MultiMap<Tuple2<Object, Object>, Object>(){

            public Set<Object> makeSet() {
                return MultiMap.class.makeSet((MultiMap)this);
            }

            public MultiMap addBinding(Object key, Object value) {
                return MultiMap.class.addBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public MultiMap removeBinding(Object key, Object value) {
                return MultiMap.class.removeBinding((MultiMap)this, (Object)key, (Object)value);
            }

            public boolean entryExists(Object key, Function1 p) {
                return MultiMap.class.entryExists((MultiMap)this, (Object)key, (Function1)p);
            }
            {
                MultiMap.class.$init$((MultiMap)this);
            }
        };
        blocks.foreach((Function1)new Serializable(moveDir, (HashMap)map){
            public static final long serialVersionUID = 0L;
            private final int moveDir$1;
            private final HashMap map$1;

            public final HashMap<Tuple2<Object, Object>, Set<Object>> apply(BlockCoord b) {
                return (HashMap)((MultiMap)this.map$1).addBinding((Object)MathLib$.MODULE$.normal(b, this.moveDir$1), (Object)BoxesRunTime.boxToInteger((int)MathLib$.MODULE$.basis(b, this.moveDir$1)));
            }
            {
                this.moveDir$1 = moveDir$1;
                this.map$1 = map$1;
            }
        });
        int shift = (moveDir & 1) == 1 ? 1 : -1;
        Builder rowB = Predef$.MODULE$.Set().newBuilder();
        map.keys().foreach((Function1)new Serializable(moveDir, (HashMap)map, shift, rowB){
            public static final long serialVersionUID = 0L;
            public final int moveDir$1;
            private final HashMap map$1;
            public final int shift$1;
            public final Builder rowB$1;

            public final void apply(Tuple2<Object, Object> normal) {
                int[] line = (int[])((TraversableOnce)this.map$1.apply(normal)).toArray(ClassTag$.MODULE$.Int());
                int[] sline = this.shift$1 == 1 ? (int[])Predef$.MODULE$.intArrayOps(line).sorted((Ordering)Ordering.Int$.MODULE$) : (int[])Predef$.MODULE$.intArrayOps(line).sorted(package$.MODULE$.Ordering().apply((Ordering)Ordering.Int$.MODULE$).reverse());
                MathLib$.MODULE$.splitLine((Seq)Predef$.MODULE$.wrapIntArray(sline), this.shift$1).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, normal){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.tryStartMove.2 $outer;
                    private final Tuple2 normal$1;

                    public final Builder<BlockRow, scala.collection.immutable.Set<BlockRow>> apply(Tuple2<Object, Object> x$3) {
                        Tuple2<Object, Object> tuple2 = x$3;
                        if (tuple2 != null) {
                            int basis = tuple2._1$mcI$sp();
                            int size = tuple2._2$mcI$sp();
                            BlockCoord c = MathLib$.MODULE$.rhrAxis(this.$outer.moveDir$1, this.normal$1, basis + this.$outer.shift$1);
                            Builder builder = this.$outer.rowB$1.$plus$eq((Object)new BlockRow(c, this.$outer.moveDir$1, size));
                            return builder;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.normal$1 = normal$1;
                    }
                });
            }
            {
                this.moveDir$1 = moveDir$1;
                this.map$1 = map$1;
                this.shift$1 = shift$1;
                this.rowB$1 = rowB$1;
            }
        });
        scala.collection.immutable.Set rows = (scala.collection.immutable.Set)rowB.result();
        if (rows.exists((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final World w$1;

            public final boolean apply(BlockRow row) {
                return !MovingTileRegistry$.MODULE$.canRunOverBlock(this.w$1, row.pos().x, row.pos().y, row.pos().z);
            }
            {
                this.w$1 = w$1;
            }
        })) {
            return false;
        }
        rows.foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final World w$1;

            public final void apply(BlockRow r) {
                TileMovingRow$.MODULE$.setBlockForRow(this.w$1, r);
            }
            {
                this.w$1 = w$1;
            }
        });
        BlockStruct struct = new BlockStruct();
        struct.id_$eq(BlockStruct$.MODULE$.claimID());
        struct.speed_$eq(speed);
        struct.rows_$eq((scala.collection.immutable.Set<BlockRow>)rows);
        struct.callback_$eq((WeakReference<IMovementCallback>)WeakReference$.MODULE$.apply((Object)c));
        this.addStructToWorld(w, struct);
        this.sendStruct(w, struct);
        return true;
    }

    public void onTick(boolean isClient) {
        Map<Object, WorldStructs> map = this.relocationMap(isClient);
        map.withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, WorldStructs> check$ifrefutable$2) {
                Tuple2<Object, WorldStructs> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(isClient){
            public static final long serialVersionUID = 0L;
            private final boolean isClient$1;

            public final void apply(Tuple2<Object, WorldStructs> x$4) {
                Tuple2<Object, WorldStructs> tuple2 = x$4;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    int dim = tuple2._1$mcI$sp();
                    WorldStructs ws = (WorldStructs)tuple2._2();
                    if (ws.nonEmpty()) {
                        ws.pushAll();
                        World world = MovementManager2$.MODULE$.getWorld(dim, this.isClient$1);
                        if (world == null) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            ws.structs().foreach((Function1)new Serializable(this, world){
                                public static final long serialVersionUID = 0L;
                                public final World world$1;

                                public final void apply(BlockStruct bs) {
                                    bs.rows().foreach((Function1)new Serializable(this, bs){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ anonfun$onTick$2$$anonfun$apply$4 $outer;
                                        private final BlockStruct bs$1;

                                        public final void apply(BlockRow br) {
                                            br.pushEntities(this.$outer.world$1, this.bs$1.progress());
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.bs$1 = bs$1;
                                        }
                                    });
                                }
                                {
                                    this.world$1 = world$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.isClient$1 = isClient$1;
            }
        });
        if (!isClient) {
            Map fin = (Map)((TraversableLike)map.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> apply(Tuple2<Object, WorldStructs> pair) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)pair._1$mcI$sp()), ((WorldStructs)pair._2()).removeFinished());
                }
            }, Map$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> x$5) {
                    return ((TraversableOnce)x$5._2()).nonEmpty();
                }
            });
            fin.withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> check$ifrefutable$3) {
                    Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> x$6) {
                    Tuple2<Object, scala.collection.immutable.Set<BlockStruct>> tuple2 = x$6;
                    if (tuple2 != null) {
                        BoxedUnit boxedUnit;
                        int dim = tuple2._1$mcI$sp();
                        scala.collection.immutable.Set b = (scala.collection.immutable.Set)tuple2._2();
                        World w = MovementManager2$.MODULE$.getWorld(dim, false);
                        if (w == null) {
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            b.foreach((Function1)new Serializable(this, w){
                                public static final long serialVersionUID = 0L;
                                private final World w$4;

                                public final void apply(BlockStruct s) {
                                    MovementManager2$.MODULE$.cycleMove(this.w$4, s);
                                    MovementManager2$.MODULE$.sendCycle(this.w$4, s);
                                }
                                {
                                    this.w$4 = w$4;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
        }
    }

    public void onWorldUnload(World w) {
        this.getWorldStructs(w).clear();
    }

    public void clientCycleMove(World w, BlockStruct struct) {
        this.getWorldStructs(w).removeStruct(struct);
        struct.rows().foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final World w$3;

            public final void apply(BlockRow x$7) {
                x$7.pushEntities(this.w$3, 1.0);
            }
            {
                this.w$3 = w$3;
            }
        });
        this.cycleMove(w, struct);
    }

    public void cycleMove(World w, BlockStruct struct) {
        struct.doMove(w);
        struct.postMove(w);
        struct.endMove(w);
        Utils$.MODULE$.rescheduleTicks(w, struct.preMoveBlocks(), struct.allBlocks(), struct.moveDir());
        Set changes = (Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        struct.rows().foreach((Function1)new Serializable(w, changes){
            public static final long serialVersionUID = 0L;
            private final World w$5;
            private final Set changes$1;

            public final void apply(BlockRow r) {
                r.cacheChanges(this.w$5, (Set<BlockCoord>)this.changes$1);
            }
            {
                this.w$5 = w$5;
                this.changes$1 = changes$1;
            }
        });
        changes.foreach((Function1)new Serializable(w){
            public static final long serialVersionUID = 0L;
            private final World w$5;

            public final void apply(BlockCoord bc) {
                this.w$5.func_147460_e(bc.x, bc.y, bc.z, Blocks.field_150350_a);
            }
            {
                this.w$5 = w$5;
            }
        });
        Utils$.MODULE$.rerenderBlocks(w, struct.preMoveBlocks());
    }

    private MovementManager2$() {
        MODULE$ = this;
        this.serverRelocations = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.clientRelocations = (TrieMap)TrieMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

