/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.core.utils;

import com.google.common.collect.Maps;
import ganymedes01.etfuturum.api.mappings.RegistryMapping;
import ganymedes01.etfuturum.core.utils.RandomXoshiro256StarStar;
import ganymedes01.etfuturum.core.utils.helpers.BlockPos;
import java.io.File;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.profiler.Profiler;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.storage.IPlayerFileData;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;

public class DummyWorld
extends World {
    public static final DummyWorld GLOBAL_DUMMY_WORLD = new DummyWorld();
    public GT_IteratorRandom mRandom = new GT_IteratorRandom();
    private final Map<BlockPos, RegistryMapping<Block>> FAKE_WORLD_DATA = Maps.newHashMap();
    private static final RegistryMapping<Block> AIR = new RegistryMapping<Block>(Blocks.field_150350_a, 0);

    DummyWorld(ISaveHandler par1iSaveHandler, String par2Str, WorldProvider par3WorldProvider, WorldSettings par4WorldSettings, Profiler par5Profiler) {
        super(par1iSaveHandler, par2Str, par4WorldSettings, par3WorldProvider, par5Profiler);
        this.field_73012_v = this.mRandom;
    }

    public DummyWorld() {
        this(new ISaveHandler(){

            public void func_75755_a(WorldInfo var1, NBTTagCompound var2) {
            }

            public void func_75761_a(WorldInfo var1) {
            }

            public WorldInfo func_75757_d() {
                return null;
            }

            public IPlayerFileData func_75756_e() {
                return null;
            }

            public File func_75758_b(String var1) {
                return null;
            }

            public IChunkLoader func_75763_a(WorldProvider var1) {
                return null;
            }

            public void func_75759_a() {
            }

            public void func_75762_c() {
            }

            public String func_75760_g() {
                return null;
            }

            public File func_75765_b() {
                return null;
            }
        }, "DUMMY_DIMENSION", new WorldProvider(){

            public String func_80007_l() {
                return "DUMMY_DIMENSION";
            }
        }, new WorldSettings(new WorldInfo(new NBTTagCompound())), new Profiler());
    }

    protected IChunkProvider func_72970_h() {
        return null;
    }

    public Entity func_73045_a(int aEntityID) {
        return null;
    }

    public boolean func_72921_c(int aX, int aY, int aZ, int aMeta, int flags) {
        BlockPos pos = new BlockPos(aX, aY, aZ);
        if (this.FAKE_WORLD_DATA.containsKey(pos)) {
            RegistryMapping<Block> block = this.FAKE_WORLD_DATA.get(pos);
            this.func_147465_d(aX, aY, aZ, block.getObject(), aMeta, 0);
            return true;
        }
        return false;
    }

    public boolean func_147468_f(int aX, int aY, int aZ) {
        this.FAKE_WORLD_DATA.remove(new BlockPos(aX, aY, aZ));
        return true;
    }

    public boolean func_147449_b(int x, int y, int z, Block block) {
        return this.func_147465_d(x, y, z, block, 0, 0);
    }

    public boolean func_147465_d(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
        BlockPos pos = new BlockPos(aX, aY, aZ);
        if (aBlock == Blocks.field_150350_a) {
            this.FAKE_WORLD_DATA.remove(pos);
        } else {
            this.FAKE_WORLD_DATA.put(pos, new RegistryMapping<Block>(aBlock, aMeta));
        }
        return true;
    }

    public float getSunBrightnessFactor(float p_72967_1_) {
        return 1.0f;
    }

    public BiomeGenBase func_72807_a(int aX, int aZ) {
        if (aX >= 16 && aZ >= 16 && aX < 32 && aZ < 32) {
            return BiomeGenBase.field_76772_c;
        }
        return BiomeGenBase.field_76771_b;
    }

    public int func_72883_k(int aX, int aY, int aZ) {
        return 10;
    }

    public Block func_147439_a(int aX, int aY, int aZ) {
        return this.FAKE_WORLD_DATA.getOrDefault(new BlockPos(aX, aY, aZ), AIR).getObject();
    }

    public int func_72805_g(int aX, int aY, int aZ) {
        return this.FAKE_WORLD_DATA.getOrDefault(new BlockPos(aX, aY, aZ), AIR).getMeta();
    }

    public boolean func_72937_j(int aX, int aY, int aZ) {
        if (aX >= 16 && aZ >= 16 && aX < 32 && aZ < 32) {
            return aY > 64;
        }
        return true;
    }

    protected int func_152379_p() {
        return 0;
    }

    public void clearBlocksCache() {
        this.FAKE_WORLD_DATA.clear();
    }

    public static class GT_IteratorRandom
    extends RandomXoshiro256StarStar {
        private static final long serialVersionUID = 1L;
        public int mIterationStep = Integer.MAX_VALUE;

        @Override
        public int nextInt(int aParameter) {
            if (this.mIterationStep == 0 || this.mIterationStep > aParameter) {
                this.mIterationStep = aParameter;
            }
            return --this.mIterationStep;
        }
    }
}

