/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.client.renderer.vbo;

import com.gtnewhorizon.gtnhlib.client.renderer.vertex.VertexFormat;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL15;

public class VertexBuffer
implements AutoCloseable {
    private int id = GL15.glGenBuffers();
    private int vertexCount;
    private VertexFormat format;
    private int drawMode;

    public VertexBuffer() {
    }

    public VertexBuffer(VertexFormat format, int drawMode) {
        this();
        this.format = format;
        this.drawMode = drawMode;
    }

    public void bind() {
        GL15.glBindBuffer((int)34962, (int)this.id);
    }

    public void unbind() {
        GL15.glBindBuffer((int)34962, (int)0);
    }

    public void upload(ByteBuffer buffer, int vertexCount) {
        if (this.id == -1) {
            return;
        }
        this.vertexCount = vertexCount;
        this.bind();
        GL15.glBufferData((int)34962, (ByteBuffer)buffer, (int)35044);
        this.unbind();
    }

    public VertexBuffer upload(ByteBuffer buffer) {
        if (this.format == null) {
            throw new IllegalStateException("No format specified for VBO upload");
        }
        this.upload(buffer, buffer.remaining() / this.format.getVertexSize());
        return this;
    }

    @Override
    public void close() {
        if (this.id >= 0) {
            GL15.glDeleteBuffers((int)this.id);
            this.id = -1;
        }
    }

    public void draw(FloatBuffer floatBuffer) {
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glMultMatrix((FloatBuffer)floatBuffer);
        this.draw();
        GL11.glPopMatrix();
    }

    public void draw() {
        GL11.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
    }

    public void setupState() {
        if (this.format == null) {
            throw new IllegalStateException("No format specified for VBO setup");
        }
        this.bind();
        this.format.setupBufferState(0L);
    }

    public void cleanupState() {
        this.format.clearBufferState();
        this.unbind();
    }

    public void render() {
        this.setupState();
        this.draw();
        this.cleanupState();
    }
}

