/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.bytebuf;

import com.gtnewhorizon.gtnhlib.bytebuf.MemoryUtilities;
import java.nio.ByteBuffer;
import java.util.Objects;
import me.eigenraven.lwjgl3ify.api.Lwjgl3Aware;
import org.jetbrains.annotations.NotNullByDefault;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.jni.JNINativeInterface;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@Lwjgl3Aware
@NotNullByDefault
public final class CheckIntrinsics {
    private CheckIntrinsics() {
    }

    public static int classVersion() {
        return 17;
    }

    public static int checkIndex(int index, int length) {
        return Objects.checkIndex(index, length);
    }

    public static int checkFromToIndex(int fromIndex, int toIndex, int length) {
        return Objects.checkFromToIndex(fromIndex, toIndex, length);
    }

    public static int checkFromIndexSize(int fromIndex, int size, int length) {
        return Objects.checkFromIndexSize(fromIndex, size, length);
    }

    public static ByteBuffer NewDirectByteBuffer(long address, int capacity) {
        return JNINativeInterface.NewDirectByteBuffer((long)address, (long)capacity);
    }

    public static MemoryUtilities.MemoryAllocator getLwjgl3ifyAllocator() {
        return new Lwjgl3ifyAllocator();
    }

    @Lwjgl3Aware
    private static final class Lwjgl3ifyAllocator
    implements MemoryUtilities.MemoryAllocator {
        private Lwjgl3ifyAllocator() {
        }

        @Override
        public long malloc(long size) {
            return MemoryUtil.nmemAlloc((long)size);
        }

        @Override
        public long calloc(long num, long size) {
            return MemoryUtil.nmemCalloc((long)num, (long)size);
        }

        @Override
        public long realloc(long ptr, long size) {
            return MemoryUtil.nmemRealloc((long)ptr, (long)size);
        }

        @Override
        public void free(long ptr) {
            MemoryUtil.nmemFree((long)ptr);
        }
    }
}

