/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.forestry.handlers;

import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.recipes.IMoistenerManager;
import forestry.api.recipes.IMoistenerRecipe;
import forestry.api.recipes.RecipeManagers;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.forestry.ForestryListAddition;
import modtweaker2.mods.forestry.ForestryListRemoval;
import modtweaker2.mods.forestry.recipes.MoistenerRecipe;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.forestry.Moistener")
public class Moistener {
    public static final String name = "Forestry Moistener";
    public static final String nameFuel = "Forestry Moistener (Fuel)";

    @ZenMethod
    public static void addRecipe(IItemStack output, IItemStack resource, int timePerItem) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MoistenerRecipe(InputHelper.toStack(resource), InputHelper.toStack(output), timePerItem)));
    }

    @Deprecated
    @ZenMethod
    public static void addRecipe(int timePerItem, IItemStack resource, IItemStack product) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new MoistenerRecipe(InputHelper.toStack(resource), InputHelper.toStack(product), timePerItem)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<IMoistenerRecipe> recipes = new LinkedList<IMoistenerRecipe>();
        for (IMoistenerRecipe recipe : RecipeManagers.moistenerManager.recipes()) {
            if (recipe == null || recipe.getProduct() == null || !StackHelper.matches(output, InputHelper.toIItemStack(recipe.getProduct()))) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    @ZenMethod
    public static void addFuel(IItemStack item, IItemStack product, int moistenerValue, int stage) {
        if (stage >= 0) {
            MineTweakerAPI.apply((IUndoableAction)new AddFuel(new MoistenerFuel(InputHelper.toStack(item), InputHelper.toStack(product), moistenerValue, stage)));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe add for %s. Stage parameter must positive!", name, item.toString()));
        }
    }

    @ZenMethod
    public static void removeFuel(IIngredient moistenerItem) {
        HashMap<ItemStack, MoistenerFuel> fuelItems = new HashMap<ItemStack, MoistenerFuel>();
        for (Map.Entry fuelItem : FuelManager.moistenerResource.entrySet()) {
            if (fuelItem == null || !StackHelper.matches(moistenerItem, InputHelper.toIItemStack(((MoistenerFuel)fuelItem.getValue()).item))) continue;
            fuelItems.put((ItemStack)fuelItem.getKey(), (MoistenerFuel)fuelItem.getValue());
        }
        if (!fuelItems.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveFuel(fuelItems));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, moistenerItem.toString()));
        }
    }

    private static class RemoveFuel
    extends BaseMapRemoval<ItemStack, MoistenerFuel> {
        public RemoveFuel(Map<ItemStack, MoistenerFuel> recipes) {
            super(Moistener.nameFuel, FuelManager.moistenerResource, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class AddFuel
    extends BaseMapAddition<ItemStack, MoistenerFuel> {
        public AddFuel(MoistenerFuel fuelEntry) {
            super(Moistener.nameFuel, FuelManager.moistenerResource);
            this.recipes.put(fuelEntry.item, fuelEntry);
        }

        @Override
        public String getRecipeInfo(Map.Entry<ItemStack, MoistenerFuel> fuelEntry) {
            return LogHelper.getStackDescription(fuelEntry.getKey());
        }
    }

    private static class Remove
    extends ForestryListRemoval<IMoistenerRecipe, IMoistenerManager> {
        public Remove(List<IMoistenerRecipe> recipes) {
            super(Moistener.name, RecipeManagers.moistenerManager, recipes);
        }

        @Override
        public String getRecipeInfo(IMoistenerRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getProduct());
        }
    }

    private static class Add
    extends ForestryListAddition<IMoistenerRecipe, IMoistenerManager> {
        public Add(IMoistenerRecipe recipe) {
            super(Moistener.name, RecipeManagers.moistenerManager);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(IMoistenerRecipe recipe) {
            return LogHelper.getStackDescription(recipe.getProduct());
        }
    }
}

