/*
 * Decompiled with CFR 0.152.
 */
package kubatech.tileentity.gregtech.multiblock.eigbuckets;

import gregtech.mixin.interfaces.accessors.IBlockStemAccessor;
import java.util.ArrayList;
import kubatech.api.eig.EIGBucket;
import kubatech.api.eig.EIGDropTable;
import kubatech.api.eig.IEIGBucketFactory;
import kubatech.tileentity.gregtech.multiblock.MTEExtremeIndustrialGreenhouse;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.IPlantable;

public class EIGStemBucket
extends EIGBucket {
    public static final IEIGBucketFactory factory = new Factory();
    private static final String NBT_IDENTIFIER = "STEM";
    private static final int REVISION_NUMBER = 0;
    private static final int NUMBER_OF_DROPS_TO_SIMULATE = 100;
    private boolean isValid = false;
    private EIGDropTable drops = new EIGDropTable();

    private EIGStemBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
        super(input, 1, null);
        this.recalculateDrops(greenhouse);
    }

    private EIGStemBucket(NBTTagCompound nbt) {
        super(nbt);
        this.drops = new EIGDropTable(nbt, "drops");
        this.isValid = nbt.func_74762_e("version") == 0 && !this.drops.isEmpty();
    }

    @Override
    public NBTTagCompound save() {
        NBTTagCompound nbt = super.save();
        if (this.drops != null) {
            nbt.func_74782_a("drops", (NBTBase)this.drops.save());
        }
        nbt.func_74768_a("version", 0);
        return nbt;
    }

    @Override
    protected String getNBTIdentifier() {
        return NBT_IDENTIFIER;
    }

    @Override
    public void addProgress(double multiplier, EIGDropTable tracker) {
        if (!this.isValid()) {
            return;
        }
        this.drops.addTo(tracker, multiplier * (double)this.seedCount);
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.isValid;
    }

    @Override
    public boolean revalidate(MTEExtremeIndustrialGreenhouse greenhouse) {
        this.recalculateDrops(greenhouse);
        return this.isValid();
    }

    public void recalculateDrops(MTEExtremeIndustrialGreenhouse greenhouse) {
        this.isValid = false;
        Item item = this.seed.func_77973_b();
        if (!(item instanceof IPlantable)) {
            return;
        }
        Block stemBlock = ((IPlantable)item).getPlant((IBlockAccess)greenhouse.getBaseMetaTileEntity().getWorld(), 0, 0, 0);
        if (!(stemBlock instanceof BlockStem)) {
            return;
        }
        Block cropBlock = ((IBlockStemAccessor)stemBlock).gt5u$getCropBlock();
        if (cropBlock == null || cropBlock == Blocks.field_150350_a) {
            return;
        }
        int metadata = 0;
        EIGDropTable drops = new EIGDropTable();
        for (int i = 0; i < 100; ++i) {
            ItemStack drop;
            ArrayList blockDrops = cropBlock.getDrops(greenhouse.getBaseMetaTileEntity().getWorld(), greenhouse.getBaseMetaTileEntity().getXCoord(), (int)greenhouse.getBaseMetaTileEntity().getYCoord(), greenhouse.getBaseMetaTileEntity().getZCoord(), metadata, 0);
            if (blockDrops == null || blockDrops.isEmpty()) continue;
            if (i == 0 && blockDrops.size() == 1 && (drop = (ItemStack)blockDrops.get(0)) != null && drop.field_77994_a >= 1 && drop.func_77973_b() == Item.func_150898_a((Block)cropBlock)) {
                drops.addDrop(drop, drop.field_77994_a);
                break;
            }
            for (ItemStack drop2 : blockDrops) {
                drops.addDrop(drop2, (double)drop2.field_77994_a / 100.0);
            }
        }
        if (drops.isEmpty()) {
            return;
        }
        this.drops = drops;
        this.isValid = true;
    }

    public static class Factory
    implements IEIGBucketFactory {
        @Override
        public String getNBTIdentifier() {
            return EIGStemBucket.NBT_IDENTIFIER;
        }

        @Override
        public EIGBucket tryCreateBucket(MTEExtremeIndustrialGreenhouse greenhouse, ItemStack input) {
            Item item = input.func_77973_b();
            if (!(item instanceof IPlantable)) {
                return null;
            }
            Block block = ((IPlantable)item).getPlant((IBlockAccess)greenhouse.getBaseMetaTileEntity().getWorld(), 0, 0, 0);
            if (!(block instanceof BlockStem)) {
                return null;
            }
            return new EIGStemBucket(greenhouse, input);
        }

        @Override
        public EIGBucket restore(NBTTagCompound nbt) {
            return new EIGStemBucket(nbt);
        }
    }
}

