/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.tinkers.util;

import gregtech.api.enums.GTValues;
import gregtech.api.enums.TierEU;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.recipe.GTPPRecipeMaps;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import tconstruct.library.crafting.DryingRackRecipes;

public class TinkersDryingRecipe {
    public static ArrayList<TinkersDryingRecipe> recipes = new ArrayList();
    public final int time;
    public final ItemStack input;
    public final ItemStack result;

    public TinkersDryingRecipe(ItemStack input, int time, ItemStack result) {
        this.time = time;
        this.input = input;
        this.result = result;
        Logger.INFO("Generating Drying Recipe. Input: " + input.func_82833_r() + ", Output: " + result.func_82833_r());
    }

    public static void generateAllDryingRecipes() {
        List<DryingRackRecipes.DryingRecipe> aRecipes = TinkersDryingRecipe.getDryingRecipes();
        if (!aRecipes.isEmpty()) {
            for (DryingRackRecipes.DryingRecipe recipe : aRecipes) {
                Logger.INFO("Trying to generate recipe using object of type " + recipe.getClass().getSimpleName());
                TinkersDryingRecipe.generateFromTinkersRecipe(recipe);
            }
        } else {
            Logger.INFO("Error generating Drying recipes, map was empty. Size: " + aRecipes.size());
        }
        if (!recipes.isEmpty()) {
            Logger.INFO("Adding " + recipes.size() + " drying rack recipes to the dehydrator.");
            for (TinkersDryingRecipe r : recipes) {
                GTValues.RA.stdBuilder().itemInputs(GTUtility.getIntegratedCircuit(16), r.input).itemOutputs(r.result).eut(TierEU.RECIPE_LV).duration(r.time / 10).addTo(GTPPRecipeMaps.chemicalDehydratorRecipes);
            }
        }
    }

    private static void generateFromTinkersRecipe(DryingRackRecipes.DryingRecipe recipe) {
        recipes.add(new TinkersDryingRecipe(recipe.input, recipe.time, recipe.result));
    }

    private static List<DryingRackRecipes.DryingRecipe> getDryingRecipes() {
        ArrayList<DryingRackRecipes.DryingRecipe> aData = new ArrayList<DryingRackRecipes.DryingRecipe>();
        int aCount = 0;
        for (DryingRackRecipes.DryingRecipe recipe : DryingRackRecipes.recipes) {
            aData.add(recipe);
            ++aCount;
        }
        Logger.INFO("Found " + aCount + " Tinkers drying rack recipes.");
        return aData;
    }

    public boolean matches(ItemStack input) {
        if (input.func_77942_o()) {
            input = input.func_77946_l();
            input.func_77978_p().func_82580_o("frypanKill");
            if (input.func_77978_p().func_82582_d()) {
                input.func_77982_d(null);
            }
        }
        return ItemStack.func_77989_b((ItemStack)this.input, (ItemStack)input);
    }

    public ItemStack getResult() {
        return this.result.func_77946_l();
    }
}

