/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.algae;

import com.gtnewhorizon.structurelib.alignment.IAlignmentLimits;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.TAE;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStreamUtil;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.ReflectionUtil;
import gregtech.common.pollution.PollutionConfig;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.block.ModBlocks;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.enums.GregtechItemList;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.base.GTPPMultiBlockBase;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import ic2.core.init.BlocksItems;
import ic2.core.init.InternalName;
import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEAlgaePondBase
extends GTPPMultiBlockBase<MTEAlgaePondBase>
implements ISurvivalConstructable {
    private int mLevel = -1;
    private int mCasing;
    private static IStructureDefinition<MTEAlgaePondBase> STRUCTURE_DEFINITION = null;
    private int checkMeta;
    private static final Class<?> cofhWater = ReflectionUtil.getClass("cofh.asmhooks.block.BlockWater");
    private static final int[] aDurations = new int[]{2000, 1800, 1600, 1400, 1200, 1000, 512, 256, 128, 64, 32, 16, 8, 4, 2, 1};

    public MTEAlgaePondBase(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAlgaePondBase(String aName) {
        super(aName);
    }

    @Override
    public boolean supportsPowerPanel() {
        return false;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAlgaePondBase(this.mName);
    }

    @Override
    public String getMachineType() {
        return "Algae Pond";
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(this.getMachineType()).addInfo("Grows Algae!").addInfo("Provide compost to boost production by one tier").addInfo("Does not require power or maintenance").addInfo("All Machine Casings must be the same tier, this dictates machine speed").addInfo("Requires one Input Hatch that matches the tier of the Casings").addInfo("Fill Input Hatch with Water to fill the inside of the multiblock").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(9, 3, 9, true).addController("Front Center").addCasingInfoMin("Machine Casings", 64, true).addCasingInfoMin("Sterile Farm Casings", 64, false).addInputBus("Any Casing", 1).addOutputBus("Any Casing", 1).addInputHatch("Any Casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    public void setMeta(int meta) {
        this.checkMeta = meta;
    }

    public int getMeta() {
        return this.checkMeta;
    }

    @Override
    public IStructureDefinition<MTEAlgaePondBase> getStructureDefinition() {
        if (STRUCTURE_DEFINITION == null) {
            STRUCTURE_DEFINITION = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"XXXXXXXXX", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "X       X", "XXXXXXXXX"}, {"CCCC~CCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC", "CCCCCCCCC"}})).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEAlgaePondBase.class).atLeast(HatchElement.InputHatch, HatchElement.InputBus, HatchElement.OutputBus).casingIndex(TAE.getIndexFromPage(1, 15)).dot(1).build(), StructureUtility.onElementPass(x -> ++x.mCasing, MTEAlgaePondBase.addTieredBlock(GregTechAPI.sBlockCasings1, MTEAlgaePondBase::setMeta, MTEAlgaePondBase::getMeta, 10)), StructureUtility.onElementPass(x -> ++x.mCasing, MTEAlgaePondBase.addTieredBlock(GregTechAPI.sBlockCasingsNH, MTEAlgaePondBase::setMeta, MTEAlgaePondBase::getMeta, 10, 15))})).addElement('X', StructureUtility.ofBlock((Block)ModBlocks.blockCasings2Misc, (int)15)).build();
        }
        return STRUCTURE_DEFINITION;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(this.mName, stackSize, hintsOnly, 4, 2, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece(this.mName, stackSize, 4, 2, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mCasing = 0;
        this.mLevel = 0;
        this.checkMeta = 0;
        if (this.checkPiece(this.mName, 4, 2, 0) && this.mCasing >= 64 && this.checkMeta > 0 && !this.mInputHatches.isEmpty() && !this.mOutputBusses.isEmpty()) {
            this.mLevel = this.checkMeta - 1;
            for (MTEHatchInput inputHatch : this.mInputHatches) {
                if (inputHatch.mTier >= this.mLevel) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected IAlignmentLimits getInitialAlignmentLimits() {
        return (d, r, f) -> d.offsetY == 0 && r.isNotRotated() && !f.isVerticallyFliped();
    }

    @Override
    protected SoundResource getProcessStartSound() {
        return SoundResource.GTCEU_LOOP_BATH;
    }

    @Override
    protected IIconContainer getActiveOverlay() {
        return TexturesGtBlock.oMCDAlgaePondBaseActive;
    }

    @Override
    protected IIconContainer getActiveGlowOverlay() {
        return TexturesGtBlock.oMCDAlgaePondBaseActiveGlow;
    }

    @Override
    protected IIconContainer getInactiveOverlay() {
        return TexturesGtBlock.oMCDAlgaePondBase;
    }

    @Override
    protected IIconContainer getInactiveGlowOverlay() {
        return TexturesGtBlock.oMCDAlgaePondBaseGlow;
    }

    @Override
    protected int getCasingTextureId() {
        int aID = TAE.getIndexFromPage(1, 15);
        if (this.mLevel > -1) {
            aID = this.mLevel;
        }
        return aID;
    }

    @Override
    public int getMaxParallelRecipes() {
        return 2;
    }

    public boolean checkForWater() {
        boolean isValidWater;
        IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
        int mDirectionX = aBaseMetaTileEntity.getBackFacing().offsetX;
        int mOffsetX_Lower = 0;
        int mOffsetX_Upper = 0;
        int mOffsetZ_Lower = 0;
        int mOffsetZ_Upper = 0;
        int mCurrentDirectionX = 4;
        int mCurrentDirectionZ = 4;
        mOffsetX_Lower = -4;
        mOffsetX_Upper = 4;
        mOffsetZ_Lower = -4;
        mOffsetZ_Upper = 4;
        int xDir = aBaseMetaTileEntity.getBackFacing().offsetX * mCurrentDirectionX;
        int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ * mCurrentDirectionZ;
        int tAmount = 0;
        for (int i = mOffsetX_Lower + 1; i <= mOffsetX_Upper - 1; ++i) {
            for (int j = mOffsetZ_Lower + 1; j <= mOffsetZ_Upper - 1; ++j) {
                for (int h = 0; h < 2; ++h) {
                    int tMeta;
                    Block tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j);
                    if (this.isNotStaticWater(tBlock, tMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir + i, h, zDir + j)) && this.getStoredFluids() != null) {
                        for (FluidStack stored : this.getStoredFluids()) {
                            if (!stored.isFluidEqual(Materials.Water.getFluid(1L)) || stored.amount < 1000) continue;
                            stored.amount -= 1000;
                            Block fluidUsed = Blocks.field_150355_j;
                            aBaseMetaTileEntity.getWorld().func_147449_b(aBaseMetaTileEntity.getXCoord() + xDir + i, aBaseMetaTileEntity.getYCoord() + h, aBaseMetaTileEntity.getZCoord() + zDir + j, fluidUsed);
                        }
                    }
                    if ((tBlock = aBaseMetaTileEntity.getBlockOffset(xDir + i, h, zDir + j)) != Blocks.field_150355_j && tBlock != Blocks.field_150358_i && tBlock != BlocksItems.getFluidBlock((InternalName)InternalName.fluidDistilledWater)) continue;
                    ++tAmount;
                }
            }
        }
        boolean bl = isValidWater = tAmount >= 49;
        if (isValidWater) {
            Logger.INFO("Filled structure.");
            return true;
        }
        return false;
    }

    private boolean isNotStaticWater(Block block, int meta) {
        return block == Blocks.field_150350_a || block == Blocks.field_150358_i || cofhWater != null && cofhWater.isAssignableFrom(block.getClass()) && meta != 0;
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return PollutionConfig.pollutionPerSecondMultiAlgaePond;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isClientSide()) {
            this.mLevel = this.getCasingTier();
        }
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @Nonnull
            protected Stream<GTRecipe> findRecipeMatches(@Nullable RecipeMap<?> map) {
                return GTStreamUtil.ofNullable(MTEAlgaePondBase.getTieredRecipe(MTEAlgaePondBase.this.mLevel, this.inputItems));
            }

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (!MTEAlgaePondBase.this.checkForWater()) {
                    return SimpleCheckRecipeResult.ofFailure("no_water");
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        }.setEuModifier(0.0).setMaxParallelSupplier(this::getTrueParallel);
    }

    private int getCasingTier() {
        if (this.getBaseMetaTileEntity().getWorld() == null) {
            return 0;
        }
        try {
            IGregTechTileEntity aBaseMetaTileEntity = this.getBaseMetaTileEntity();
            int xDir = aBaseMetaTileEntity.getBackFacing().offsetX;
            int zDir = aBaseMetaTileEntity.getBackFacing().offsetZ;
            Block aInitStructureCheck = aBaseMetaTileEntity.getBlockOffset(xDir, -1, zDir);
            int aInitStructureCheckMeta = aBaseMetaTileEntity.getMetaIDOffset(xDir, -1, zDir);
            if (aInitStructureCheck == GregTechAPI.sBlockCasings1 || aInitStructureCheck == GregTechAPI.sBlockCasingsNH) {
                return aInitStructureCheckMeta;
            }
            return 0;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return 0;
        }
    }

    @Override
    public boolean getDefaultHasMaintenanceChecks() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.GT_MACHINES_ALGAE_LOOP;
    }

    private static GTRecipe getTieredRecipe(int aTier, ItemStack[] aItemInputs) {
        return MTEAlgaePondBase.generateBaseRecipe(aTier, MTEAlgaePondBase.isUsingCompost(aItemInputs, aTier));
    }

    private static boolean isUsingCompost(ItemStack[] aItemInputs, int aTier) {
        ItemStack aCompost = GregtechItemList.Compost.get(1L, new Object[0]);
        int compostForTier = MTEAlgaePondBase.compostForTier(aTier);
        int compostFound = 0;
        for (ItemStack i : aItemInputs) {
            if (!GTUtility.areStacksEqual(aCompost, i) || (compostFound += i.field_77994_a) < compostForTier) continue;
            return true;
        }
        return false;
    }

    private static int compostForTier(int aTier) {
        return aTier > 1 ? (int)Math.min(64.0, GTUtility.powInt(2.0, aTier - 1)) : 1;
    }

    private static GTRecipe generateBaseRecipe(int aTier, boolean isUsingCompost) {
        ItemStack[] aInputs;
        if (aTier < 0) {
            return null;
        }
        if (isUsingCompost) {
            ItemStack aCompost = GregtechItemList.Compost.get(MTEAlgaePondBase.compostForTier(aTier), new Object[0]);
            aInputs = new ItemStack[]{aCompost};
            ++aTier;
        } else {
            aInputs = GTValues.emptyItemStackArray;
        }
        ItemStack[] aOutputs = MTEAlgaePondBase.getOutputsForTier(aTier);
        GTRecipe tRecipe = new GTRecipe(false, aInputs, aOutputs, null, GTValues.emptyIntArray, new FluidStack[]{GTValues.NF}, new FluidStack[]{GTValues.NF}, MTEAlgaePondBase.getRecipeDuration(aTier), 0, 0);
        tRecipe.mSpecialValue = tRecipe.hashCode();
        return tRecipe;
    }

    private static int getRecipeDuration(int aTier) {
        float randFloat = GTPPCore.RANDOM.nextFloat();
        float randMult = (double)randFloat < 0.96237624 ? 1.0f : ((double)randFloat < 0.9912871 ? 2.0f : 3.0f);
        return (int)((float)aDurations[aTier] * randMult / 2.0f);
    }

    private static ItemStack[] getOutputsForTier(int aTier) {
        ArrayList<ItemStack> outputList = new ArrayList<ItemStack>();
        if (aTier >= 0) {
            outputList.add(GregtechItemList.AlgaeBiomass.get(2L, new Object[0]));
            outputList.add(GregtechItemList.AlgaeBiomass.get(4L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.GreenAlgaeBiomass.get(2L, new Object[0]));
            }
        }
        if (aTier >= 1) {
            outputList.add(GregtechItemList.AlgaeBiomass.get(4L, new Object[0]));
            outputList.add(GregtechItemList.GreenAlgaeBiomass.get(2L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.GreenAlgaeBiomass.get(4L, new Object[0]));
            }
        }
        if (aTier >= 2) {
            outputList.add(GregtechItemList.GreenAlgaeBiomass.get(2L, new Object[0]));
            outputList.add(GregtechItemList.GreenAlgaeBiomass.get(3L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.GreenAlgaeBiomass.get(8L, new Object[0]));
            }
        }
        if (aTier >= 3) {
            outputList.add(GregtechItemList.GreenAlgaeBiomass.get(4L, new Object[0]));
            outputList.add(GregtechItemList.BrownAlgaeBiomass.get(1L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.BrownAlgaeBiomass.get(4L, new Object[0]));
            }
        }
        if (aTier >= 4) {
            outputList.add(GregtechItemList.BrownAlgaeBiomass.get(2L, new Object[0]));
            outputList.add(GregtechItemList.BrownAlgaeBiomass.get(3L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.GoldenBrownAlgaeBiomass.get(4L, new Object[0]));
            }
        }
        if (aTier >= 5) {
            outputList.add(GregtechItemList.BrownAlgaeBiomass.get(4L, new Object[0]));
            outputList.add(GregtechItemList.GoldenBrownAlgaeBiomass.get(2L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.RedAlgaeBiomass.get(4L, new Object[0]));
            }
        }
        if (aTier >= 6) {
            outputList.add(GregtechItemList.GoldenBrownAlgaeBiomass.get(4L, new Object[0]));
            outputList.add(GregtechItemList.RedAlgaeBiomass.get(2L, new Object[0]));
            if (MathUtils.randInt(0, 10) > 9) {
                outputList.add(GregtechItemList.RedAlgaeBiomass.get(8L, new Object[0]));
            }
            for (int i = 0; i < 20 && aTier >= 6 + i; ++i) {
                int aMulti = i + 1;
                outputList.add(GregtechItemList.GreenAlgaeBiomass.get(aMulti * 4, new Object[0]));
                outputList.add(GregtechItemList.BrownAlgaeBiomass.get(aMulti * 3, new Object[0]));
                outputList.add(GregtechItemList.GoldenBrownAlgaeBiomass.get(aMulti * 2, new Object[0]));
                outputList.add(GregtechItemList.RedAlgaeBiomass.get(aMulti, new Object[0]));
            }
        }
        return outputList.toArray(new ItemStack[0]);
    }
}

