/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.automation;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import gtPlusPlus.core.lib.GTPPCore;
import gtPlusPlus.xmod.gregtech.common.blocks.textures.TexturesGtBlock;
import gtPlusPlus.xmod.gregtech.common.helpers.tesseract.TesseractHelper;
import gtPlusPlus.xmod.gregtech.common.tileentities.automation.MTETesseractGenerator;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import org.apache.commons.lang3.ArrayUtils;

public class MTETesseractTerminal
extends MTEBasicTank {
    public int mFrequency = 0;
    public UUID mOwner;
    public boolean mDidWork = false;
    public static boolean sInterDimensionalTesseractAllowed = true;
    private static int TESSERACT_ENERGY_COST = 128;
    private static int TESSERACT_ENERGY_COST_DIMENSIONAL = 512;

    public MTETesseractTerminal(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 3, "", new ITexture[0]);
    }

    public MTETesseractTerminal(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 3, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTETesseractTerminal(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getBackFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return this.getBaseMetaTileEntity().getEUCapacity() / 100L;
    }

    @Override
    public long maxEUInput() {
        return TESSERACT_ENERGY_COST_DIMENSIONAL;
    }

    @Override
    public long maxEUStore() {
        return (long)TESSERACT_ENERGY_COST_DIMENSIONAL * 8L * 32L;
    }

    @Override
    public boolean ownerControl() {
        return true;
    }

    @Override
    public int getProgresstime() {
        return this.getTesseract(this.mFrequency, false) != null ? 999 : 0;
    }

    @Override
    public int maxProgresstime() {
        return 1000;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("mFrequency", this.mFrequency);
        aNBT.func_74778_a("mOwner", this.mOwner.toString());
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.mFrequency = aNBT.func_74762_e("mFrequency");
        this.mOwner = UUID.fromString(aNBT.func_74779_i("mOnwer"));
    }

    @Override
    public void onConfigLoad() {
        sInterDimensionalTesseractAllowed = true;
        TESSERACT_ENERGY_COST = 512;
        TESSERACT_ENERGY_COST_DIMENSIONAL = 2048;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        if (this.mOwner == null && this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().isEmpty() && this.getBaseMetaTileEntity().getOwnerName().equalsIgnoreCase(aPlayer.getDisplayName())) {
            this.mOwner = GTMod.proxy.getPlayersUUID(this.getBaseMetaTileEntity().getOwnerName());
        }
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GTUtility.getClickedFacingCoords(side, aX, aY, aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        --this.mFrequency;
                        break;
                    }
                    case 1: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ++this.mFrequency;
                    }
                    default: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                            break;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
                GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency);
                if (this.getTesseract(this.mFrequency, false) != null) {
                    GTUtility.sendChatToPlayer(aPlayer, EnumChatFormatting.GREEN + " (Connected)");
                }
            }
        } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
            GTUtility.sendChatToPlayer(aPlayer, "This is not your Tesseract Terminal to configure.");
        }
        return true;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_110124_au().compareTo(this.mOwner) == 0) {
            if (side == this.getBaseMetaTileEntity().getFrontFacing()) {
                float[] tCoords = GTUtility.getClickedFacingCoords(side, aX, aY, aZ);
                switch ((byte)((byte)(tCoords[0] * 2.0f) + 2 * (byte)(tCoords[1] * 2.0f))) {
                    case 0: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 64;
                        break;
                    }
                    case 1: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 64;
                        break;
                    }
                    case 2: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency -= 512;
                        break;
                    }
                    case 3: {
                        try {
                            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        this.mFrequency += 512;
                    }
                }
                GTUtility.sendChatToPlayer(aPlayer, "Frequency: " + this.mFrequency + (this.getTesseract(this.mFrequency, false) == null ? "" : EnumChatFormatting.GREEN + " (Connected)"));
            }
        } else if (aPlayer.func_110124_au().compareTo(this.mOwner) != 0) {
            GTUtility.sendChatToPlayer(aPlayer, "This is not your Tesseract Terminal to configure.");
        }
    }

    public boolean allowCoverOnSide(ForgeDirection side, int aCoverID) {
        return side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    public MTETesseractGenerator getTesseract(int aFrequency, boolean aWorkIrrelevant) {
        MTETesseractGenerator rTesseract = TesseractHelper.getGeneratorByFrequency((EntityPlayer)GTMod.proxy.getPlayerMP(this.mOwner), aFrequency);
        if (rTesseract == null) {
            return null;
        }
        if (!TesseractHelper.isGeneratorOwnedByPlayer((EntityPlayer)GTMod.proxy.getPlayerMP(this.mOwner), rTesseract)) {
            return null;
        }
        if (rTesseract.mFrequency != aFrequency) {
            TesseractHelper.setTerminalOwnershipByPlayer((EntityPlayer)GTMod.proxy.getPlayerMP(this.mOwner), aFrequency, null);
            return null;
        }
        if (!rTesseract.isValidTesseractGenerator(this.getBaseMetaTileEntity().getOwnerName(), aWorkIrrelevant)) {
            return null;
        }
        if (!sInterDimensionalTesseractAllowed && rTesseract.getBaseMetaTileEntity().getWorld() != this.getBaseMetaTileEntity().getWorld()) {
            return null;
        }
        return rTesseract;
    }

    @Override
    public String[] getInfoData() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity != null && this.getBaseMetaTileEntity().isAllowedToWork() && tTileEntity.isSendingInformation()) {
            return tTileEntity.getInfoData();
        }
        return new String[]{StatCollector.func_74838_a((String)"gtpp.infodata.tesseract_generator.name"), StatCollector.func_74837_a((String)"gtpp.infodata.tesseract_generator.frequency", (Object[])new Object[]{this.mFrequency}), this.getTesseract(this.mFrequency, false) != null ? StatCollector.func_74838_a((String)"gtpp.infodata.tesseract_generator.status.active") : StatCollector.func_74838_a((String)"gtpp.infodata.tesseract_generator.status.inactive")};
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public boolean isDigitalChest() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.isDigitalChest();
    }

    @Override
    public ItemStack[] getStoredItemData() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.getStoredItemData();
    }

    @Override
    public void setItemCount(int aCount) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.setItemCount(aCount);
    }

    @Override
    public int getMaxItemCount() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.getMaxItemCount();
    }

    @Override
    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_94041_b(aIndex, aStack);
    }

    @Override
    public int[] func_94128_d(int ordinalSide) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return GTValues.emptyIntArray;
        }
        return tTileEntity.func_94128_d(ordinalSide);
    }

    @Override
    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_102007_a(aIndex, aStack, ordinalSide);
    }

    @Override
    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.func_102008_b(aIndex, aStack, ordinalSide);
    }

    @Override
    public int func_70302_i_() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int aIndex) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70301_a(aIndex);
    }

    @Override
    public void func_70299_a(int aIndex, ItemStack aStack) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return;
        }
        tTileEntity.func_70299_a(aIndex, aStack);
    }

    @Override
    public ItemStack func_70298_a(int aIndex, int aAmount) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.func_70298_a(aIndex, aAmount);
    }

    @Override
    public String func_145825_b() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return "";
        }
        return tTileEntity.func_145825_b();
    }

    @Override
    public int func_70297_j_() {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.func_70297_j_();
    }

    @Override
    public boolean canFill(ForgeDirection aSide, Fluid aFluid) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canFill(aSide, aFluid);
    }

    @Override
    public boolean canDrain(ForgeDirection aSide, Fluid aFluid) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return false;
        }
        return tTileEntity.canDrain(aSide, aFluid);
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection aSide) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return GTValues.emptyFluidTankInfo;
        }
        return tTileEntity.getTankInfo(aSide);
    }

    @Override
    public int fill(ForgeDirection aDirection, FluidStack aFluid, boolean doFill) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return 0;
        }
        return tTileEntity.fill(aDirection, aFluid, doFill);
    }

    @Override
    public FluidStack drain(ForgeDirection aDirection, int maxDrain, boolean doDrain) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aDirection, maxDrain, doDrain);
    }

    @Override
    public FluidStack drain(ForgeDirection aSide, FluidStack aFluid, boolean doDrain) {
        MTETesseractGenerator tTileEntity = this.getTesseract(this.mFrequency, false);
        if (tTileEntity == null || !this.getBaseMetaTileEntity().isAllowedToWork()) {
            return null;
        }
        return tTileEntity.drain(aSide, aFluid, doDrain);
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide() && this.getBaseMetaTileEntity().isAllowedToWork()) {
            MTETesseractGenerator tTileEntity;
            if (GTMod.proxy.getPlayersUUID(this.getBaseMetaTileEntity().getOwnerName()) != null && this.mOwner == null) {
                this.mOwner = GTMod.proxy.getPlayersUUID(this.getBaseMetaTileEntity().getOwnerName());
            }
            if ((tTileEntity = this.getTesseract(this.mFrequency, true)) != null) {
                tTileEntity.addEnergyConsumption(this);
                if (!this.mDidWork && this.getTesseract(this.mFrequency, false) != null) {
                    this.mDidWork = true;
                    this.getBaseMetaTileEntity().issueBlockUpdate();
                    this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(128L, false);
                }
            } else if (this.mDidWork) {
                this.mDidWork = false;
                this.getBaseMetaTileEntity().issueBlockUpdate();
            }
        }
    }

    @Override
    public String[] getDescription() {
        return (String[])ArrayUtils.addAll((Object[])this.mDescriptionArray, (Object[])new String[]{"Accesses Tesseract Generators remotely", "Connect with pipes to extract items or fluids", "Outputs from the back face", "Consumes " + TESSERACT_ENERGY_COST + "EU/t for same dimension transfers", "Consumes " + TESSERACT_ENERGY_COST_DIMENSIONAL + "EU/t for cross dimensional transfers", GTPPCore.GT_Tooltip.get()});
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return new ITexture[0][0][0];
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int aColorIndex, boolean aActive, boolean aRedstone) {
        ITexture[] iTextureArray;
        if (side == facing) {
            ITexture[] iTextureArray2 = new ITexture[2];
            iTextureArray2[0] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray2;
            iTextureArray2[1] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Screen_Frequency);
        } else {
            ITexture[] iTextureArray3 = new ITexture[2];
            iTextureArray3[0] = TextureFactory.of(TexturesGtBlock.Casing_Machine_Dimensional);
            iTextureArray = iTextureArray3;
            iTextureArray3[1] = TextureFactory.of(Textures.BlockIcons.VOID);
        }
        return iTextureArray;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public boolean doesEmptyContainers() {
        return false;
    }

    @Override
    public boolean canTankBeFilled() {
        return false;
    }

    @Override
    public boolean canTankBeEmptied() {
        return false;
    }

    @Override
    public void onCreated(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (this.getBaseMetaTileEntity().getOwnerName() != null && !this.getBaseMetaTileEntity().getOwnerName().isEmpty()) {
            this.mOwner = GTMod.proxy.getPlayersUUID(this.getBaseMetaTileEntity().getOwnerName());
        }
        super.onCreated(aStack, aWorld, aPlayer);
    }

    @Override
    public void onRemoval() {
        try {
            GTPPCore.sTesseractTerminalOwnershipMap.get(this.mOwner).remove(this.mFrequency);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.onRemoval();
    }
}

