/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import gregtech.GTMod;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMagLevPylon
extends MTETieredMachineBlock {
    private static final int BASE_PYLON_RANGE = 16;
    private final int poweredRange;
    private final int unpoweredRange;
    private final long powerCost;
    private int playersConnected;
    private int range;

    public MTEMagLevPylon(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{"Grants creative flight to those wearing a MagLev Harness.", "Range is a cube centered on the pylon.", String.format("Unpowered Range: %s%d blocks", EnumChatFormatting.WHITE, MTEMagLevPylon.getPylonRange(aTier, false)), String.format("Powered Range: %s%d blocks", EnumChatFormatting.WHITE, MTEMagLevPylon.getPylonRange(aTier, true)), String.format("Cost: %s%d EU/t if tethered", EnumChatFormatting.WHITE, MTEMagLevPylon.getPylonPowerCost(aTier))}, new ITexture[0]);
        this.poweredRange = MTEMagLevPylon.getPylonRange(this.mTier, true);
        this.unpoweredRange = MTEMagLevPylon.getPylonRange(this.mTier, false);
        this.powerCost = MTEMagLevPylon.getPylonPowerCost(this.mTier);
        this.range = -1;
    }

    public MTEMagLevPylon(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
        this.poweredRange = MTEMagLevPylon.getPylonRange(this.mTier, true);
        this.unpoweredRange = MTEMagLevPylon.getPylonRange(this.mTier, false);
        this.powerCost = MTEMagLevPylon.getPylonPowerCost(this.mTier);
        this.range = -1;
    }

    @Override
    public void onPostTick(IGregTechTileEntity mte, long tick) {
        if (!mte.isServerSide()) {
            return;
        }
        if (mte.isAllowedToWork()) {
            boolean playerConnected = this.hasPlayerConnected();
            mte.setActive(playerConnected);
            int prevRange = this.range;
            if (mte.isUniversalEnergyStored(this.powerCost)) {
                this.range = this.poweredRange;
                if (playerConnected) {
                    mte.decreaseStoredEnergyUnits(this.powerCost, false);
                }
            } else {
                this.range = this.unpoweredRange;
            }
            if (prevRange != this.range) {
                GTMod.proxy.tetherManager.registerPylon(mte, this, this.range);
            }
        } else if (this.range != -1) {
            mte.setActive(false);
            GTMod.proxy.tetherManager.unregisterPylon(mte);
            this.range = -1;
        }
    }

    @Override
    public void onRemoval() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            GTMod.proxy.tetherManager.unregisterPylon(this.getBaseMetaTileEntity());
        }
    }

    @Override
    public void onUnload() {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            GTMod.proxy.tetherManager.unregisterPylon(this.getBaseMetaTileEntity());
        }
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMagLevPylon(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return true;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return true;
    }

    @Override
    public boolean isTeleporterCompatible() {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return 512L;
    }

    @Override
    public long maxEUStore() {
        return 512L + GTValues.V[this.mTier] * 50L;
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxAmperesIn() {
        return 2L;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
        }
        if (active) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_MAGLEV_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_MAGLEV_ACTIVE_GLOW).glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_MAGLEV)};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    private boolean hasPlayerConnected() {
        return this.playersConnected > 0;
    }

    public void connectPlayer() {
        ++this.playersConnected;
    }

    public void disconnectPlayer() {
        --this.playersConnected;
        this.playersConnected = Math.max(0, this.playersConnected);
    }

    private static int getPylonRange(int tier, boolean powered) {
        return (int)((powered ? 1.0 : 0.5) * (double)(tier - 1) * 16.0);
    }

    private static long getPylonPowerCost(int tier) {
        return GTValues.VP[tier];
    }
}

