/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render;

import gregtech.GTMod;
import gregtech.api.interfaces.ITexture;
import gregtech.api.render.ISBRContext;
import gregtech.common.render.GTTextureBase;

public class GTMultiTextureRender
extends GTTextureBase
implements ITexture {
    protected final ITexture[] mTextures;

    public static GTMultiTextureRender get(ITexture ... aTextures) {
        return GTMod.GT.isClientSide() ? new GTMultiTextureRender(aTextures) : null;
    }

    protected GTMultiTextureRender(ITexture ... aTextures) {
        this.mTextures = aTextures;
    }

    @Override
    public void renderXPos(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderXPos(ctx);
        }
    }

    @Override
    public void renderXNeg(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderXNeg(ctx);
        }
    }

    @Override
    public void renderYPos(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderYPos(ctx);
        }
    }

    @Override
    public void renderYNeg(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderYNeg(ctx);
        }
    }

    @Override
    public void renderZPos(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderZPos(ctx);
        }
    }

    @Override
    public void renderZNeg(ISBRContext ctx) {
        for (ITexture tTexture : this.mTextures) {
            if (tTexture == null || !tTexture.isValidTexture()) continue;
            tTexture.renderZNeg(ctx);
        }
    }

    @Override
    public boolean isValidTexture() {
        return true;
    }
}

