/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.Cover;
import gregtech.common.covers.gui.CoverFluidfilterGui;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.modes.BlockMode;
import gregtech.common.covers.modes.FilterDirectionMode;
import gregtech.common.covers.modes.FilterType;
import gregtech.common.gui.mui1.cover.FluidFilterUIFactory;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class CoverFluidfilter
extends Cover {
    private final int FILTER_INPUT_DENY_OUTPUT = 0;
    private final int INVERT_INPUT_DENY_OUTPUT = 1;
    private final int FILTER_INPUT_ANY_OUTPUT = 2;
    private final int INVERT_INPUT_ANY_OUTPUT = 3;
    private final int DENY_INPUT_FILTER_OUTPUT = 4;
    private final int DENY_INPUT_INVERT_OUTPUT = 5;
    private final int ANY_INPUT_FILTER_OUTPUT = 6;
    private final int ANY_INPUT_INVERT_OUTPUT = 7;
    private int mFluidID = -1;
    private int mFilterMode = 0;

    public CoverFluidfilter(CoverContext context, ITexture coverTexture) {
        super(context, coverTexture);
    }

    public int getFluidId() {
        return this.mFluidID;
    }

    public CoverFluidfilter setFluidId(int fluidId) {
        this.mFluidID = fluidId;
        return this;
    }

    public int getFilterMode() {
        return this.mFilterMode;
    }

    public CoverFluidfilter setFilterMode(int filterMode) {
        this.mFilterMode = filterMode;
        return this;
    }

    public FilterDirectionMode getFilterDirection() {
        return (this.getFilterMode() >> 2 & 1) == 0 ? FilterDirectionMode.INPUT : FilterDirectionMode.OUTPUT;
    }

    public void setFilterDirection(FilterDirectionMode ioMode) {
        FilterDirectionMode oldMode = this.getFilterDirection();
        if (ioMode == oldMode) {
            return;
        }
        int filterMode = this.getFilterMode();
        filterMode = ioMode == FilterDirectionMode.INPUT ? (filterMode &= 3) : (filterMode |= 4);
        this.setFilterMode(filterMode);
    }

    public FilterType getFilterType() {
        return (this.getFilterMode() & 1) == 0 ? FilterType.WHITELIST : FilterType.BLACKLIST;
    }

    public void setFilterType(FilterType filterType) {
        FilterType oldFilterType = this.getFilterType();
        if (filterType == oldFilterType) {
            return;
        }
        int filterMode = this.getFilterMode();
        filterMode = filterType == FilterType.WHITELIST ? (filterMode &= 6) : (filterMode |= 1);
        this.setFilterMode(filterMode);
    }

    public BlockMode getBlockMode() {
        return (this.getFilterMode() >> 1 & 1) == 0 ? BlockMode.BLOCK : BlockMode.ALLOW;
    }

    public void setBlockMode(BlockMode blockMode) {
        BlockMode oldBlockMode = this.getBlockMode();
        if (blockMode == oldBlockMode) {
            return;
        }
        int filterMode = this.getFilterMode();
        filterMode = blockMode == BlockMode.BLOCK ? (filterMode &= 5) : (filterMode |= 2);
        this.setFilterMode(filterMode);
    }

    @Override
    protected void readDataFromNbt(NBTBase nbt) {
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound tNBT = (NBTTagCompound)nbt;
            this.mFilterMode = tNBT.func_74762_e("mFilterMode");
            this.mFluidID = tNBT.func_150297_b("mFluid", 8) ? FluidRegistry.getFluidID((String)tNBT.func_74779_i("mFluid")) : -1;
        }
    }

    @Override
    public void readDataFromPacket(ByteArrayDataInput byteData) {
        this.mFilterMode = byteData.readByte();
        this.mFluidID = byteData.readInt();
    }

    @Override
    @NotNull
    protected NBTBase saveDataToNbt() {
        NBTTagCompound tNBT = new NBTTagCompound();
        tNBT.func_74768_a("mFilterMode", this.mFilterMode);
        if (this.mFluidID >= 0) {
            tNBT.func_74778_a("mFluid", FluidRegistry.getFluid((int)this.mFluidID).getName());
        }
        return tNBT;
    }

    @Override
    protected void writeDataToByteBuf(ByteBuf byteBuf) {
        byteBuf.writeByte(this.mFilterMode).writeInt(this.mFluidID);
    }

    @Override
    public String getDescription() {
        Fluid fluid = FluidRegistry.getFluid((int)this.mFluidID);
        if (fluid == null) {
            return "";
        }
        FluidStack sFluid = new FluidStack(fluid, 1000);
        return String.format("Filtering Fluid: %s - %s", sFluid.getLocalizedName(), this.getFilterMode(this.mFilterMode));
    }

    public String getFilterMode(int aFilterMode) {
        String string;
        switch (aFilterMode) {
            case 0: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.filter_i_deny_o");
                break;
            }
            case 1: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.invert_i_deny_o");
                break;
            }
            case 2: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.filter_i_any_o");
                break;
            }
            case 3: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.invert_i_any_o");
                break;
            }
            case 4: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.deny_i_filter_o");
                break;
            }
            case 5: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.deny_i_invert_o");
                break;
            }
            case 6: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.any_i_filter_o");
                break;
            }
            case 7: {
                string = StatCollector.func_74838_a((String)"gt.interact.desc.any_i_invert_o");
                break;
            }
            default: {
                string = "UNKNOWN";
            }
        }
        return string;
    }

    @Override
    public void onCoverScrewdriverClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.mFilterMode = (this.mFilterMode + (aPlayer.func_70093_af() ? -1 : 1)) % 8;
        if (this.mFilterMode < 0) {
            this.mFilterMode = 7;
        }
        GTUtility.sendChatToPlayer(aPlayer, this.getFilterMode(this.mFilterMode));
    }

    @Override
    public boolean onCoverRightClick(EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (this.coverSide == ForgeDirection.UNKNOWN) {
            return false;
        }
        if ((double)aX > 0.375 && (double)aX < 0.625 || this.coverSide.offsetX != 0 && (double)aY > 0.375 && (double)aY < 0.625 || (this.coverSide.flag & (ForgeDirection.UP.flag | ForgeDirection.DOWN.flag)) != 0 && (double)aZ > 0.375 && (double)aZ < 0.625 || this.coverSide.offsetZ != 0) {
            ItemStack tStack = aPlayer.field_71071_by.func_70448_g();
            if (tStack == null) {
                return true;
            }
            FluidStack tFluid = GTUtility.getFluidForFilledItem(tStack, true);
            if (tFluid != null) {
                int aFluid;
                this.mFluidID = aFluid = tFluid.getFluidID();
                FluidStack sFluid = new FluidStack(FluidRegistry.getFluid((int)aFluid), 1000);
                GTUtility.sendChatToPlayer(aPlayer, GTUtility.trans("047", "Filter Fluid: ") + sFluid.getLocalizedName());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return true;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = this.mFilterMode;
        int aFilterFluid = this.mFluidID;
        if (aFilterMode == 4 || aFilterMode == 5) {
            return false;
        }
        if (aFilterMode == 6 || aFilterMode == 7) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 0 || aFilterMode == 2;
        }
        return aFilterMode == 1 || aFilterMode == 3;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        if (aFluid == null) {
            return true;
        }
        int aFilterMode = this.mFilterMode;
        int aFilterFluid = this.mFluidID;
        if (aFilterMode == 0 || aFilterMode == 1) {
            return false;
        }
        if (aFilterMode == 2 || aFilterMode == 3) {
            return true;
        }
        if (aFluid.getID() == aFilterFluid) {
            return aFilterMode == 4 || aFilterMode == 6;
        }
        return aFilterMode == 5 || aFilterMode == 7;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverFluidfilterGui(this);
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new FluidFilterUIFactory(buildContext).createWindow();
    }
}

