/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipe.maps;

import gregtech.api.recipe.RecipeMapBackend;
import gregtech.api.recipe.RecipeMapBackendPropertiesBuilder;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTRecipeBuilder;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FuelBackend
extends RecipeMapBackend {
    private final Map<String, GTRecipe> recipesByFluidInput = new HashMap<String, GTRecipe>();

    public FuelBackend(RecipeMapBackendPropertiesBuilder propertiesBuilder) {
        super(propertiesBuilder);
    }

    @Override
    protected Collection<GTRecipe> doAdd(GTRecipeBuilder builder) {
        if (builder.getDuration() == -1) {
            builder.duration(0);
        }
        if (builder.getEUt() == -1) {
            builder.eut(0);
        }
        return super.doAdd(builder);
    }

    @Override
    public GTRecipe compileRecipe(GTRecipe recipe) {
        super.compileRecipe(recipe);
        if (recipe.mInputs != null && GTUtility.getNonnullElementCount(recipe.mInputs) == 1L && (recipe.mFluidInputs == null || GTUtility.getNonnullElementCount(recipe.mFluidInputs) == 0L)) {
            FluidStack fluidStack = GTUtility.getFluidForFilledItem(recipe.mInputs[0], true);
            if (fluidStack != null) {
                fluidStack.amount = 0;
                this.recipesByFluidInput.put(fluidStack.getFluid().getName(), recipe);
            }
        } else if ((recipe.mInputs == null || GTUtility.getNonnullElementCount(recipe.mInputs) == 0L) && recipe.mFluidInputs != null && GTUtility.getNonnullElementCount(recipe.mFluidInputs) >= 1L && recipe.mFluidInputs[0] != null) {
            this.recipesByFluidInput.put(recipe.mFluidInputs[0].getFluid().getName(), recipe);
        }
        return recipe;
    }

    @Nullable
    public GTRecipe findFuel(FluidStack fluidStack) {
        return this.findFuel(fluidStack.getFluid());
    }

    @Nullable
    public GTRecipe findFuel(Fluid fluid) {
        return this.recipesByFluidInput.get(fluid.getName());
    }
}

