/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import net.minecraft.network.INetHandler;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.Validate;

public abstract class GTPacket {
    public abstract byte getPacketID();

    public abstract void encode(ByteBuf var1);

    public abstract GTPacket decode(ByteArrayDataInput var1);

    public abstract void process(IBlockAccess var1);

    public void setINetHandler(INetHandler handler) {
    }

    public static int readVarInt(ByteArrayDataInput buf, int maxSize) {
        byte b0;
        Validate.isTrue((maxSize < 6 && maxSize > 0 ? 1 : 0) != 0, (String)"Varint length is between 1 and 5, not %d", (long)maxSize);
        int i = 0;
        int j = 0;
        do {
            b0 = buf.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= maxSize) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static int readVarShort(ByteArrayDataInput buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static String readUTF8String(ByteArrayDataInput from) {
        byte[] utf8Bytes = new byte[GTPacket.readVarInt(from, 2)];
        from.readFully(utf8Bytes);
        return new String(utf8Bytes, StandardCharsets.UTF_8);
    }
}

