/*
 * Decompiled with CFR 0.152.
 */
package bartworks.common.items;

import bartworks.API.modularUI.BWUITextures;
import bartworks.MainMod;
import bartworks.util.BWUtil;
import com.gtnewhorizons.modularui.api.ModularUITextures;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.forge.ItemStackHandler;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.screen.IItemWithModularUI;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.SlotWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.gui.modularui.GTUIInfos;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.items.GTGenericItem;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCircuitProgrammer
extends GTGenericItem
implements IElectricItem,
IItemWithModularUI {
    private static final int COST_PER_USE = 100;
    private static final String NBT_KEY_HAS_CHIP = "HasChip";
    private static final String NBT_KEY_CHIP_CONFIG = "ChipConfig";

    public ItemCircuitProgrammer() {
        super("BWCircuitProgrammer", "Circuit Programmer", "Programs Integrated Circuits");
        this.func_77625_d(1);
        this.setNoRepair();
        this.func_77627_a(false);
        this.func_77637_a(MainMod.BWT);
    }

    public void useItem(ItemStack stack, EntityPlayer player) {
        ElectricItem.manager.use(stack, 100.0, (EntityLivingBase)player);
    }

    @Override
    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        super.func_77624_a(aStack, aPlayer, aList, aF3_H);
        if (aStack != null && aStack.func_77978_p() != null) {
            aList.add(StatCollector.func_74838_a((String)"tooltip.cp.0.name") + " " + (aStack.func_77978_p().func_74767_n(NBT_KEY_HAS_CHIP) ? StatCollector.func_74838_a((String)"tooltip.bw.yes.name") : StatCollector.func_74838_a((String)"tooltip.bw.no.name")));
        }
    }

    public ItemStack func_77659_a(ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (ElectricItem.manager.use(aStack, 100.0, (EntityLivingBase)aPlayer)) {
            GTUIInfos.openPlayerHeldItemUI(aPlayer);
        }
        return aStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List<ItemStack> itemList) {
        ItemStack itemStack = new ItemStack((Item)this, 1);
        if (this.getChargedItem(itemStack) == this) {
            ItemStack charged = new ItemStack((Item)this, 1);
            ElectricItem.manager.charge(charged, 2.147483647E9, Integer.MAX_VALUE, true, false);
            itemList.add(charged);
        }
        if (this.getEmptyItem(itemStack) == this) {
            itemList.add(new ItemStack((Item)this, 1, this.func_77612_l()));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister aIconRegister) {
        this.mIcon = aIconRegister.func_94245_a("bartworks:CircuitProgrammer");
    }

    @Override
    public int getTier(ItemStack var1) {
        return 1;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public double getMaxCharge(ItemStack itemStack) {
        return 10000.0;
    }

    public double getTransferLimit(ItemStack itemStack) {
        return GTValues.V[1];
    }

    public ModularWindow createWindow(UIBuildContext buildContext, ItemStack heldStack) {
        ModularWindow.Builder builder = ModularWindow.builder((int)256, (int)166);
        builder.setBackground(new IDrawable[]{BWUITextures.BACKGROUND_CIRCUIT_PROGRAMMER});
        builder.bindPlayerInventory(buildContext.getPlayer(), new Pos2d(86, 83), (IDrawable)ModularUITextures.ITEM_SLOT);
        ItemStackHandler inventoryHandler = new ItemStackHandler(1){

            public int getSlotLimit(int slot) {
                return 1;
            }
        };
        SlotWidget circuitSlotWidget = new SlotWidget(new BaseSlot((IItemHandlerModifiable)inventoryHandler, 0){

            public void func_75215_d(ItemStack stack) {
                if (ItemCircuitProgrammer.this.isLVCircuit(stack)) {
                    stack = ItemCircuitProgrammer.this.createRealCircuit(0);
                }
                ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.getSlotIndex(), stack);
                this.func_75218_e();
            }
        });
        ItemStack initialStack = null;
        NBTTagCompound tag = heldStack.func_77978_p();
        if (tag != null && tag.func_74767_n(NBT_KEY_HAS_CHIP)) {
            initialStack = this.createRealCircuit(tag.func_74771_c(NBT_KEY_CHIP_CONFIG));
        }
        circuitSlotWidget.getMcSlot().func_75215_d(initialStack);
        builder.widget(circuitSlotWidget.setChangeListener(widget -> {
            ItemStack stack = widget.getMcSlot().func_75211_c();
            ItemStack heldItem = widget.getContext().getPlayer().func_70694_bm();
            NBTTagCompound tag2 = heldItem.func_77978_p();
            if (tag2 == null) {
                tag2 = new NBTTagCompound();
            }
            if (stack != null) {
                tag2.func_74757_a(NBT_KEY_HAS_CHIP, true);
                tag2.func_74774_a(NBT_KEY_CHIP_CONFIG, (byte)stack.func_77960_j());
            } else {
                tag2.func_74757_a(NBT_KEY_HAS_CHIP, false);
            }
            heldItem.func_77982_d(tag2);
        }).setFilter(stack -> this.isProgrammedCircuit((ItemStack)stack) || this.isLVCircuit((ItemStack)stack)).setBackground(new IDrawable[]{ModularUITextures.ITEM_SLOT, GTUITextures.OVERLAY_SLOT_INT_CIRCUIT}).setPos(122, 60));
        for (int i = 0; i < 24; ++i) {
            int index = i;
            builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> {
                if (circuitSlotWidget.getMcSlot().func_75216_d() && this.isProgrammedCircuit(circuitSlotWidget.getMcSlot().func_75211_c())) {
                    circuitSlotWidget.getMcSlot().func_75215_d(this.createRealCircuit(index + 1));
                }
            }).setPos(32 + i % 12 * 18, 21 + i / 12 * 18).setSize(18, 18));
        }
        return builder.build();
    }

    private ItemStack createRealCircuit(int config) {
        return ItemList.Circuit_Integrated.getWithDamage(1L, config, new Object[0]);
    }

    private boolean isProgrammedCircuit(ItemStack stack) {
        return stack.func_77973_b().equals(GTUtility.getIntegratedCircuit(0).func_77973_b());
    }

    private boolean isLVCircuit(ItemStack stack) {
        return BWUtil.checkStackAndPrefix(stack) && OrePrefixes.circuit.equals((Object)GTOreDictUnificator.getAssociation((ItemStack)stack).mPrefix) && GTOreDictUnificator.getAssociation((ItemStack)stack).mMaterial.mMaterial.equals(Materials.LV);
    }
}

