/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.Position;
import buildcraft.api.power.IEngine;
import buildcraft.api.power.ILaserTarget;
import buildcraft.api.tiles.ITileAreaProvider;
import buildcraft.api.transport.IInjectable;
import buildcraft.api.transport.IPipeTile;
import buildcraft.core.CompatHooks;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.internal.IFramePipeConnection;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.engines.BlockEngineBase;
import buildcraft.core.lib.inventory.ITransactor;
import buildcraft.core.lib.inventory.InvUtils;
import buildcraft.core.lib.inventory.Transactor;
import buildcraft.core.lib.network.Packet;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.XorShift128Random;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;

public final class Utils {
    public static final boolean CAULDRON_DETECTED;
    public static final XorShift128Random RANDOM;
    private static final List<ForgeDirection> directions;

    private Utils() {
    }

    public static boolean isRegistered(Block block) {
        return block != null && Block.func_149682_b((Block)block) >= 0;
    }

    public static boolean isRegistered(Item item) {
        return item != null && Item.func_150891_b((Item)item) >= 0;
    }

    public static boolean isRegistered(ItemStack stack) {
        Block block;
        if (stack == null) {
            return false;
        }
        if (stack.func_77973_b() != null && (block = Block.func_149634_a((Item)stack.func_77973_b())) instanceof BlockEngineBase) {
            return Utils.isRegistered(block) && ((BlockEngineBase)block).hasEngine(stack.func_77960_j());
        }
        return Utils.isRegistered(stack.func_77973_b());
    }

    public static int addToRandomInventoryAround(World world, int x, int y, int z, ItemStack stack) {
        Collections.shuffle(directions);
        for (ForgeDirection orientation : directions) {
            Position pos = new Position(x, y, z, orientation);
            pos.moveForwards(1.0);
            TileEntity tileInventory = BlockUtils.getTileEntity(world, (int)pos.x, (int)pos.y, (int)pos.z);
            ITransactor transactor = Transactor.getTransactorFor(tileInventory);
            if (transactor == null || tileInventory instanceof IEngine || tileInventory instanceof ILaserTarget || transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)false).field_77994_a <= 0) continue;
            return transactor.add((ItemStack)stack, (ForgeDirection)orientation.getOpposite(), (boolean)true).field_77994_a;
        }
        return 0;
    }

    public static ForgeDirection get2dOrientation(EntityLivingBase entityliving) {
        ForgeDirection[] orientationTable = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
        int orientationIndex = MathHelper.func_76128_c((double)(((double)entityliving.field_70177_z + 45.0) / 90.0)) & 3;
        return orientationTable[orientationIndex];
    }

    public static int addToRandomInjectableAround(World world, int x, int y, int z, ForgeDirection from, ItemStack stack) {
        ArrayList<IInjectable> possiblePipes = new ArrayList<IInjectable>();
        ArrayList<ForgeDirection> pipeDirections = new ArrayList<ForgeDirection>();
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (from.getOpposite() == side) continue;
            Position pos = new Position(x, y, z, side);
            pos.moveForwards(1.0);
            TileEntity tile = BlockUtils.getTileEntity(world, (int)pos.x, (int)pos.y, (int)pos.z);
            if (tile instanceof IInjectable) {
                if (!((IInjectable)tile).canInjectItems(side.getOpposite())) continue;
                possiblePipes.add((IInjectable)tile);
                pipeDirections.add(side.getOpposite());
                continue;
            }
            IInjectable wrapper = CompatHooks.INSTANCE.getInjectableWrapper(tile, side);
            if (wrapper == null) continue;
            possiblePipes.add(wrapper);
            pipeDirections.add(side.getOpposite());
        }
        if (possiblePipes.size() > 0) {
            int choice = RANDOM.nextInt(possiblePipes.size());
            IInjectable pipeEntry = (IInjectable)possiblePipes.get(choice);
            return pipeEntry.injectItem(stack, true, (ForgeDirection)pipeDirections.get(choice), null);
        }
        return 0;
    }

    public static void dropTryIntoPlayerInventory(World world, int x, int y, int z, ItemStack stack, EntityPlayer player) {
        if (player != null && player.field_71071_by.func_70441_a(stack) && player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        InvUtils.dropItems(world, stack, x, y, z);
    }

    public static IAreaProvider getNearbyAreaProvider(World world, int i, int j, int k) {
        for (TileEntity t : world.field_147482_g) {
            if (!(t instanceof ITileAreaProvider) || !((ITileAreaProvider)t).isValidFromLocation(i, j, k)) continue;
            return (IAreaProvider)t;
        }
        return null;
    }

    public static void preDestroyBlock(World world, int i, int j, int k) {
        TileEntity tile = BlockUtils.getTileEntity(world, i, j, k);
        if (tile instanceof IInventory && !world.field_72995_K && (!(tile instanceof IDropControlInventory) || ((IDropControlInventory)tile).doDrop())) {
            InvUtils.dropItems(world, (IInventory)tile, i, j, k);
            InvUtils.wipeInventory((IInventory)tile);
        }
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).destroy();
        }
    }

    public static boolean isFakePlayer(EntityPlayer player) {
        if (player instanceof FakePlayer) {
            return true;
        }
        return !player.field_70175_ag;
    }

    public static boolean checkPipesConnections(TileEntity tile1, TileEntity tile2) {
        if (tile1 == null || tile2 == null) {
            return false;
        }
        if (!(tile1 instanceof IPipeTile) && !(tile2 instanceof IPipeTile)) {
            return false;
        }
        ForgeDirection o = ForgeDirection.UNKNOWN;
        if (tile1.field_145851_c - 1 == tile2.field_145851_c) {
            o = ForgeDirection.WEST;
        } else if (tile1.field_145851_c + 1 == tile2.field_145851_c) {
            o = ForgeDirection.EAST;
        } else if (tile1.field_145848_d - 1 == tile2.field_145848_d) {
            o = ForgeDirection.DOWN;
        } else if (tile1.field_145848_d + 1 == tile2.field_145848_d) {
            o = ForgeDirection.UP;
        } else if (tile1.field_145849_e - 1 == tile2.field_145849_e) {
            o = ForgeDirection.NORTH;
        } else if (tile1.field_145849_e + 1 == tile2.field_145849_e) {
            o = ForgeDirection.SOUTH;
        }
        if (tile1 instanceof IPipeTile && !((IPipeTile)tile1).isPipeConnected(o)) {
            return false;
        }
        return !(tile2 instanceof IPipeTile) || ((IPipeTile)tile2).isPipeConnected(o.getOpposite());
    }

    public static boolean checkLegacyPipesConnections(IBlockAccess blockAccess, int x1, int y1, int z1, int x2, int y2, int z2) {
        Block b1 = blockAccess.func_147439_a(x1, y1, z1);
        Block b2 = blockAccess.func_147439_a(x2, y2, z2);
        if (!(b1 instanceof IFramePipeConnection) && !(b2 instanceof IFramePipeConnection)) {
            return false;
        }
        if (b1 instanceof IFramePipeConnection && !((IFramePipeConnection)b1).isPipeConnected(blockAccess, x1, y1, z1, x2, y2, z2)) {
            return false;
        }
        return !(b2 instanceof IFramePipeConnection) || ((IFramePipeConnection)b2).isPipeConnected(blockAccess, x2, y2, z2, x1, y1, z1);
    }

    public static boolean isPipeConnected(IBlockAccess access, int x, int y, int z, ForgeDirection dir, IPipeTile.PipeType type) {
        TileEntity tile = access.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        return tile instanceof IPipeTile && ((IPipeTile)tile).getPipeType() == type && ((IPipeTile)tile).isPipeConnected(dir.getOpposite());
    }

    public static int[] createSlotArray(int first, int count) {
        int[] slots = new int[count];
        for (int k = first; k < first + count; ++k) {
            slots[k - first] = k;
        }
        return slots;
    }

    public static FMLProxyPacket toPacket(Packet packet, int discriminator) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeByte((int)((byte)discriminator));
        packet.writeData(buf);
        return new FMLProxyPacket(buf, "BC-CORE");
    }

    static {
        RANDOM = new XorShift128Random();
        directions = new ArrayList<ForgeDirection>(Arrays.asList(ForgeDirection.VALID_DIRECTIONS));
        boolean cauldron = false;
        try {
            cauldron = Utils.class.getClassLoader().loadClass("org.spigotmc.SpigotConfig") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        CAULDRON_DETECTED = cauldron;
    }
}

