/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import serverutils.invsee.GuiInvseeContainer;
import serverutils.invsee.inventories.InvSeeInventories;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.StringUtils;
import serverutils.net.ServerUtilitiesNetHandler;

public class MessageInvseeContainer
extends MessageToClient {
    private String playerName;
    private String playerUUID;
    private Object2IntMap<InvSeeInventories> inventoriesWithSize;
    private int windowId;

    public MessageInvseeContainer() {
    }

    public MessageInvseeContainer(ForgePlayer player, Map<InvSeeInventories, IInventory> foundInventories, int windowId) {
        this.playerName = player.getName();
        this.playerUUID = StringUtils.fromUUID(player.getProfile().getId());
        this.windowId = windowId;
        this.inventoriesWithSize = new Object2IntLinkedOpenHashMap(foundInventories.size());
        for (Map.Entry<InvSeeInventories, IInventory> entry : foundInventories.entrySet()) {
            this.inventoriesWithSize.put((Object)entry.getKey(), entry.getValue().func_70302_i_());
        }
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.GENERAL;
    }

    @Override
    public void writeData(DataOut data) {
        data.writeVarInt(this.windowId);
        data.writeString(this.playerName);
        data.writeString(this.playerUUID);
        data.writeVarInt(this.inventoriesWithSize.size());
        for (Object2IntMap.Entry entry : this.inventoriesWithSize.object2IntEntrySet()) {
            data.writeVarInt(((InvSeeInventories)((Object)entry.getKey())).ordinal());
            data.writeVarInt(entry.getIntValue());
        }
    }

    @Override
    public void readData(DataIn data) {
        this.windowId = data.readVarInt();
        this.playerName = data.readString();
        this.playerUUID = data.readString();
        int size = data.readVarInt();
        this.inventoriesWithSize = new Object2IntLinkedOpenHashMap(size);
        for (int i = 0; i < size; ++i) {
            InvSeeInventories inv = InvSeeInventories.VALUES[data.readVarInt()];
            this.inventoriesWithSize.put((Object)inv, data.readVarInt());
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onMessage() {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        LinkedHashMap<InvSeeInventories, IInventory> inventories = new LinkedHashMap<InvSeeInventories, IInventory>();
        for (Object2IntMap.Entry entry : this.inventoriesWithSize.object2IntEntrySet()) {
            InvSeeInventories inv = (InvSeeInventories)((Object)entry.getKey());
            IInventory inventory = inv.getInventory().createInventory((EntityPlayer)player, entry.getIntValue());
            inventories.put(inv, inventory);
        }
        new GuiInvseeContainer(inventories, this.playerName, this.playerUUID).openGui();
        player.field_71070_bA.field_75152_c = this.windowId;
    }
}

