/*
 * Decompiled with CFR 0.152.
 */
package serverutils.integration.navigator;

import com.gtnewhorizons.navigator.api.model.locations.IWaypointAndLocationProvider;
import com.gtnewhorizons.navigator.api.model.steps.UniversalInteractableStep;
import java.util.List;
import serverutils.integration.navigator.ClaimsLocation;
import serverutils.integration.navigator.NavigatorIntegration;
import serverutils.lib.icon.Color4I;

public class ClaimsRenderStep
extends UniversalInteractableStep<ClaimsLocation> {
    public ClaimsRenderStep(ClaimsLocation location) {
        super((IWaypointAndLocationProvider)location);
    }

    public void draw(double x, double y, float drawScale, double zoom) {
        Color4I teamColor = ((ClaimsLocation)this.location).getTeamColor().getColor().withAlpha(135);
        if (!((ClaimsLocation)this.location).isLoaded()) {
            teamColor.addBrightness(-0.3f).drawD(x, y, this.getAdjustedWidth(), this.getAdjustedHeight());
        } else {
            teamColor.drawD(x, y, this.getAdjustedWidth(), this.getAdjustedHeight());
        }
    }

    public void getTooltip(List<String> list) {
        list.add(((ClaimsLocation)this.location).getTeamName());
        if (!((ClaimsLocation)this.location).teamHint().isEmpty()) {
            list.add(((ClaimsLocation)this.location).teamHint());
        }
        if (!((ClaimsLocation)this.location).loadedHint().isEmpty()) {
            list.add(((ClaimsLocation)this.location).loadedHint());
        }
        if (((ClaimsLocation)this.location).isOwnTeam()) {
            list.add(((ClaimsLocation)this.location).claimHint());
            list.add(((ClaimsLocation)this.location).toggleLoadHint());
            list.add(((ClaimsLocation)this.location).unclaimHint());
        }
    }

    public void onActionKeyPressed() {
        NavigatorIntegration.unclaimChunk((ClaimsLocation)this.location);
    }
}

