/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import serverutils.ServerUtilities;
import serverutils.data.ClaimedChunk;
import serverutils.data.ClaimedChunks;
import serverutils.lib.EnumMessageLocation;
import serverutils.lib.data.ForgeTeam;
import serverutils.lib.math.ChunkDimPos;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;

public enum ServerUtilitiesNotifications {
    CHUNK_MODIFIED("chunk_modified", EnumMessageLocation.ACTION_BAR),
    CHUNK_CHANGED("chunk_changed", EnumMessageLocation.ACTION_BAR),
    CANT_MODIFY_CHUNK("cant_modify_chunk", EnumMessageLocation.ACTION_BAR),
    TELEPORT("teleport", EnumMessageLocation.ACTION_BAR),
    TELEPORT_WARMUP("teleport_warmup", EnumMessageLocation.ACTION_BAR),
    BACKUP("backup", EnumMessageLocation.ACTION_BAR),
    CONFIG_CHANGED("config_changed", EnumMessageLocation.ACTION_BAR),
    RESTART_TIMER("restart_timer", EnumMessageLocation.ACTION_BAR),
    CLEANUP("cleanup", EnumMessageLocation.ACTION_BAR),
    PLAYER_AFK("player_afk", EnumMessageLocation.CHAT);

    public static final ServerUtilitiesNotifications[] VALUES;
    private final String id;
    private final String desc;
    private EnumMessageLocation location;

    private ServerUtilitiesNotifications(String id, EnumMessageLocation defaultLocation) {
        this.id = id;
        this.desc = StatCollector.func_74838_a((String)("serverutilities.notifications." + id + ".desc"));
        this.location = defaultLocation;
    }

    public Notification createNotification(IChatComponent component) {
        return Notification.of(this.id, component);
    }

    public Notification createNotification(String key, Object ... args) {
        return this.createNotification(ServerUtilities.lang(key, args));
    }

    public void send(EntityPlayer player, String key, Object ... args) {
        this.createNotification(key, args).send(player);
    }

    public void send(EntityPlayer player, IChatComponent component) {
        this.createNotification(component).send(player);
    }

    public void sendAll(String key, Object ... args) {
        this.createNotification(key, args).sendToAll();
    }

    public void sendAll(IChatComponent component) {
        this.createNotification(component).sendToAll();
    }

    public static void updateChunkMessage(EntityPlayerMP player, ChunkDimPos pos) {
        short teamID;
        if (!ClaimedChunks.isActive()) {
            return;
        }
        ClaimedChunk chunk = ClaimedChunks.instance.getChunk(pos);
        ForgeTeam team = chunk == null ? null : chunk.getTeam();
        short s = teamID = team == null ? (short)0 : team.getUID();
        if (player.getEntityData().func_74765_d("serveru_lchunk") != teamID) {
            if (teamID == 0) {
                player.getEntityData().func_82580_o("serveru_lchunk");
            } else {
                player.getEntityData().func_74777_a("serveru_lchunk", teamID);
            }
            if (team != null) {
                Notification notification = CHUNK_CHANGED.createNotification(team.getTitle());
                if (!team.getDesc().isEmpty()) {
                    notification.addLine(StringUtils.italic((IChatComponent)new ChatComponentText(team.getDesc()), true));
                }
                notification.send((EntityPlayer)player);
            } else {
                CHUNK_CHANGED.send((EntityPlayer)player, StringUtils.color("serverutilities.lang.chunks.wilderness", EnumChatFormatting.DARK_GREEN, new Object[0]));
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setLocation(EnumMessageLocation enabled) {
        this.location = enabled;
    }

    public EnumMessageLocation getLocation() {
        return this.location;
    }

    @Nullable
    public static ServerUtilitiesNotifications getFromId(ResourceLocation id) {
        for (ServerUtilitiesNotifications n : VALUES) {
            if (!n.id.equalsIgnoreCase(id.func_110623_a())) continue;
            return n;
        }
        return null;
    }

    static {
        VALUES = ServerUtilitiesNotifications.values();
    }
}

