/*
 * Decompiled with CFR 0.152.
 */
package glowredman.amazingtrophies.model.complex;

import com.gtnewhorizon.gtnhlib.util.data.BlockMeta;
import glowredman.amazingtrophies.model.complex.RenderFacesInfo;
import it.unimi.dsi.fastutil.chars.Char2ObjectMap;
import it.unimi.dsi.fastutil.chars.Char2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.chars.CharOpenHashSet;
import it.unimi.dsi.fastutil.chars.CharSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;

public class BaseModelStructure {
    protected Object vertexBuffer;
    protected RenderFacesInfo[][][] renderFacesArray;
    protected Char2ObjectMap<BlockMeta> charToBlock = new Char2ObjectOpenHashMap();
    protected CharSet skipHalfOffset = new CharOpenHashSet();

    protected final int getXLength() {
        return this.getStructureString().length;
    }

    protected final int getYLength() {
        return this.getStructureString()[0][0].length();
    }

    protected final int getZLength() {
        return this.getStructureString()[0].length;
    }

    protected String[][] getStructureString() {
        return null;
    }

    protected final float maxAxisSize() {
        return Math.max(this.getXLength(), Math.max(this.getYLength(), this.getZLength()));
    }

    protected final BlockMeta getAssociatedBlockInfo(char letter) {
        return (BlockMeta)this.charToBlock.get(letter);
    }

    protected static void reverseInnerArrays(String[][] array) {
        for (Object[] objectArray : array) {
            ArrayUtils.reverse((Object[])objectArray);
        }
    }

    protected static String[][] transpose(String[][] array) {
        String[][] newArray = new String[array[0].length][array.length];
        for (int i = 0; i < array.length; ++i) {
            for (int j = 0; j < array[i].length; ++j) {
                newArray[j][i] = array[i][j];
            }
        }
        return newArray;
    }

    private static String[][] deepCopy(String[][] original) {
        if (original == null) {
            return null;
        }
        String[][] result = new String[original.length][];
        for (int i = 0; i < original.length; ++i) {
            result[i] = Arrays.copyOf(original[i], original[i].length);
        }
        return result;
    }

    protected void processStructureMap() {
        String[][] structureCopy = BaseModelStructure.deepCopy(this.getStructureString());
        CharSet transparentBlocks = this.getTransparentBlocks();
        this.removeTransparentBlocks(structureCopy, transparentBlocks);
        this.generateRenderFacesInfo(structureCopy);
    }

    private void generateRenderFacesInfo(String[][] structureCopy) {
        this.renderFacesArray = new RenderFacesInfo[this.getXLength()][this.getZLength()][this.getYLength()];
        for (int x = 0; x < this.getXLength(); ++x) {
            for (int y = 0; y < this.getYLength(); ++y) {
                for (int z = 0; z < this.getZLength(); ++z) {
                    RenderFacesInfo renderFacesInfo = new RenderFacesInfo(true);
                    int yNegBlock = 32;
                    if (z != 0) {
                        yNegBlock = structureCopy[x][z - 1].charAt(y);
                    }
                    if (yNegBlock != 32) {
                        renderFacesInfo.setYNeg(false);
                    }
                    int yPosBlock = 32;
                    if (z != this.getZLength() - 1) {
                        yPosBlock = structureCopy[x][z + 1].charAt(y);
                    }
                    if (yPosBlock != 32) {
                        renderFacesInfo.setYPos(false);
                    }
                    int xNegBlock = 32;
                    if (y != 0) {
                        xNegBlock = structureCopy[x][z].charAt(y - 1);
                    }
                    if (xNegBlock != 32) {
                        renderFacesInfo.setZNeg(false);
                    }
                    int xPosBlock = 32;
                    if (y != this.getYLength() - 1) {
                        xPosBlock = structureCopy[x][z].charAt(y + 1);
                    }
                    if (xPosBlock != 32) {
                        renderFacesInfo.setZPos(false);
                    }
                    int zNegBlock = 32;
                    if (x != 0) {
                        zNegBlock = structureCopy[x - 1][z].charAt(y);
                    }
                    if (zNegBlock != 32) {
                        renderFacesInfo.setXNeg(false);
                    }
                    int zPosBlock = 32;
                    if (x != this.getXLength() - 1) {
                        zPosBlock = structureCopy[x + 1][z].charAt(y);
                    }
                    if (zPosBlock != 32) {
                        renderFacesInfo.setXPos(false);
                    }
                    this.renderFacesArray[x][z][y] = renderFacesInfo;
                }
            }
        }
    }

    private void removeTransparentBlocks(String[][] structure, CharSet transparentBlocks) {
        if (structure == null || transparentBlocks == null) {
            return;
        }
        for (int i = 0; i < structure.length; ++i) {
            for (int j = 0; j < structure[i].length; ++j) {
                StringBuilder newStr = new StringBuilder();
                for (char c : structure[i][j].toCharArray()) {
                    if (!transparentBlocks.contains(c)) {
                        newStr.append(c);
                        continue;
                    }
                    newStr.append(' ');
                }
                structure[i][j] = newStr.toString();
            }
        }
    }

    private CharSet getTransparentBlocks() {
        CharOpenHashSet transparentBlocks = new CharOpenHashSet();
        ObjectSet entrySet = this.charToBlock.char2ObjectEntrySet();
        if (entrySet instanceof Char2ObjectMap.FastEntrySet) {
            ((Char2ObjectMap.FastEntrySet)entrySet).fastForEach(arg_0 -> BaseModelStructure.lambda$getTransparentBlocks$0((CharSet)transparentBlocks, arg_0));
        } else {
            entrySet.forEach(arg_0 -> BaseModelStructure.lambda$getTransparentBlocks$1((CharSet)transparentBlocks, arg_0));
        }
        return transparentBlocks;
    }

    private static void addTransparentBlock(CharSet transparentBlocks, Char2ObjectMap.Entry<BlockMeta> entry) {
        if (!((BlockMeta)entry.getValue()).getBlock().func_149662_c()) {
            transparentBlocks.add(entry.getCharKey());
        }
    }

    private static /* synthetic */ void lambda$getTransparentBlocks$1(CharSet transparentBlocks, Char2ObjectMap.Entry entry) {
        BaseModelStructure.addTransparentBlock(transparentBlocks, (Char2ObjectMap.Entry<BlockMeta>)entry);
    }

    private static /* synthetic */ void lambda$getTransparentBlocks$0(CharSet transparentBlocks, Char2ObjectMap.Entry entry) {
        BaseModelStructure.addTransparentBlock(transparentBlocks, (Char2ObjectMap.Entry<BlockMeta>)entry);
    }
}

