/*
 * Decompiled with CFR 0.152.
 */
package glowredman.defaultserverlist;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import glowredman.defaultserverlist.LoadingPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;

public class Config {
    public static final List<ServerData> SERVERS = new ArrayList<ServerData>();
    public static boolean allowModifications;
    private static Configuration config;

    public static void init(File configDir) {
        File configFile = new File(configDir, "defaultserverlist.cfg");
        Path legacyConfigPath = configDir.toPath().resolve("defaultserverlist.json");
        boolean migrate = !configFile.exists() && Files.exists(legacyConfigPath, new LinkOption[0]);
        Gson gson = new Gson();
        config = new Configuration(configFile);
        if (migrate) {
            LoadingPlugin.LOGGER.info("Found legacy config, attempting to migrate...");
            try (BufferedReader fileReader = Files.newBufferedReader(legacyConfigPath);){
                ConfigObj legacyConfig = (ConfigObj)gson.fromJson((Reader)fileReader, ConfigObj.class);
                config.get("general", "useURL", false).set(legacyConfig.useURL);
                config.get("general", "allowModifications", true).set(legacyConfig.allowModifications);
                config.get("general", "url", "").set(legacyConfig.url);
                config.get("general", "servers", new String[0]).set(Config.toArray(legacyConfig.servers));
                config.get("general", "prevDefaultServers", new String[0]).set(legacyConfig.prevDefaultServers.toArray(new String[0]));
                Files.delete(legacyConfigPath);
                LoadingPlugin.LOGGER.info("Migration successful!");
            }
            catch (Exception e) {
                LoadingPlugin.LOGGER.error("Migration failed!", (Throwable)e);
            }
        }
        boolean useURL = config.getBoolean("useURL", "general", false, "Whether or not the default servers should be fetched from a remote location.");
        allowModifications = config.getBoolean("allowModifications", "general", true, "Whether or not the user should be able to delete, modify or change the order of the default servers.");
        String url = config.getString("url", "general", "", "The remote location to fetch the default servers from. The returned content must be in JSON format (formatted as a map where the keys are the server names and the values the corresponding ip-adresses).");
        Map servers = Config.toMap(config.getStringList("servers", "general", new String[0], "The default servers. Format: ip|name"));
        String[] prevDefaultServersArray = config.getStringList("prevDefaultServers", "general", new String[0], "DO NOT EDIT!");
        Collection<Object> prevDefaultServers = new ArrayList(prevDefaultServersArray.length);
        Arrays.stream(prevDefaultServersArray).forEachOrdered(prevDefaultServers::add);
        if (useURL) {
            try {
                Map remoteDefaultServers = (Map)gson.fromJson(IOUtils.toString((URL)new URL(url), (Charset)StandardCharsets.UTF_8), new TypeToken<LinkedHashMap<String, String>>(){
                    private static final long serialVersionUID = -1786059589535074931L;
                }.getType());
                if (allowModifications) {
                    LinkedHashMap<String, String> diff = new LinkedHashMap<String, String>();
                    for (Map.Entry entry : remoteDefaultServers.entrySet()) {
                        String ip2 = (String)entry.getValue();
                        if (prevDefaultServers.contains(ip2)) continue;
                        diff.put((String)entry.getKey(), ip2);
                    }
                    if (!diff.isEmpty()) {
                        servers.putAll(diff);
                        prevDefaultServers = remoteDefaultServers.values();
                        Config.setStringList("servers", Config.toArray(servers));
                        Config.setStringList("prevDefaultServers", prevDefaultServers.toArray(new String[0]));
                    }
                } else {
                    servers = remoteDefaultServers;
                    Config.setStringList("servers", Config.toArray(servers));
                }
            }
            catch (Exception e) {
                LoadingPlugin.LOGGER.error("Could not get default server list from {}! Are you connected to the internet?", new Object[]{url, e});
            }
        }
        if (config.hasChanged()) {
            config.save();
        }
        servers.forEach((name, ip) -> SERVERS.add(new ServerData(name, ip)));
    }

    private static String[] toArray(Map<String, String> map) {
        String[] array = new String[map.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            array[i] = entry.getValue() + '|' + entry.getKey();
            ++i;
        }
        return array;
    }

    private static Map<String, String> toMap(String[] array) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(array.length);
        for (String entry : array) {
            String[] parts = entry.split("\\|", 2);
            if (parts.length < 2) {
                LoadingPlugin.LOGGER.warn("Could not parse entry {} because not '|' was found!", new Object[]{entry});
                continue;
            }
            map.put(parts[1], parts[0]);
        }
        return map;
    }

    public static void saveServers(String[] servers) {
        Config.setStringList("servers", servers);
        config.save();
    }

    private static void setStringList(String key, String[] values) {
        config.getCategory("general").get(key).set(values);
    }

    @Deprecated
    public static final class ConfigObj {
        public boolean useURL = false;
        public boolean allowModifications = true;
        public String url = "";
        public Map<String, String> servers = new LinkedHashMap<String, String>();
        @SerializedName(value="DO_NOT_EDIT_prevDefaultServers")
        public Collection<String> prevDefaultServers = new ArrayList<String>();
    }
}

