/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.entities;

import appeng.api.config.Actionable;
import java.util.HashSet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IEssentiaTransport;
import thaumcraft.common.entities.golems.EntityGolemBase;
import thaumcraft.common.entities.golems.Marker;
import thaumcraft.common.tiles.TileAlembic;
import thaumcraft.common.tiles.TileJarFillable;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumicenergistics.common.entities.AIAENetworkGolem;
import thaumicenergistics.common.entities.WirelessGolemHandler;

public class AIGolemWifiEssentia
extends AIAENetworkGolem {
    private final HashSet<TileJarFillable> checkedJars = new HashSet();
    private TileJarFillable targetJar = null;
    private double targetDistance = 0.0;
    private boolean targetVoid;
    private double golemRange;
    private boolean modeFill;

    public AIGolemWifiEssentia(EntityGolemBase golem, WirelessGolemHandler.WirelessServerData wsd) {
        super(golem, wsd);
    }

    private void checkConnectedJars(World world, ChunkCoordinates gHomePos, TileEntity teJar) {
        if (this.checkedJars.size() >= 200) {
            return;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            int setOp;
            int x = side.offsetX + teJar.field_145851_c;
            int y = side.offsetY + teJar.field_145848_d;
            int z = side.offsetZ + teJar.field_145849_e;
            TileEntity te = world.func_147438_o(x, y, z);
            if (!(te instanceof TileJarFillable) || (setOp = this.setTargetIfValid((TileJarFillable)te, gHomePos)) <= 2) continue;
            this.checkConnectedJars(world, gHomePos, te);
        }
    }

    private void findClosestValidJar() {
        if (this.targetJar != null && this.golem.field_70170_p.func_147438_o(this.targetJar.field_145851_c, this.targetJar.field_145848_d, this.targetJar.field_145849_e) == this.targetJar) {
            Aspect wantedAspect;
            Aspect aspect = wantedAspect = this.targetJar.aspectFilter != null ? this.targetJar.aspectFilter : this.targetJar.aspect;
            if (wantedAspect != null && (this.targetVoid || this.targetJar.amount < this.targetJar.maxAmount) && this.network.extractEssentia(wantedAspect, 1, Actionable.SIMULATE) > 0L) {
                return;
            }
        }
        this.targetJar = null;
        this.targetDistance = Double.MAX_VALUE;
        this.targetVoid = false;
        World world = this.golem.field_70170_p;
        int worldDim = world.field_73011_w.field_76574_g;
        this.golemRange = this.golem.getRange();
        this.golemRange *= this.golemRange;
        ChunkCoordinates gHomePos = this.golem.func_110172_bL();
        for (Marker marker : this.golem.getMarkers()) {
            TileEntity markedTile;
            if (marker.dim != worldDim || !((markedTile = world.func_147438_o(marker.x, marker.y, marker.z)) instanceof TileJarFillable)) continue;
            this.setTargetIfValid((TileJarFillable)markedTile, gHomePos);
            this.checkConnectedJars(world, gHomePos, markedTile);
        }
        this.checkedJars.clear();
    }

    private int setTargetIfValid(TileJarFillable jar, ChunkCoordinates gHomePos) {
        if (!this.checkedJars.add(jar)) {
            return 2;
        }
        double distance = jar.func_145835_a((double)gHomePos.field_71574_a, (double)gHomePos.field_71572_b, (double)gHomePos.field_71573_c);
        if (distance > this.golemRange) {
            return 1;
        }
        boolean isVoid = jar instanceof TileJarFillableVoid;
        if ((!this.targetVoid || isVoid) && distance > this.targetDistance) {
            return 1;
        }
        if (jar.aspect == null && jar.aspectFilter == null) {
            return 3;
        }
        if (!isVoid && jar.amount >= jar.maxAmount) {
            return 3;
        }
        this.targetJar = jar;
        this.targetDistance = distance;
        this.targetVoid = isVoid;
        return 4;
    }

    @Override
    protected boolean needsNetworkNow() {
        ChunkCoordinates gHomePos = this.golem.func_110172_bL();
        ForgeDirection side = ForgeDirection.getOrientation((int)this.golem.homeFacing);
        TileEntity te = this.golem.field_70170_p.func_147438_o(gHomePos.field_71574_a - side.offsetX, gHomePos.field_71572_b - side.offsetY, gHomePos.field_71573_c - side.offsetZ);
        boolean bl = this.modeFill = !(te instanceof IEssentiaTransport);
        if (this.modeFill) {
            for (int i = 1; i < 6 && this.modeFill; ++i) {
                te = this.golem.field_70170_p.func_147438_o(gHomePos.field_71574_a - side.offsetX, gHomePos.field_71572_b - side.offsetY + i, gHomePos.field_71573_c - side.offsetZ);
                this.modeFill = !(te instanceof TileAlembic);
            }
        }
        if (this.modeFill) {
            if (this.golem.essentiaAmount > 0) {
                return false;
            }
            this.findClosestValidJar();
            return this.targetJar != null;
        }
        return this.golem.func_70661_as().func_75500_f() && this.golem.essentiaAmount > 0;
    }

    @Override
    public void func_75246_d() {
        if (this.modeFill) {
            Aspect wantedAspect;
            Aspect aspect = wantedAspect = this.targetJar.aspectFilter != null ? this.targetJar.aspectFilter : this.targetJar.aspect;
            if (wantedAspect == null) {
                this.targetJar = null;
                return;
            }
            int amount = this.targetJar.maxAmount;
            if (!this.targetVoid && (amount -= this.targetJar.amount) < 1) {
                this.targetJar = null;
                return;
            }
            int extractedAmount = (int)this.network.extractEssentia(wantedAspect, amount, Actionable.MODULATE);
            if (extractedAmount <= 0) {
                return;
            }
            this.golem.essentia = wantedAspect;
            this.golem.essentiaAmount = extractedAmount;
        } else {
            if (this.golem.essentia == null || this.golem.essentiaAmount <= 0 || !this.golem.func_70661_as().func_75500_f()) {
                return;
            }
            int injectedAmount = (int)this.network.insertEssentia(this.golem.essentia, this.golem.essentiaAmount);
            if (injectedAmount == 0) {
                return;
            }
            this.golem.essentiaAmount -= injectedAmount;
            if (this.golem.essentiaAmount <= 0) {
                this.golem.essentia = null;
            }
        }
        this.golem.updateCarried();
    }
}

