/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.service.itemfinder;

import codechicken.nei.api.API;
import codechicken.nei.event.NEIConfigsLoadedEvent;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerDrawHandler;
import codechicken.nei.guihook.IContainerInputHandler;
import com.gtnh.findit.FindIt;
import com.gtnh.findit.FindItConfig;
import com.gtnh.findit.FindItNetwork;
import com.gtnh.findit.fx.EntityHighlighter;
import com.gtnh.findit.fx.SlotHighlighter;
import com.gtnh.findit.service.itemfinder.FindItemRequest;
import com.gtnh.findit.service.itemfinder.ItemFindService;
import com.gtnh.findit.service.itemfinder.ItemFoundResponse;
import com.gtnh.findit.util.AbstractStackFinder;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;

public class ClientItemFindService
extends ItemFindService {
    private final SlotHighlighter slotHighlighter;
    private final EntityHighlighter itemEntitiesHighlighter;
    private FindItemRequest foundItem = null;
    private long expirationTime = 0L;

    public ClientItemFindService() {
        if (!FindIt.isExtraUtilitiesLoaded()) {
            API.addHashBind((String)"gui.findit.find_item", (int)20);
        }
        this.slotHighlighter = new SlotHighlighter();
        this.itemEntitiesHighlighter = new EntityHighlighter();
        GuiContainerManager.addDrawHandler((IContainerDrawHandler)this.slotHighlighter);
        GuiContainerManager.addInputHandler((IContainerInputHandler)new ItemFindInputHandler());
        MinecraftForge.EVENT_BUS.register((Object)new NEIEventListener());
        MinecraftForge.EVENT_BUS.register((Object)new WorldRenderListener());
        FMLCommonHandler.instance().bus().register((Object)new TickListener());
    }

    public void handleResponse(EntityClientPlayerMP player, ItemFoundResponse response) {
        this.slotHighlighter.highlightSlots(null, new HashSet<Slot>(), -30938);
        this.foundItem = response.getFoundStack() != null ? new FindItemRequest(response.getFoundStack()) : null;
        this.expirationTime = System.currentTimeMillis() + (long)FindItConfig.ITEM_HIGHLIGHTING_DURATION * 1000L;
        if (this.foundItem == null || !FindItConfig.SEARCH_ITEMS_ON_GROUND) {
            return;
        }
        int searchRadius = FindItConfig.SEARCH_RADIUS;
        AxisAlignedBB searchBox = AxisAlignedBB.func_72330_a((double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v, (double)player.field_70165_t, (double)player.field_70163_u, (double)player.field_70161_v).func_72314_b((double)searchRadius, (double)searchRadius, (double)searchRadius);
        List itemEntities = player.field_70170_p.func_72872_a(EntityItem.class, searchBox);
        ArrayList<Integer> foundItemEntities = new ArrayList<Integer>();
        for (EntityItem itemEntity : itemEntities) {
            if (!this.foundItem.isStackSatisfies((EntityPlayer)player, itemEntity.func_92059_d())) continue;
            foundItemEntities.add(itemEntity.func_145782_y());
            if (foundItemEntities.size() < FindItConfig.MAX_RESPONSE_SIZE) continue;
            break;
        }
        this.itemEntitiesHighlighter.highlightEntities(foundItemEntities, this.expirationTime);
    }

    public static ClientItemFindService getInstance() {
        return (ClientItemFindService)FindIt.getItemFindService();
    }

    private static class ItemFindInputHandler
    extends AbstractStackFinder {
        private ItemFindInputHandler() {
        }

        @Override
        protected String getKeyBindId() {
            return FindIt.isExtraUtilitiesLoaded() ? "gui.xu_ping" : "gui.findit.find_item";
        }

        @Override
        protected boolean findStack(ItemStack stack) {
            FindItNetwork.CHANNEL.sendToServer((IMessage)new FindItemRequest(stack));
            return true;
        }
    }

    public static class NEIEventListener {
        @SubscribeEvent
        public void onNEIConfigsLoaded(NEIConfigsLoadedEvent event) {
            if (FindIt.isExtraUtilitiesLoaded()) {
                GuiContainerManager.inputHandlers.removeIf(inputHandler -> inputHandler.getClass().getName().equals("com.rwtema.extrautils.nei.ping.NEIPing"));
            }
        }
    }

    public class WorldRenderListener {
        @SubscribeEvent
        public void renderWorldLastEvent(RenderWorldLastEvent event) {
            ClientItemFindService.this.itemEntitiesHighlighter.renderHighlightedEntities(event);
        }
    }

    public class TickListener {
        @SubscribeEvent
        public void onClientPostTick(TickEvent.ClientTickEvent event) {
            if (ClientItemFindService.this.foundItem == null || event.phase != TickEvent.Phase.END) {
                return;
            }
            if (Minecraft.func_71410_x().field_71441_e == null) {
                return;
            }
            GuiScreen screen = Minecraft.func_71410_x().field_71462_r;
            if (!(screen instanceof GuiContainer)) {
                return;
            }
            GuiContainer gui = (GuiContainer)screen;
            HashSet<Slot> highlightedSlots = new HashSet<Slot>();
            if (System.currentTimeMillis() > ClientItemFindService.this.expirationTime) {
                ClientItemFindService.this.foundItem = null;
            }
            if (ClientItemFindService.this.foundItem == null) {
                return;
            }
            List slots = gui.field_147002_h.field_75151_b;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            for (Slot slot : slots) {
                if (slot.field_75224_c instanceof InventoryPlayer || !ClientItemFindService.this.foundItem.isStackSatisfies((EntityPlayer)player, slot.func_75211_c())) continue;
                highlightedSlots.add(slot);
                if (highlightedSlots.size() <= 256) continue;
                break;
            }
            ClientItemFindService.this.slotHighlighter.highlightSlots(gui, highlightedSlots, FindItConfig.ITEM_HIGHLIGHTING_COLOR);
        }
    }
}

