/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.mixins.late.journeymap;

import com.gtnewhorizons.navigator.api.NavigatorApi;
import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.steps.RenderStep;
import com.gtnewhorizons.navigator.mixins.late.journeymap.DisplayVarsAccessor;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.ui.minimap.DisplayVars;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.minimap.Shape;
import net.minecraft.client.Minecraft;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MiniMap.class}, remap=false)
public abstract class MiniMapMixin {
    @Final
    @Shadow
    private static GridRenderer gridRenderer;
    @Final
    @Shadow
    private Minecraft mc;
    @Shadow
    private DisplayVars dv;

    @Inject(method={"drawOnMapWaypoints"}, at={@At(value="HEAD")}, require=1)
    private void navigator$onBeforeDrawWaypoints(double rotation, CallbackInfo ci) {
        for (LayerManager layerManager : NavigatorApi.getEnabledLayers(SupportedMods.JourneyMap)) {
            if (!layerManager.isLayerActive()) continue;
            if (((DisplayVarsAccessor)this.dv).getShape() == Shape.Circle) {
                layerManager.recacheMiniMap((int)this.mc.field_71439_g.field_70165_t, (int)this.mc.field_71439_g.field_70161_v, ((DisplayVarsAccessor)this.dv).getMinimapWidth());
                continue;
            }
            layerManager.recacheMiniMap((int)this.mc.field_71439_g.field_70165_t, (int)this.mc.field_71439_g.field_70161_v, gridRenderer.getWidth(), gridRenderer.getHeight());
        }
        for (LayerRenderer layerRenderer : NavigatorApi.getActiveRenderersByPriority(SupportedMods.JourneyMap)) {
            for (RenderStep renderStep : layerRenderer.getRenderSteps()) {
                if (!(renderStep instanceof DrawStep)) continue;
                DrawStep drawStep = (DrawStep)renderStep;
                drawStep.draw(0.0, 0.0, gridRenderer, ((DisplayVarsAccessor)this.dv).getDrawScale(), ((DisplayVarsAccessor)this.dv).getFontScale(), rotation);
            }
        }
    }
}

