/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitLineHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitRecipe;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechRecipeUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.crafting.CraftingManager;

class RecipeHandler {
    private final CircuitLineHandler circuitLineHandler;
    private Set<ItemComponent> craftingTableOutputs;
    private Set<ItemComponent> assemblingMachineOutputs;
    private Set<ItemComponent> assemblingLineOutputs;
    private ImmutableListMultimap<ItemComponent, CircuitRecipe> circuitAssemblingMachineRecipes;

    RecipeHandler(CircuitLineHandler circuitLineHandler) {
        this.circuitLineHandler = circuitLineHandler;
    }

    void initialize() {
        this.craftingTableOutputs = new HashSet<ItemComponent>();
        CraftingManager.func_77594_a().func_77592_b().stream().filter(recipe -> recipe.func_77571_b() != null && recipe.func_77571_b().func_77973_b() != null).forEach(recipe -> this.craftingTableOutputs.add(ItemComponent.create(recipe.func_77571_b())));
        this.assemblingMachineOutputs = RecipeMaps.assemblerRecipes.getAllRecipes().stream().flatMap(recipe -> GregTechRecipeUtil.buildComponentsFromItemOutputs(recipe).stream()).map(DisplayComponent::component).map(ItemComponent.class::cast).collect(Collectors.toSet());
        this.assemblingLineOutputs = RecipeMaps.assemblylineVisualRecipes.getAllRecipes().stream().flatMap(recipe -> GregTechRecipeUtil.buildComponentsFromItemOutputs(recipe).stream()).map(DisplayComponent::component).map(ItemComponent.class::cast).collect(Collectors.toSet());
        Set<ItemComponent> allCircuits = this.circuitLineHandler.allCircuits();
        ListMultimap circuitRecipes = MultimapBuilder.hashKeys().arrayListValues().build();
        for (GTRecipe recipe2 : RecipeMaps.circuitAssemblerRecipes.getAllRecipes()) {
            ItemComponent output = (ItemComponent)((DisplayComponent)Iterables.getOnlyElement(GregTechRecipeUtil.buildComponentsFromItemOutputs(recipe2))).component();
            if (!allCircuits.contains(output)) continue;
            circuitRecipes.put((Object)output, (Object)recipe2);
        }
        ImmutableListMultimap.Builder circuitAssemblingMachineRecipesBuilder = ImmutableListMultimap.builder();
        circuitRecipes.asMap().forEach((key, value) -> circuitAssemblingMachineRecipesBuilder.putAll(key, CircuitRecipe.buildCircuitRecipes(value)));
        this.circuitAssemblingMachineRecipes = circuitAssemblingMachineRecipesBuilder.build();
    }

    boolean hasCraftingTableRecipes(ItemComponent circuit) {
        return this.craftingTableOutputs.contains(circuit);
    }

    boolean hasAssemblingMachineRecipes(ItemComponent circuit) {
        return this.assemblingMachineOutputs.contains(circuit);
    }

    boolean hasAssemblingLineRecipes(ItemComponent circuit) {
        return this.assemblingLineOutputs.contains(circuit);
    }

    ImmutableList<CircuitRecipe> getCircuitAssemblingMachineRecipes(ItemComponent circuit) {
        return this.circuitAssemblingMachineRecipes.get((Object)circuit);
    }
}

