/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram.layout;

import com.github.dcysteine.neicustomdiagram.api.diagram.layout.$AutoValue_Lines;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Lines;
import com.google.common.collect.ImmutableList;
import java.util.Collection;

final class AutoValue_Lines
extends $AutoValue_Lines {
    AutoValue_Lines(int colour$, ImmutableList<Lines.Segment> segments$, ImmutableList<Lines.Segment> arrows$) {
        super(colour$, segments$, arrows$);
    }

    @Override
    public final String toPrettyString() {
        return "Lines {\n  colour = " + this.colour() + ",\n  segments = " + AutoValue_Lines.formatCollectionOfSegment(this.segments(), 1) + ",\n  arrows = " + AutoValue_Lines.formatCollectionOfSegment(this.arrows(), 1) + ",\n}";
    }

    private static String format(Object value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        return value.toString().replace("\n", "\n" + AutoValue_Lines.$indent(indentLevel));
    }

    private static String formatCollectionOfSegment(Collection<Lines.Segment> value, int indentLevel) {
        if (value == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder().append("[");
        boolean hasElements = false;
        for (Lines.Segment element : value) {
            builder.append("\n").append(AutoValue_Lines.$indent(indentLevel + 1)).append(AutoValue_Lines.format(element, indentLevel + 1)).append(",");
            hasElements = true;
        }
        if (hasElements) {
            builder.append("\n").append(AutoValue_Lines.$indent(indentLevel));
        }
        return builder.append("]").toString();
    }

    private static String $indent(int level) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < level; ++i) {
            builder.append("  ");
        }
        return builder.toString();
    }
}

