/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.render;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ParticleHelper {
    private static final Random rand = new Random();

    @SideOnly(value=Side.CLIENT)
    public static boolean addHitEffects(World world, Block block, MovingObjectPosition target, EffectRenderer effectRenderer, Callback callback) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        int sideHit = target.field_72310_e;
        if (block != world.func_147439_a(x, y, z)) {
            return true;
        }
        int meta = world.func_72805_g(x, y, z);
        float b = 0.1f;
        double px = (double)x + rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = (double)y + rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = (double)z + rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == 0) {
            py = (double)y + block.func_149665_z() - (double)b;
        } else if (sideHit == 1) {
            py = (double)y + block.func_149669_A() + (double)b;
        } else if (sideHit == 2) {
            pz = (double)z + block.func_149706_B() - (double)b;
        } else if (sideHit == 3) {
            pz = (double)z + block.func_149693_C() + (double)b;
        } else if (sideHit == 4) {
            px = (double)x + block.func_149704_x() - (double)b;
        } else if (sideHit == 5) {
            px = (double)x + block.func_149753_y() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, 0.0, 0.0, 0.0, block, sideHit, meta);
        callback.addHitEffects(fx, world, x, y, z, meta, sideHit);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean addDestroyEffects(World world, Block block, int x, int y, int z, int meta, EffectRenderer effectRenderer, Callback callback) {
        if (block != world.func_147439_a(x, y, z)) {
            return true;
        }
        int iterations = 4;
        for (int i = 0; i < iterations; ++i) {
            for (int j = 0; j < iterations; ++j) {
                for (int k = 0; k < iterations; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)iterations;
                    double py = (double)y + ((double)j + 0.5) / (double)iterations;
                    double pz = (double)z + ((double)k + 0.5) / (double)iterations;
                    int random = rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(world, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, block, random, meta);
                    callback.addDestroyEffects(fx, world, x, y, z, meta);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    public static interface Callback {
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX var1, World var2, int var3, int var4, int var5, int var6, int var7);

        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX var1, World var2, int var3, int var4, int var5, int var6);
    }

    public static class DefaultCallback
    implements Callback {
        private final Block block;

        public DefaultCallback(Block block) {
            this.block = block;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addHitEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta, int side) {
            this.setTexture(fx, world, x, y, z, side);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void addDestroyEffects(EntityDiggingFX fx, World world, int x, int y, int z, int meta) {
            this.setTexture(fx, world, x, y, z, 0);
        }

        @SideOnly(value=Side.CLIENT)
        private void setTexture(EntityDiggingFX fx, World world, int x, int y, int z, int side) {
            fx.func_110125_a(this.block.func_149673_e((IBlockAccess)world, x, y, z, side));
        }
    }
}

