/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.gui.machine;

import galaxyspace.core.inventory.container.machine.ContainerSolarPanel;
import galaxyspace.core.tile.machine.TileEntitySolarPanel;
import java.util.ArrayList;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.client.gui.container.GuiContainerGC;
import micdoodle8.mods.galacticraft.core.client.gui.element.GuiElementInfoRegion;
import micdoodle8.mods.galacticraft.core.energy.EnergyDisplayHelper;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiSolarPanel
extends GuiContainerGC {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("galaxyspace", "textures/gui/solarpanel.png");
    private final TileEntitySolarPanel solarPanel;
    private GuiButton buttonEnableSolar;
    private GuiElementInfoRegion electricInfoRegion;

    public GuiSolarPanel(InventoryPlayer inventory, TileEntitySolarPanel solarPanel) {
        super((Container)new ContainerSolarPanel(inventory, solarPanel));
        this.electricInfoRegion = new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 107, (this.field_146295_m - this.field_147000_g) / 2 + 101, 56, 9, new ArrayList(), this.field_146294_l, this.field_146295_m, (GuiContainerGC)this);
        this.solarPanel = solarPanel;
        this.field_147000_g = 201;
        this.field_146999_f = 176;
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            GalacticraftCore.packetPipeline.sendToServer((IPacket)new PacketSimple(PacketSimple.EnumSimplePacket.S_UPDATE_DISABLEABLE_BUTTON, new Object[]{this.solarPanel.field_145851_c, this.solarPanel.field_145848_d, this.solarPanel.field_145849_e, 0}));
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        ArrayList<String> electricityDesc = new ArrayList<String>();
        electricityDesc.add(GCCoreUtil.translate((String)"gui.energyStorage.desc.0"));
        electricityDesc.add(EnumColor.YELLOW + GCCoreUtil.translate((String)"gui.energyStorage.desc.1") + (int)Math.floor(this.solarPanel.getEnergyStoredGC()) + " / " + (int)Math.floor(this.solarPanel.getMaxEnergyStoredGC()));
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        this.electricInfoRegion.xPosition = (this.field_146294_l - this.field_146999_f) / 2 + 96;
        this.electricInfoRegion.yPosition = (this.field_146295_m - this.field_147000_g) / 2 + 24;
        this.electricInfoRegion.parentWidth = this.field_146294_l;
        this.electricInfoRegion.parentHeight = this.field_146295_m;
        this.infoRegions.add(this.electricInfoRegion);
        ArrayList<String> batterySlotDesc = new ArrayList<String>();
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.0"));
        batterySlotDesc.add(GCCoreUtil.translate((String)"gui.batterySlot.desc.1"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 151, (this.field_146295_m - this.field_147000_g) / 2 + 82, 18, 18, batterySlotDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        ArrayList<String> sunGenDesc = new ArrayList<String>();
        float sunVisible = (float)Math.round((float)this.solarPanel.solarStrength / 9.0f * 1000.0f) / 10.0f;
        sunGenDesc.add(this.solarPanel.solarStrength > 0 ? GCCoreUtil.translate((String)"gui.status.sunVisible.name") + ": " + sunVisible + "%" : GCCoreUtil.translate((String)"gui.status.blockedfully.name"));
        this.infoRegions.add(new GuiElementInfoRegion((this.field_146294_l - this.field_146999_f) / 2 + 47, (this.field_146295_m - this.field_147000_g) / 2 + 20, 18, 18, sunGenDesc, this.field_146294_l, this.field_146295_m, (GuiContainerGC)this));
        this.buttonEnableSolar = new GuiButton(0, this.field_146294_l / 2 - 36, this.field_146295_m / 2 - 19, 72, 20, GCCoreUtil.translate((String)"gui.button.enable.name"));
        this.field_146292_n.add(this.buttonEnableSolar);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int offsetY = 35;
        this.buttonEnableSolar.field_146124_l = this.solarPanel.disableCooldown == 0;
        this.buttonEnableSolar.field_146126_j = this.solarPanel.getDisabled(0) ? GCCoreUtil.translate((String)"gui.button.enable.name") : GCCoreUtil.translate((String)"gui.button.disable.name");
        String displayString = this.solarPanel.func_145825_b();
        this.field_146289_q.func_78276_b(EnumColor.WHITE + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 1, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.status.name") + ": " + this.getStatus();
        this.field_146289_q.func_78276_b(EnumColor.WHITE + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 22 + offsetY, 0x404040);
        displayString = GCCoreUtil.translate((String)"gui.message.generating.name") + ": " + (this.solarPanel.generateWatts > 0 ? EnergyDisplayHelper.getEnergyDisplayS((float)this.solarPanel.generateWatts) + "/t" : GCCoreUtil.translate((String)"gui.status.notGenerating.name"));
        this.field_146289_q.func_78276_b(EnumColor.WHITE + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 11 + offsetY, 0x404040);
        float boost = (float)Math.round((this.solarPanel.getSolarBoost() - 1.0f) * 1000.0f) / 10.0f;
        displayString = GCCoreUtil.translate((String)"gui.message.environment.name") + ": " + boost + "%";
        this.field_146289_q.func_78276_b(EnumColor.WHITE + displayString, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(displayString) / 2, 33 + offsetY, 0x404040);
        this.field_146289_q.func_78276_b(EnumColor.WHITE + GCCoreUtil.translate((String)"container.inventory"), 13, this.field_147000_g - 91, 0x404040);
    }

    private String getStatus() {
        if (this.solarPanel.getDisabled(0)) {
            return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.disabled.name");
        }
        if (!this.solarPanel.func_145831_w().func_72935_r()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (this.solarPanel.func_145831_w().func_72896_J() || this.solarPanel.func_145831_w().func_72911_I()) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.raining.name");
        }
        if (this.solarPanel.solarStrength == 0) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedfully.name");
        }
        if (this.solarPanel.solarStrength < 9) {
            return EnumColor.DARK_RED + GCCoreUtil.translate((String)"gui.status.blockedpartial.name");
        }
        if (this.solarPanel.generateWatts > 0) {
            return EnumColor.DARK_GREEN + GCCoreUtil.translate((String)"gui.status.collectingenergy.name");
        }
        return EnumColor.ORANGE + GCCoreUtil.translate((String)"gui.status.unknown.name");
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        int var4 = (this.field_146294_l - this.field_146999_f) / 2;
        int var5 = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(var4, var5, 0, 0, this.field_146999_f, this.field_147000_g);
        ArrayList electricityDesc = new ArrayList();
        EnergyDisplayHelper.getEnergyDisplayTooltip((float)this.solarPanel.getEnergyStoredGC(), (float)this.solarPanel.getMaxEnergyStoredGC(), electricityDesc);
        this.electricInfoRegion.tooltipStrings = electricityDesc;
        if (this.solarPanel.getEnergyStoredGC() > 0.0f) {
            this.func_73729_b(var4 + 83, var5 + 24, 176, 0, 11, 10);
        }
        if (this.solarPanel.solarStrength > 0) {
            this.func_73729_b(var4 + 48, var5 + 21, 176, 10, 16, 16);
        }
        this.func_73729_b(var4 + 97, var5 + 25, 187, 0, Math.min(this.solarPanel.getScaledElecticalLevel(54), 54), 7);
    }
}

