/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.block.machine;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import galaxyspace.core.block.machine.BlockMachine;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.tile.machine.TileEntityGeothermalGenerator;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGeothermalGenerator
extends BlockMachine {
    private IIcon iconMachineSide;
    private IIcon iconOutput;
    private IIcon iconLavaOutput;
    private final IIcon[] iconGeothermalGenerator = new IIcon[2];

    public BlockGeothermalGenerator() {
        super(GCBlocks.machine);
        this.func_149663_c("GeothermalGenerator");
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileGenerator = (TileEntityGeothermalGenerator)tileEntity;
            if (tileGenerator.lavaTank.getFluidAmount() > 0) {
                return 8;
            }
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine");
        this.iconOutput = reg.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_output");
        this.iconMachineSide = reg.func_94245_a(GalacticraftCore.TEXTURE_PREFIX + "machine_side");
        this.iconLavaOutput = reg.func_94245_a("galaxyspace:overworld/geothermalGenerator_lava_input");
        for (int i = 0; i < this.iconGeothermalGenerator.length; ++i) {
            this.iconGeothermalGenerator[i] = reg.func_94245_a("galaxyspace:overworld/geothermalGenerator_" + i);
        }
    }

    public void func_149734_b(World worldIn, int x, int y, int z, Random random) {
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileGenerator = (TileEntityGeothermalGenerator)tileEntity;
            if (tileGenerator.heatGJperTick > 0.0f) {
                float rX = (float)x + 0.5f;
                float rY = (float)y + random.nextFloat() * 0.375f;
                float rZ = (float)z + 0.5f;
                float radius = 0.52f;
                float randomOffset = random.nextFloat() * 0.6f - 0.3f;
                switch (worldIn.func_72805_g(x, y, z)) {
                    case 0: {
                        worldIn.func_72869_a("smoke", (double)(rX - radius), (double)rY, (double)(rZ + randomOffset), 0.0, 0.0, 0.0);
                        worldIn.func_72869_a("flame", (double)(rX - radius), (double)rY, (double)(rZ + randomOffset), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 1: {
                        worldIn.func_72869_a("smoke", (double)(rX + radius), (double)rY, (double)(rZ + randomOffset), 0.0, 0.0, 0.0);
                        worldIn.func_72869_a("flame", (double)(rX + radius), (double)rY, (double)(rZ + randomOffset), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 2: {
                        worldIn.func_72869_a("smoke", (double)(rX + randomOffset), (double)rY, (double)(rZ + radius), 0.0, 0.0, 0.0);
                        worldIn.func_72869_a("flame", (double)(rX + randomOffset), (double)rY, (double)(rZ + radius), 0.0, 0.0, 0.0);
                        break;
                    }
                    case 3: {
                        worldIn.func_72869_a("smoke", (double)(rX + randomOffset), (double)rY, (double)(rZ - radius), 0.0, 0.0, 0.0);
                        worldIn.func_72869_a("flame", (double)(rX + randomOffset), (double)rY, (double)(rZ - radius), 0.0, 0.0, 0.0);
                        break;
                    }
                }
            }
        }
    }

    public IIcon func_149673_e(IBlockAccess worldIn, int x, int y, int z, int side) {
        TileEntity tileEntity;
        int metadata = worldIn.func_72805_g(x, y, z);
        if ((metadata == 0 && side == 4 || metadata == 1 && side == 5 || metadata == 2 && side == 3 || metadata == 3 && side == 2) && (tileEntity = worldIn.func_147438_o(x, y, z)) instanceof TileEntityGeothermalGenerator) {
            TileEntityGeothermalGenerator tileGenerator = (TileEntityGeothermalGenerator)tileEntity;
            if (tileGenerator.lavaTank.getFluidAmount() == 0) {
                return this.iconGeothermalGenerator[0];
            }
            return this.iconGeothermalGenerator[1];
        }
        return this.func_149691_a(side, metadata);
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == 0 || side == 1) {
            return this.field_149761_L;
        }
        if (meta >= 0) {
            if (side == meta + 2) {
                return this.iconOutput;
            }
            if (side == ForgeDirection.getOrientation((int)(meta + 2)).getOpposite().ordinal()) {
                return this.iconLavaOutput;
            }
            if (meta == 0 && side == 4 || meta == 1 && side == 5 || meta == 2 && side == 3 || meta == 3 && side == 2) {
                return this.iconGeothermalGenerator[0];
            }
        }
        return this.iconMachineSide;
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        if ((metadata & 0xC) == 0) {
            return new TileEntityGeothermalGenerator();
        }
        return null;
    }

    public int func_149692_a(int meta) {
        return meta & 0xC;
    }

    @Override
    public String getDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.coefficient.desc") + ": x" + GSConfigCore.coefficientGeothermalGenerator;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate((String)"tile.GeothermalGenerator.desc");
    }
}

