/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.tcneiadditions.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.ModItems;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler.CrucibleRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;
import ru.timeconqueror.tcneiadditions.client.TCNAClient;
import ru.timeconqueror.tcneiadditions.nei.ResearchInfo;
import ru.timeconqueror.tcneiadditions.util.TCNAConfig;
import ru.timeconqueror.tcneiadditions.util.TCUtil;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.client.lib.UtilsFX;

public class TCNACrucibleRecipeHandler
extends CrucibleRecipeHandler {
    private final String userName = Minecraft.func_71410_x().func_110432_I().func_111285_a();
    private int ySize;
    private final int aspectsPerRow = 3;
    private TCNAClient tcnaClient = TCNAClient.getInstance();

    public void loadTransferRects() {
        TCUtil.loadTransferRects((TemplateRecipeHandler)this);
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getOverlayIdentifier())) {
            for (Object o : ThaumcraftApi.getCraftingRecipes()) {
                boolean shouldShowRecipe;
                CrucibleRecipe tcRecipe;
                CrucibleCachedRecipe recipe;
                if (!(o instanceof CrucibleRecipe) || !(recipe = new CrucibleCachedRecipe(tcRecipe = (CrucibleRecipe)o, shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.key))).isValid()) continue;
                recipe.computeVisuals();
                this.arecipes.add(recipe);
                this.aspectsAmount.add(recipe.aspects);
            }
        } else if (outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (CrucibleRecipe tcRecipe : TCUtil.getCrucibleRecipes(result)) {
            boolean shouldShowRecipe = TCUtil.shouldShowRecipe(this.userName, tcRecipe.key);
            CrucibleCachedRecipe recipe = new CrucibleCachedRecipe(tcRecipe, shouldShowRecipe);
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        List<CrucibleRecipe> tcRecipeList = TCUtil.getCrucibleRecipesByInput(ingredient);
        for (CrucibleRecipe tcRecipe : tcRecipeList) {
            if (tcRecipe == null || !TCUtil.shouldShowRecipe(this.userName, tcRecipe.key)) continue;
            CrucibleCachedRecipe recipe = new CrucibleCachedRecipe(tcRecipe, true);
            recipe.computeVisuals();
            recipe.setIngredientPermutation(recipe.ingredients, ingredient);
            this.arecipes.add(recipe);
            this.aspectsAmount.add(recipe.aspects);
        }
    }

    public void drawBackground(int recipeIndex) {
        CrucibleCachedRecipe recipe = (CrucibleCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        if (recipe.shouldShowRecipe) {
            super.drawBackground(recipeIndex);
            return;
        }
        int x = 30;
        int y = 3;
        GL11.glPushMatrix();
        UtilsFX.bindTexture((String)"textures/gui/gui_researchbook_overlay.png");
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glTranslatef((float)x, (float)y, (float)0.0f);
        GL11.glScalef((float)1.75f, (float)1.75f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)0, (int)3, (int)56, (int)17);
        GL11.glPopMatrix();
    }

    public void drawAspects(int recipe, int x, int y) {
        AspectList aspects = (AspectList)this.aspectsAmount.get(recipe);
        int rows = (int)Math.ceil((double)aspects.size() / 3.0);
        int xBase = x + 8;
        int yBase = y + 107 - 10 * rows;
        int count = 0;
        for (int row = 0; row < rows; ++row) {
            int columns = Math.min(aspects.size() - row * 3, 3);
            int offSet = (100 - columns * 20) / 2;
            for (int column = 0; column < columns; ++column) {
                Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                int posX = xBase + column * 20 + offSet;
                int posY = yBase + row * 20;
                UtilsFX.drawTag((int)posX, (int)posY, (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            }
        }
    }

    public void drawExtras(int recipeIndex) {
        CrucibleCachedRecipe cachedRecipe;
        TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
        if (cRecipe instanceof CrucibleCachedRecipe && !(cachedRecipe = (CrucibleCachedRecipe)cRecipe).shouldShowRecipe) {
            String textToDraw = StatCollector.func_74838_a((String)"tcneiadditions.research.missing");
            int y = 28;
            for (Object text : Minecraft.func_71410_x().field_71466_p.func_78271_c(textToDraw, 162)) {
                GuiDraw.drawStringC((String)((String)text), (int)82, (int)y, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
                y += 11;
            }
        }
        if (TCNAConfig.showResearchKey) {
            GuiDraw.drawString((String)(EnumChatFormatting.BOLD + StatCollector.func_74838_a((String)"tcneiadditions.research.researchName")), (int)0, (int)5, (int)this.tcnaClient.getColor("tcneiadditions.gui.textColor"), (boolean)false);
            if (cRecipe instanceof CrucibleCachedRecipe) {
                cachedRecipe = (CrucibleCachedRecipe)cRecipe;
                int recipeY = 15;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    r.onDraw(0, recipeY);
                    recipeY += 13;
                }
            }
        }
        TCUtil.drawSeeAllRecipesLabel();
    }

    public List<String> handleTooltip(GuiRecipe<?> gui, List<String> list, int recipeIndex) {
        if (TCNAConfig.showResearchKey && GuiContainerManager.shouldShowTooltip(gui) && list.isEmpty()) {
            TemplateRecipeHandler.CachedRecipe cRecipe = (TemplateRecipeHandler.CachedRecipe)this.arecipes.get(recipeIndex);
            Point mousePos = GuiDraw.getMousePosition();
            if (cRecipe instanceof CrucibleCachedRecipe) {
                CrucibleCachedRecipe cachedRecipe = (CrucibleCachedRecipe)cRecipe;
                for (ResearchInfo r : cachedRecipe.prereqs) {
                    Rectangle rect = r.getRect(gui, recipeIndex);
                    if (!rect.contains(mousePos)) continue;
                    r.onHover(list);
                }
            }
        }
        return super.handleTooltip(gui, list, recipeIndex);
    }

    private class CrucibleCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public List<PositionedStack> ingredients;
        public PositionedStack result;
        protected final List<ResearchInfo> prereqs;
        private AspectList aspects;
        private final boolean shouldShowRecipe;
        private final ResearchItem researchItem;

        public CrucibleCachedRecipe(CrucibleRecipe recipe, boolean shouldShowRecipe) {
            super((TemplateRecipeHandler)TCNACrucibleRecipeHandler.this);
            this.setIngredient(recipe.catalyst);
            this.setResult(recipe.getRecipeOutput());
            this.setAspectList(recipe.aspects);
            this.shouldShowRecipe = shouldShowRecipe;
            this.researchItem = ResearchCategories.getResearch((String)recipe.key);
            this.prereqs = new ArrayList<ResearchInfo>();
            if (this.researchItem != null && this.researchItem.key != null) {
                this.prereqs.add(new ResearchInfo(this.researchItem, ThaumcraftApiHelper.isResearchComplete((String)TCNACrucibleRecipeHandler.this.userName, (String)this.researchItem.key)));
            }
            this.addAspectsToIngredients(this.aspects);
        }

        protected void setIngredient(Object in) {
            if (in != null && NEIServerUtils.extractRecipeItems((Object)in).length > 0) {
                PositionedStack stack = new PositionedStack(in, 51, 30, false);
                stack.setMaxSize(1);
                this.ingredients = new ArrayList<PositionedStack>(Collections.singletonList(stack));
            }
        }

        public void setIngredientPermutation(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return;
            }
            super.setIngredientPermutation(ingredients, ingredient);
        }

        protected void setResult(ItemStack out) {
            if (out != null) {
                this.result = new PositionedStack((Object)out, 71, 8, false);
            }
        }

        protected void setAspectList(AspectList aspects) {
            this.aspects = aspects;
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public AspectList getAspectList() {
            return this.aspects;
        }

        public List<PositionedStack> getIngredients() {
            if (!this.shouldShowRecipe) {
                return Collections.emptyList();
            }
            return this.getCycledIngredients(TCNACrucibleRecipeHandler.this.cycleticks / 20, this.ingredients);
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public boolean isValid() {
            return !this.ingredients.isEmpty() && this.result != null;
        }

        public boolean contains(Collection<PositionedStack> ingredients, ItemStack ingredient) {
            if (ingredient.func_77973_b() instanceof ItemAspect) {
                return false;
            }
            return super.contains(ingredients, ingredient);
        }

        protected void addAspectsToIngredients(AspectList aspects) {
            int rows = (int)Math.ceil((double)aspects.size() / 3.0);
            int xBase = 31;
            int yBase = 86 - 10 * rows;
            int count = 0;
            for (int row = 0; row < rows; ++row) {
                int columns = Math.min(aspects.size() - row * 3, 3);
                int offSet = (100 - columns * 20) / 2;
                for (int column = 0; column < columns; ++column) {
                    Aspect aspect = aspects.getAspectsSortedAmount()[count++];
                    int posX = xBase + column * 20 + offSet;
                    int posY = yBase + row * 20;
                    ItemStack stack = new ItemStack(ModItems.itemAspect, aspects.getAmount(aspect), 1);
                    ItemAspect.setAspect((ItemStack)stack, (Aspect)aspect);
                    this.ingredients.add(new PositionedStack((Object)stack, posX, posY, false));
                }
            }
        }
    }
}

