/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser;

import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Argument;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.CalcStepsRegister;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.CloneCache;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Constant;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.Expression;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.FunctionExtension;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.FunctionExtensionVariadic;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.HeadEqBody;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.License;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.PrimitiveElement;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.SerializationUtils;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.StringModel;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.StringUtils;
import com.cleanroommc.modularui.shadow.org.mariuszgromada.math.mxparser.parsertokens.Token;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Function
extends PrimitiveElement
implements Serializable {
    private static final int serialClassID = 3;
    private static final long serialVersionUID = SerializationUtils.getSerialVersionUID(3);
    public static final boolean NO_SYNTAX_ERRORS = true;
    public static final boolean SYNTAX_ERROR = false;
    @Deprecated
    public static final boolean SYNTAX_ERROR_OR_STATUS_UNKNOWN = false;
    private static final boolean SYNTAX_STATUS_UNKNOWN = false;
    public static final int NOT_FOUND = -1;
    public static final int TYPE_ID = 103;
    public static String TYPE_DESC = "<NA>";
    public static final int BODY_RUNTIME = 1;
    public static final int BODY_EXTENDED = 2;
    private int functionBodyType = 1;
    Expression functionExpression;
    private String functionName = "";
    private boolean syntaxStatusDefinition = false;
    private String errorMessageDefinition = "";
    private String description = "";
    boolean isVariadic = false;
    private int parametersNumber = 0;
    private FunctionExtension functionExtension;
    private FunctionExtensionVariadic functionExtensionVariadic;
    double computingTime = 0.0;
    private boolean thisAlreadyAdded = false;

    private static String buildErrorMessageInvalidFunctionName(String functionName) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(functionName, StringModel.STRING_RESOURCES.INVALID_FUNCTION_NAME, "'f', 'f_y', 'f1', 'xf1', 'fxy', ...");
    }

    private static String buildErrorMessageInvalidFunctionDefinitionString(String functionDefinitionString) {
        return StringModel.buildErrorMessagePatternDoesNotMatchWithExamples(functionDefinitionString, StringModel.STRING_RESOURCES.INVALID_FUNCTION_DEFINITION, "'f(x)=2*x', 'f(x,y)=y*sin(x)', 'f(n)=if(n>1,n*f(n-1),1)', 'f(...)=sum(i,1,[npar],par(i))', ...");
    }

    private static String buildErrorMessageIncorrectNumberOfFunctionParameters(String functionName, int expectedNumberOfParameters, int providedNumberOfParameters) {
        return StringModel.buildErrorMessageIncorrectNumberOfParameters(functionName, StringModel.STRING_RESOURCES.INCORRECT_NUMBER_OF_FUNCTION_PARAMETERS, expectedNumberOfParameters, providedNumberOfParameters);
    }

    private void registerNoSyntaxErrorInDefinition() {
        this.syntaxStatusDefinition = true;
        this.errorMessageDefinition = StringModel.STRING_RESOURCES.NO_ERRORS_DETECTED_IN_FUNCTION_DEFINITION;
        if (!this.thisAlreadyAdded) {
            this.addFunctions(this);
            this.thisAlreadyAdded = true;
        }
    }

    private void registerSyntaxErrorInDefinition(String errorMessage) {
        this.syntaxStatusDefinition = false;
        this.errorMessageDefinition = errorMessage;
        this.functionExpression = new Expression("", new PrimitiveElement[0]);
    }

    public Function(String functionName, String functionExpressionString, PrimitiveElement ... elements) {
        super(103);
        if (functionName == null || functionExpressionString == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (elements == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_ELEMENTS_ARE_NULL);
            return;
        }
        String functionNameTrim = functionName.trim();
        if (!StringUtils.regexMatch(functionNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionName(functionName));
            return;
        }
        String functionExpressionStringTrim = functionExpressionString.trim();
        this.functionName = functionNameTrim;
        this.functionExpression = new Expression(functionExpressionStringTrim, elements);
        this.functionExpression.setDescription(functionNameTrim);
        this.functionExpression.UDFExpression = true;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Function(String functionName, String functionExpressionString, String ... argumentsNames) {
        super(103);
        if (functionName == null || functionExpressionString == null || argumentsNames == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        String functionNameTrim = functionName.trim();
        if (!StringUtils.regexMatch(functionNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionName(functionName));
            return;
        }
        String functionExpressionStringTrim = functionExpressionString.trim();
        this.functionName = functionNameTrim;
        this.functionExpression = new Expression(functionExpressionStringTrim, new PrimitiveElement[0]);
        this.functionExpression.setDescription(functionNameTrim);
        this.functionExpression.UDFExpression = true;
        for (String argName : argumentsNames) {
            this.functionExpression.addArguments(new Argument(argName, new PrimitiveElement[0]));
        }
        this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
        this.registerNoSyntaxErrorInDefinition();
    }

    private void addHeadTokensArguments(List<Token> headTokens) {
        if (headTokens.size() <= 1) {
            return;
        }
        for (int i = 1; i < headTokens.size(); ++i) {
            Token t = headTokens.get(i);
            if (t.tokenTypeId == 20) continue;
            this.functionExpression.addArguments(new Argument(t.tokenStr, new PrimitiveElement[0]));
        }
    }

    public Function(String functionDefinitionString, PrimitiveElement ... elements) {
        super(103);
        if (functionDefinitionString == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (elements == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_ELEMENTS_ARE_NULL);
            return;
        }
        String functionDefinitionStringTrim = functionDefinitionString.trim();
        if (StringUtils.regexMatch(functionDefinitionStringTrim, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\(((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*,(\\s)*)*(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionStringTrim);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.addHeadTokensArguments(headEqBody.headTokens);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        if (StringUtils.regexMatch(functionDefinitionStringTrim, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionStringTrim);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionDefinitionString(functionDefinitionStringTrim));
    }

    public Function(String functionName, FunctionExtension functionExtension) {
        super(103);
        if (functionName == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (functionExtension == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_EXTENSION_IS_NULL);
            return;
        }
        String functionNameTrim = functionName.trim();
        if (!StringUtils.regexMatch(functionNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionName(functionName));
            return;
        }
        this.functionName = functionNameTrim;
        this.functionExpression = new Expression("{body-ext}", new PrimitiveElement[0]);
        this.functionExpression.setDescription(functionNameTrim);
        this.parametersNumber = functionExtension.getParametersNumber();
        this.functionExtension = functionExtension;
        this.functionBodyType = 2;
        this.registerNoSyntaxErrorInDefinition();
    }

    public Function(String functionName, FunctionExtensionVariadic functionExtensionVariadic) {
        super(103);
        if (functionName == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            return;
        }
        if (functionExtensionVariadic == null) {
            this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_EXTENSION_IS_NULL);
            return;
        }
        String functionNameTrim = functionName.trim();
        if (!StringUtils.regexMatch(functionNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionName(functionName));
            return;
        }
        this.functionName = functionNameTrim;
        this.functionExpression = new Expression("{body-ext-var}", new PrimitiveElement[0]);
        this.functionExpression.setDescription(functionNameTrim);
        this.isVariadic = true;
        this.parametersNumber = -1;
        this.functionExtensionVariadic = functionExtensionVariadic;
        this.functionBodyType = 2;
        this.registerNoSyntaxErrorInDefinition();
    }

    private Function(Function functionToClone, boolean isThreadSafeClone, CloneCache cloneCache) {
        super(103);
        this.functionBodyType = functionToClone.functionBodyType;
        this.functionName = functionToClone.functionName;
        this.syntaxStatusDefinition = functionToClone.syntaxStatusDefinition;
        this.errorMessageDefinition = functionToClone.errorMessageDefinition;
        this.description = functionToClone.description;
        this.isVariadic = functionToClone.isVariadic;
        this.parametersNumber = functionToClone.parametersNumber;
        this.computingTime = functionToClone.computingTime;
        this.thisAlreadyAdded = functionToClone.thisAlreadyAdded;
        if (functionToClone.functionExtension != null) {
            this.functionExtension = functionToClone.functionExtension.clone();
        }
        if (functionToClone.functionExtensionVariadic != null) {
            this.functionExtensionVariadic = functionToClone.functionExtensionVariadic.clone();
        }
        if (isThreadSafeClone) {
            this.functionExpression = functionToClone.functionExpression.cloneForThreadSafeInternal(cloneCache);
            return;
        }
        this.functionExpression = functionToClone.functionExpression.clone();
    }

    @Deprecated
    public void setFunction(String functionDefinitionString, PrimitiveElement ... elements) {
        if (StringUtils.regexMatch(functionDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\(((\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*,(\\s)*)*(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = false;
            this.addHeadTokensArguments(headEqBody.headTokens);
            this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
            this.description = "";
            this.functionBodyType = 1;
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        if (StringUtils.regexMatch(functionDefinitionString, "(\\s)*(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))(\\s)*(\\s)*\\((\\s)*\\.\\.\\.(\\s)*\\)(\\s)*=(\\s)*(.)+(\\s)*")) {
            HeadEqBody headEqBody = new HeadEqBody(functionDefinitionString);
            this.functionName = headEqBody.headTokens.get((int)0).tokenStr;
            this.functionExpression = new Expression(headEqBody.bodyStr, elements);
            this.functionExpression.setDescription(headEqBody.headStr);
            this.functionExpression.UDFExpression = true;
            this.isVariadic = true;
            this.parametersNumber = -1;
            this.description = "";
            this.functionBodyType = 1;
            this.registerNoSyntaxErrorInDefinition();
            return;
        }
        this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionDefinitionString(functionDefinitionString));
    }

    public void setDescription(String description) {
        if (description == null) {
            return;
        }
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getFunctionExpressionString() {
        return this.functionExpression.getExpressionString();
    }

    public void setFunctionName(String functionName) {
        if (functionName == null) {
            if (!this.syntaxStatusDefinition) {
                this.registerSyntaxErrorInDefinition(StringModel.STRING_RESOURCES.PROVIDED_STRING_IS_NULL);
            }
            return;
        }
        String functionNameTrim = functionName.trim();
        if (this.functionName.equals(functionNameTrim)) {
            return;
        }
        if (!StringUtils.regexMatch(functionNameTrim, "(([a-zA-Z_])+([a-zA-Z0-9_])*|(\u03b1|\u03b2|\u03b3|\u03b4|\u03b5|\u03b6|\u03b7|\u03b8|\u03b9|\u03ba|\u03bb|\u03bc|\u03bd|\u03be|\u03bf|\u03c0|\u03c1|\u03c2|\u03c3|\u03c4|\u03c5|\u03c6|\u03c7|\u03c8|\u03c9|\u0391|\u0392|\u0393|\u0394|\u0395|\u0396|\u0397|\u0398|\u0399|\u039a|\u039b|\u039c|\u039d|\u039e|\u039f|\u03a0|\u03a1|\u03a3|\u03a4|\u03a5|\u03a6|\u03a7|\u03a8|\u03a9|\u2211|\u220f|\u213f|\u2206|\u2207|\u222b|\u213c|\u2107|\u2147|\u212f|\u2202))")) {
            if (!this.syntaxStatusDefinition) {
                this.registerSyntaxErrorInDefinition(Function.buildErrorMessageInvalidFunctionName(functionName));
            }
            return;
        }
        this.functionName = functionNameTrim;
        this.registerNoSyntaxErrorInDefinition();
        this.setExpressionModifiedFlags();
    }

    public void setArgumentValue(int argumentIndex, double argumentValue) {
        if (argumentIndex < 0 || argumentIndex >= this.parametersNumber) {
            return;
        }
        if (this.isVariadic) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.argumentsList.get((int)argumentIndex).argumentValue = argumentValue;
        } else {
            this.functionExtension.setParameterValue(argumentIndex, argumentValue);
        }
    }

    public int getFunctionBodyType() {
        return this.functionBodyType;
    }

    public boolean checkSyntax() {
        if (!this.syntaxStatusDefinition) {
            return false;
        }
        if (this.functionName.isEmpty()) {
            return false;
        }
        if (this.functionBodyType == 2) {
            if (!this.isVariadic && this.functionExtension == null) {
                return false;
            }
            return !this.isVariadic || this.functionExtensionVariadic != null;
        }
        boolean syntaxStatus = this.functionExpression.checkSyntax();
        this.checkRecursiveMode();
        return syntaxStatus;
    }

    public String getErrorMessage() {
        if (!this.syntaxStatusDefinition) {
            return this.errorMessageDefinition;
        }
        if (this.functionName.isEmpty()) {
            return this.errorMessageDefinition;
        }
        if (this.functionBodyType == 2) {
            if (!this.isVariadic && this.functionExtension == null) {
                return this.errorMessageDefinition;
            }
            if (this.isVariadic && this.functionExtensionVariadic == null) {
                return this.errorMessageDefinition;
            }
        }
        String functionExpressionErrorMessage = this.functionExpression.getErrorMessage();
        if (!this.errorMessageDefinition.isEmpty() && functionExpressionErrorMessage.isEmpty()) {
            return this.errorMessageDefinition;
        }
        return functionExpressionErrorMessage;
    }

    protected Function clone() {
        return new Function(this, false, null);
    }

    public double calculate() {
        return this.calculate((CalcStepsRegister)null);
    }

    public double calculate(CalcStepsRegister calcStepsRegister) {
        CalcStepsRegister.setUserFunction(calcStepsRegister, this);
        this.computingTime = 0.0;
        if (!this.syntaxStatusDefinition) {
            return Double.NaN;
        }
        double value = Double.NaN;
        if (this.functionBodyType == 1) {
            value = this.functionExpression.calculate(calcStepsRegister);
            this.computingTime = this.functionExpression.computingTime;
            return value;
        }
        License.checkLicense();
        long startTime = System.currentTimeMillis();
        if (!this.isVariadic) {
            value = this.functionExtension.calculate();
            this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return value;
        }
        List<Double> paramsList = this.functionExpression.UDFVariadicParamsAtRunTime;
        if (paramsList != null) {
            int n = paramsList.size();
            double[] parameters = new double[n];
            for (int i = 0; i < n; ++i) {
                parameters[i] = paramsList.get(i);
            }
            value = this.functionExtensionVariadic.calculate(parameters);
        }
        this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        return value;
    }

    public double calculate(double ... parameters) {
        int p;
        this.computingTime = 0.0;
        if (!this.syntaxStatusDefinition) {
            return Double.NaN;
        }
        if (parameters == null) {
            return Double.NaN;
        }
        if (parameters.length == 0) {
            return Double.NaN;
        }
        long startTime = System.currentTimeMillis();
        this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
        for (double x : parameters) {
            this.functionExpression.UDFVariadicParamsAtRunTime.add(x);
        }
        double value = Double.NaN;
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                value = this.functionExpression.calculate();
                this.computingTime = this.functionExpression.computingTime;
                return value;
            }
            value = this.functionExtensionVariadic.calculate(parameters);
            this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return value;
        }
        if (parameters.length != this.getParametersNumber()) {
            this.functionExpression.setSyntaxStatus(false, Function.buildErrorMessageIncorrectNumberOfFunctionParameters(this.functionName, this.getParametersNumber(), parameters.length));
            return Double.NaN;
        }
        if (this.functionBodyType == 1) {
            for (p = 0; p < parameters.length; ++p) {
                this.setArgumentValue(p, parameters[p]);
            }
            value = this.functionExpression.calculate();
            this.computingTime = this.functionExpression.computingTime;
            return value;
        }
        for (p = 0; p < parameters.length; ++p) {
            this.functionExtension.setParameterValue(p, parameters[p]);
        }
        value = this.functionExtension.calculate();
        this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        return value;
    }

    public double calculate(Argument ... arguments) {
        this.computingTime = 0.0;
        if (!this.syntaxStatusDefinition) {
            return Double.NaN;
        }
        if (arguments == null) {
            return Double.NaN;
        }
        if (arguments.length == 0) {
            return Double.NaN;
        }
        long startTime = System.currentTimeMillis();
        this.functionExpression.UDFVariadicParamsAtRunTime = new ArrayList<Double>();
        double[] parameters = new double[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            double x = arguments[i].getArgumentValue();
            this.functionExpression.UDFVariadicParamsAtRunTime.add(x);
            parameters[i] = x;
        }
        double value = Double.NaN;
        if (this.isVariadic) {
            if (this.functionBodyType == 1) {
                value = this.functionExpression.calculate();
                this.computingTime = this.functionExpression.computingTime;
                return value;
            }
            value = this.functionExtensionVariadic.calculate(parameters);
            this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
            return value;
        }
        if (arguments.length != this.getParametersNumber()) {
            this.functionExpression.setSyntaxStatus(false, Function.buildErrorMessageIncorrectNumberOfFunctionParameters(this.functionName, this.getParametersNumber(), arguments.length));
            return Double.NaN;
        }
        if (this.functionBodyType == 1) {
            for (int p = 0; p < arguments.length; ++p) {
                this.setArgumentValue(p, arguments[p].getArgumentValue());
            }
            value = this.functionExpression.calculate();
            this.computingTime = this.functionExpression.computingTime;
            return value;
        }
        for (int p = 0; p < arguments.length; ++p) {
            this.functionExtension.setParameterValue(p, arguments[p].getArgumentValue());
        }
        value = this.functionExtension.calculate();
        this.computingTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        return value;
    }

    public void addDefinitions(PrimitiveElement ... elements) {
        if (elements == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.addDefinitions(elements);
        }
    }

    public void removeDefinitions(PrimitiveElement ... elements) {
        if (elements == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.removeDefinitions(elements);
        }
    }

    private int countRecursiveArguments() {
        if (this.functionBodyType != 1) {
            return 0;
        }
        int numOfRecursiveArguments = 0;
        for (Argument argument : this.functionExpression.argumentsList) {
            if (argument.getArgumentType() != 3) continue;
            ++numOfRecursiveArguments;
        }
        return numOfRecursiveArguments;
    }

    public void addArguments(Argument ... arguments) {
        if (arguments == null) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.addArguments(arguments);
    }

    public void defineArguments(String ... argumentsNames) {
        if (argumentsNames == null) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.defineArguments(argumentsNames);
        this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
    }

    public void defineArgument(String argumentName, double argumentValue) {
        if (argumentName == null) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.defineArgument(argumentName, argumentValue);
        this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
    }

    public int getArgumentIndex(String argumentName) {
        if (argumentName == null) {
            return -1;
        }
        if (this.functionBodyType != 1) {
            return -1;
        }
        return this.functionExpression.getArgumentIndex(argumentName);
    }

    public Argument getArgument(String argumentName) {
        if (argumentName == null) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getArgument(argumentName);
    }

    public Argument getArgument(int argumentIndex) {
        if (argumentIndex < 0) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getArgument(argumentIndex);
    }

    public int getParametersNumber() {
        if (!this.isVariadic) {
            return this.parametersNumber;
        }
        if (this.functionExpression.UDFVariadicParamsAtRunTime == null) {
            return -1;
        }
        return this.functionExpression.UDFVariadicParamsAtRunTime.size();
    }

    public void setParametersNumber(int parametersNumber) {
        if (parametersNumber < 0) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.parametersNumber = parametersNumber;
        this.functionExpression.setExpressionModifiedFlag();
    }

    public String getParameterName(int parameterIndex) {
        if (parameterIndex < 0) {
            return "";
        }
        if (parameterIndex >= this.parametersNumber) {
            return "";
        }
        if (this.functionBodyType == 1) {
            Argument x = this.getArgument(parameterIndex);
            if (x == null) {
                return "";
            }
            return x.getArgumentName();
        }
        if (this.functionBodyType == 2) {
            return this.functionExtension.getParameterName(parameterIndex);
        }
        return "";
    }

    public int getArgumentsNumber() {
        if (this.functionBodyType != 1) {
            return 0;
        }
        return this.functionExpression.getArgumentsNumber();
    }

    public void removeArguments(String ... argumentsNames) {
        if (argumentsNames == null) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.removeArguments(argumentsNames);
        this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
    }

    public void removeArguments(Argument ... arguments) {
        if (arguments == null) {
            return;
        }
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.removeArguments(arguments);
        this.parametersNumber = this.functionExpression.getArgumentsNumber() - this.countRecursiveArguments();
    }

    public void removeAllArguments() {
        if (this.functionBodyType != 1) {
            return;
        }
        this.functionExpression.removeAllArguments();
        this.parametersNumber = 0;
    }

    public void addConstants(Constant ... constants) {
        if (constants == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(constants);
        }
    }

    public void addConstants(List<Constant> constantsList) {
        if (constantsList == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.addConstants(constantsList);
        }
    }

    public void defineConstant(String constantName, double constantValue) {
        if (constantName == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.defineConstant(constantName, constantValue);
        }
    }

    public int getConstantIndex(String constantName) {
        if (constantName == null) {
            return -1;
        }
        if (this.functionBodyType != 1) {
            return -1;
        }
        return this.functionExpression.getConstantIndex(constantName);
    }

    public Constant getConstant(String constantName) {
        if (constantName == null) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getConstant(constantName);
    }

    public Constant getConstant(int constantIndex) {
        if (constantIndex < 0) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getConstant(constantIndex);
    }

    public int getConstantsNumber() {
        if (this.functionBodyType != 1) {
            return 0;
        }
        return this.functionExpression.getConstantsNumber();
    }

    public void removeConstants(String ... constantsNames) {
        if (constantsNames == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(constantsNames);
        }
    }

    public void removeConstants(Constant ... constants) {
        if (constants == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.removeConstants(constants);
        }
    }

    public void removeAllConstants() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllConstants();
        }
    }

    public void addFunctions(Function ... functions) {
        if (functions == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.addFunctions(functions);
        }
    }

    public void defineFunction(String functionName, String functionExpressionString, String ... argumentsNames) {
        if (functionName == null || functionExpressionString == null || argumentsNames == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.defineFunction(functionName, functionExpressionString, argumentsNames);
        }
    }

    public int getFunctionIndex(String functionName) {
        if (functionName == null) {
            return -1;
        }
        if (this.functionBodyType != 1) {
            return -1;
        }
        return this.functionExpression.getFunctionIndex(functionName);
    }

    public Function getFunction(String functionName) {
        if (functionName == null) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getFunction(functionName);
    }

    public Function getFunction(int functionIndex) {
        if (functionIndex < 0) {
            return null;
        }
        if (this.functionBodyType != 1) {
            return null;
        }
        return this.functionExpression.getFunction(functionIndex);
    }

    public int getFunctionsNumber() {
        if (this.functionBodyType != 1) {
            return 0;
        }
        int recursiveThisCorrection = 0;
        for (Function f : this.functionExpression.functionsList) {
            if (this != f) continue;
            ++recursiveThisCorrection;
        }
        return this.functionExpression.getFunctionsNumber() - recursiveThisCorrection;
    }

    public void removeFunctions(String ... functionsNames) {
        if (functionsNames == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(functionsNames);
        }
    }

    public void removeFunctions(Function ... functions) {
        if (functions == null) {
            return;
        }
        if (this.functionBodyType == 1) {
            this.functionExpression.removeFunctions(functions);
        }
    }

    public void removeAllFunctions() {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeAllFunctions();
        }
    }

    public void setVerboseMode() {
        this.functionExpression.setVerboseMode();
    }

    public void setSilentMode() {
        this.functionExpression.setSilentMode();
    }

    public boolean getVerboseMode() {
        return this.functionExpression.getVerboseMode();
    }

    void checkRecursiveMode() {
        if (this.functionBodyType != 1) {
            return;
        }
        if (this.functionExpression.initialTokens == null) {
            return;
        }
        this.functionExpression.disableRecursiveMode();
        for (Token t : this.functionExpression.initialTokens) {
            if (!t.tokenStr.equals(this.functionName)) continue;
            this.functionExpression.setRecursiveMode();
            break;
        }
    }

    public boolean getRecursiveMode() {
        return this.functionExpression.getRecursiveMode();
    }

    public double getComputingTime() {
        return this.computingTime;
    }

    void addRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.addRelatedExpression(expression);
        }
    }

    void removeRelatedExpression(Expression expression) {
        if (this.functionBodyType == 1) {
            this.functionExpression.removeRelatedExpression(expression);
        }
    }

    void setExpressionModifiedFlags() {
        if (this.functionBodyType == 1) {
            this.functionExpression.setExpressionModifiedFlag();
        }
    }

    Function cloneForThreadSafeInternal(CloneCache cloneCache) {
        Function functionClone = cloneCache.getFunctionClone(this);
        if (functionClone == null) {
            cloneCache.cacheCloneInProgress(this);
            functionClone = new Function(this, true, cloneCache);
            cloneCache.clearCloneInProgress(this);
            cloneCache.cacheFunctionClone(this, functionClone);
        }
        return functionClone;
    }

    Function cloneForThreadSafeInternal(Expression relatedExpressionThatInitiatedClone, CloneCache cloneCache) {
        Function functionClone = this.cloneForThreadSafeInternal(cloneCache);
        functionClone.addRelatedExpression(relatedExpressionThatInitiatedClone);
        return functionClone;
    }

    public Function cloneForThreadSafe() {
        CloneCache cloneCache = new CloneCache();
        Function functionClone = this.cloneForThreadSafeInternal(cloneCache);
        cloneCache.addAllAtTheEndElements();
        cloneCache.clearCache();
        return functionClone;
    }
}

