/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.holoui;

import com.cleanroommc.modularui.holoui.HoloScreenEntity;
import com.cleanroommc.modularui.holoui.Plane3D;
import com.cleanroommc.modularui.holoui.ScreenOrientation;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.UISettings;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class HoloUI {
    private static final Map<ResourceLocation, Supplier<ModularScreen>> syncedHolos = new Object2ObjectOpenHashMap();

    public static void registerSyncedHoloUI(ResourceLocation loc, Supplier<ModularScreen> screen) {
        syncedHolos.put(loc, screen);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private double x;
        private double y;
        private double z;
        private Plane3D plane3D = new Plane3D();
        private ScreenOrientation orientation = ScreenOrientation.FIXED;

        public Builder at(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
            return this;
        }

        public Builder inFrontOf(EntityPlayer player, double distance, boolean fixed) {
            Vec3 look = player.func_70040_Z();
            this.orientation = fixed ? ScreenOrientation.FIXED : ScreenOrientation.TO_PLAYER;
            return this.at(player.field_70165_t + look.field_72450_a * distance, player.field_70163_u + (double)player.func_70047_e() + look.field_72448_b * distance, player.field_70161_v + look.field_72449_c * distance);
        }

        public Builder faceToPlayer() {
            this.orientation = ScreenOrientation.TO_PLAYER;
            return this;
        }

        public Builder faceTo(float x, float y, float z) {
            this.orientation = ScreenOrientation.FIXED;
            this.plane3D.setNormal(x, y, z);
            return this;
        }

        public Builder screenAnchor(float x, float y) {
            this.plane3D.setAnchor(x, y);
            return this;
        }

        public Builder virtualScreenSize(int width, int height) {
            this.plane3D.setSize(width, height);
            return this;
        }

        public Builder screenScale(float scale) {
            this.plane3D.setScale(scale);
            return this;
        }

        public Builder plane(Plane3D plane) {
            this.plane3D = plane;
            return this;
        }

        public void open(ModularScreen screen) {
            UISettings settings = new UISettings();
            settings.getNEISettings().disableNEI();
            screen.getContext().setSettings(settings);
            HoloScreenEntity holoScreenEntity = new HoloScreenEntity((World)Minecraft.func_71410_x().field_71441_e, this.plane3D);
            holoScreenEntity.func_70107_b(this.x, this.y, this.z);
            holoScreenEntity.setScreen(screen);
            holoScreenEntity.spawnInWorld();
            holoScreenEntity.setOrientation(this.orientation);
        }
    }
}

