/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.base.Preconditions;
import openmods.calc.ExecutionErrorException;
import openmods.calc.Frame;
import openmods.calc.IExecutable;
import openmods.calc.ISymbol;

public class SymbolGet<E>
implements IExecutable<E> {
    private final String id;

    public SymbolGet(String id) {
        this.id = id;
    }

    @Override
    public void execute(Frame<E> frame) {
        ISymbol<E> symbol = frame.symbols().get(this.id);
        Preconditions.checkNotNull(symbol, (String)"Unknown symbol: %s", (Object[])new Object[]{this.id});
        try {
            frame.stack().push(symbol.get());
        }
        catch (ExecutionErrorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get symbol '" + this.id + "'", e);
        }
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SymbolGet) {
            SymbolGet other = (SymbolGet)obj;
            return other.id.equals(this.id);
        }
        return false;
    }

    public String toString() {
        return "@" + this.id;
    }
}

