/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class LittleTileVec {
    public int x;
    public int y;
    public int z;

    public LittleTileVec(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "x") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "x"), nbt.func_74771_c(name + "y"), nbt.func_74771_c(name + "z"));
            this.writeToNBT(name, nbt);
        } else {
            this.set(nbt.func_74762_e(name + "x"), nbt.func_74762_e(name + "y"), nbt.func_74762_e(name + "z"));
        }
    }

    public LittleTileVec(Vec3 vec) {
        this((int)vec.field_72450_a, (int)vec.field_72448_b, (int)vec.field_72449_c);
    }

    public LittleTileVec(int x, int y, int z) {
        this.set(x, y, z);
    }

    public void set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public double getPosX() {
        return (double)this.x / 16.0;
    }

    public double getPosY() {
        return (double)this.y / 16.0;
    }

    public double getPosZ() {
        return (double)this.z / 16.0;
    }

    public void addVec(LittleTileVec vec) {
        this.x += vec.x;
        this.y += vec.y;
        this.z += vec.z;
    }

    public void subVec(LittleTileVec vec) {
        this.x -= vec.x;
        this.y -= vec.y;
        this.z -= vec.z;
    }

    public double distanceTo(LittleTileVec vec) {
        return Math.sqrt(Math.pow(vec.x - this.x, 2.0) + Math.pow(vec.y - this.y, 2.0) + Math.pow(vec.z - this.z, 2.0));
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileVec) {
            return this.x == ((LittleTileVec)object).x && this.y == ((LittleTileVec)object).y && this.z == ((LittleTileVec)object).z;
        }
        return super.equals(object);
    }

    public LittleTileVec copy() {
        return new LittleTileVec(this.x, this.y, this.z);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74768_a(name + "x", this.x);
        nbt.func_74768_a(name + "y", this.y);
        nbt.func_74768_a(name + "z", this.z);
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "," + this.z + "]";
    }

    public void invert() {
        this.set(-this.x, -this.y, -this.z);
    }
}

